/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.declarative.test;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.SourceVersion;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Task;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserFactory;
import org.netbeans.modules.parsing.spi.SourceModificationEvent;

public class TestParser
extends Parser {
    private TestResult result;
    private static final Pattern TEST_CASE_HEADER = Pattern.compile("%%TestCase[ \t]+([^ \t\n]*)(([ \t]+[^ \t\n]*)*)\n");
    private static final Pattern LEADS_TO_HEADER = Pattern.compile("%%=>\n");
    private static final String SOURCE_LEVEL = "source-level=";
    private static final String DISABLED = "DISABLED";
    private static final SourceVersion DEFAULT_SOURCE_LEVEL = SourceVersion.RELEASE_5;

    public void parse(Snapshot snapshot, Task task, SourceModificationEvent event) throws ParseException {
        this.result = new TestResult(snapshot, TestParser.parse(snapshot.getText().toString()));
    }

    public Parser.Result getResult(Task task) throws ParseException {
        return this.result;
    }

    public void cancel() {
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public static TestCase[] parse(String tests) {
        TestCase tc;
        LinkedList<TestCase> result = new LinkedList<TestCase>();
        int codeIndex = -1;
        int testCaseIndex = -1;
        String lastName = null;
        String lastOptions = null;
        Matcher m = TEST_CASE_HEADER.matcher(tests);
        while (m.find()) {
            if (testCaseIndex >= 0 && (tc = TestParser.handleTestCase(testCaseIndex, lastName, lastOptions, codeIndex, tests.substring(codeIndex, m.start()))) != null) {
                result.add(tc);
            }
            codeIndex = m.end();
            testCaseIndex = m.start();
            lastName = m.group(1);
            lastOptions = m.group(2);
        }
        if (testCaseIndex >= 0 && (tc = TestParser.handleTestCase(testCaseIndex, lastName, lastOptions, codeIndex, tests.substring(codeIndex))) != null) {
            result.add(tc);
        }
        return result.toArray(new TestCase[result.size()]);
    }

    @CheckForNull
    private static TestCase handleTestCase(int testCaseIndex, String testName, String options, int codeIndex, String testCase) {
        Matcher m = LEADS_TO_HEADER.matcher(testCase);
        String code = null;
        LinkedList<String> results = new LinkedList<String>();
        LinkedList<Integer> startIndices = new LinkedList<Integer>();
        LinkedList<Integer> endIndices = new LinkedList<Integer>();
        int lastStartIndex = -1;
        int lastIndex = -1;
        while (m.find()) {
            if (code == null) {
                code = testCase.substring(0, m.start());
            } else {
                results.add(testCase.substring(lastIndex, m.start()));
                if (!startIndices.isEmpty()) {
                    endIndices.add((Integer)startIndices.get(startIndices.size() - 1));
                }
                startIndices.add(lastIndex);
            }
            lastStartIndex = m.start();
            lastIndex = m.end();
        }
        if (code == null) {
            code = testCase;
        } else {
            results.add(testCase.substring(lastIndex));
            if (!startIndices.isEmpty()) {
                endIndices.add((Integer)startIndices.get(startIndices.size() - 1));
            }
            startIndices.add(lastIndex);
            endIndices.add(testCase.length());
        }
        int[] startIndicesArr = new int[startIndices.size()];
        int[] endIndicesArr = new int[endIndices.size()];
        assert (startIndicesArr.length == endIndicesArr.length);
        int c = 0;
        for (Integer i : startIndices) {
            startIndicesArr[c++] = codeIndex + i;
        }
        c = 0;
        for (Integer i : endIndices) {
            endIndicesArr[c++] = codeIndex + i;
        }
        SourceVersion sourceLevel = DEFAULT_SOURCE_LEVEL;
        for (String option : options.split("[ \t]+")) {
            if ((option = option.trim()).startsWith(SOURCE_LEVEL)) {
                option = option.substring(SOURCE_LEVEL.length());
                for (SourceVersion v : SourceVersion.values()) {
                    if (!option.equals("1." + v.name().substring("RELEASE_".length()))) continue;
                    sourceLevel = v;
                    break;
                }
            }
            if (!DISABLED.equals(option)) continue;
            return null;
        }
        return new TestCase(testName, sourceLevel, code, results.toArray(new String[0]), testCaseIndex, codeIndex, startIndicesArr, endIndicesArr);
    }

    public static final class TestCase {
        private final String name;
        private final SourceVersion sourceLevel;
        private final String code;
        private final String[] results;
        private final int testCaseStart;
        private final int codeStart;
        private final int[] resultsStart;
        private final int[] resultsEnd;

        private TestCase(String name, SourceVersion sourceLevel, String code, String[] results, int testCaseStart, int codeStart, int[] resultsStart, int[] resultsEnd) {
            this.name = name;
            this.sourceLevel = sourceLevel;
            this.code = code;
            this.results = results;
            this.testCaseStart = testCaseStart;
            this.codeStart = codeStart;
            this.resultsStart = resultsStart;
            this.resultsEnd = resultsEnd;
        }

        public String getCode() {
            return this.code;
        }

        public int getCodeStart() {
            return this.codeStart;
        }

        public String getName() {
            return this.name;
        }

        public String[] getResults() {
            return this.results;
        }

        public int[] getResultsStart() {
            return this.resultsStart;
        }

        public int[] getResultsEnd() {
            return this.resultsEnd;
        }

        public int getTestCaseStart() {
            return this.testCaseStart;
        }

        public SourceVersion getSourceLevel() {
            return this.sourceLevel;
        }

        public String toString() {
            return this.name + ":" + this.code + ":" + Arrays.toString(this.results) + ":" + this.testCaseStart + ":" + this.codeStart + ":" + Arrays.toString(this.resultsStart);
        }
    }

    public static final class FactoryImpl
    extends ParserFactory {
        public Parser createParser(Collection<Snapshot> snapshots) {
            System.err.println("create");
            return new TestParser();
        }
    }

    public static final class TestResult
    extends Parser.Result {
        private final TestCase[] tests;

        public TestResult(Snapshot snapshot, TestCase[] tests) {
            super(snapshot);
            this.tests = tests;
        }

        public TestCase[] getTests() {
            return this.tests;
        }

        protected void invalidate() {
        }
    }
}

