/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querymodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.modules.db.sql.visualeditor.querymodel.ColumnNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.ColumnProvider;
import org.netbeans.modules.db.sql.visualeditor.querymodel.From;
import org.netbeans.modules.db.sql.visualeditor.querymodel.FromNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.GroupBy;
import org.netbeans.modules.db.sql.visualeditor.querymodel.GroupByNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Having;
import org.netbeans.modules.db.sql.visualeditor.querymodel.HavingNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.OrderBy;
import org.netbeans.modules.db.sql.visualeditor.querymodel.OrderByNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Query;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Select;
import org.netbeans.modules.db.sql.visualeditor.querymodel.SelectNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Table;
import org.netbeans.modules.db.sql.visualeditor.querymodel.TableNode;
import org.netbeans.modules.db.sql.visualeditor.querymodel.Where;
import org.netbeans.modules.db.sql.visualeditor.querymodel.WhereNode;

public class QueryNode
implements Query {
    SelectNode _select;
    FromNode _from;
    WhereNode _where;
    GroupByNode _groupBy;
    HavingNode _having;
    OrderByNode _orderBy;

    public QueryNode() {
    }

    public QueryNode(SelectNode select, FromNode from, WhereNode where, GroupByNode groupBy, HavingNode having, OrderByNode orderBy) {
        this._select = select;
        this._from = from;
        this._where = where;
        this._groupBy = groupBy;
        this._having = having;
        this._orderBy = orderBy;
    }

    public QueryNode(SelectNode select, FromNode from) {
        this(select, from, null, null, null, null);
    }

    @Override
    public String genText(SQLIdentifiers.Quoter quoter) {
        String res = this._select.genText(quoter) + " " + this._from.genText(quoter);
        if (this._where != null) {
            res = res + this._where.genText(quoter);
        }
        if (this._groupBy != null) {
            res = res + this._groupBy.genText(quoter);
        }
        if (this._having != null) {
            res = res + this._having.genText(quoter);
        }
        if (this._orderBy != null) {
            res = res + this._orderBy.genText(quoter);
        }
        return res;
    }

    public String toString() {
        return this._select.toString() + this._from.toString() + this._where.toString();
    }

    @Override
    public Select getSelect() {
        return this._select;
    }

    @Override
    public void setSelect(Select select) {
        this._select = (SelectNode)select;
    }

    @Override
    public From getFrom() {
        return this._from;
    }

    @Override
    public void setFrom(From from) {
        this._from = (FromNode)from;
    }

    @Override
    public Where getWhere() {
        return this._where;
    }

    @Override
    public void setWhere(Where where) {
        this._where = (WhereNode)where;
    }

    @Override
    public GroupBy getGroupBy() {
        return this._groupBy;
    }

    @Override
    public void setGroupBy(GroupBy groupBy) {
        this._groupBy = (GroupByNode)groupBy;
    }

    @Override
    public OrderBy getOrderBy() {
        return this._orderBy;
    }

    @Override
    public void setOrderBy(OrderBy orderBy) {
        this._orderBy = (OrderByNode)orderBy;
    }

    @Override
    public Having getHaving() {
        return this._having;
    }

    @Override
    public void setHaving(Having having) {
        this._having = (HavingNode)having;
    }

    @Override
    public void removeTable(String tableSpec) {
        this._from.removeTable(tableSpec);
        this._select.removeTable(tableSpec);
        if (this._where != null) {
            this._where.removeTable(tableSpec);
            if (this._where.getExpression() == null) {
                this._where = null;
            }
        }
        if (this._groupBy != null) {
            this._groupBy.removeTable(tableSpec);
            if (this._from._tableList.size() == 0) {
                this._groupBy = null;
            }
        }
        this.removeSortSpecification(tableSpec);
    }

    @Override
    public void replaceStar(ColumnProvider tableReader) {
        if (this._select.hasAsteriskQualifier()) {
            ArrayList<ColumnNode> columns = new ArrayList<ColumnNode>();
            List<Table> tables = this._from.getTables();
            for (int i = 0; i < tables.size(); ++i) {
                TableNode tbl = (TableNode)tables.get(i);
                String fullTableName = tbl.getFullTableName();
                ArrayList columnNames = new ArrayList();
                tableReader.getColumnNames(fullTableName, columnNames);
                String corrName = tbl.getCorrName();
                String tableName = tbl.getTableName();
                String schemaName = tbl.getSchemaName();
                for (int j = 0; j < columnNames.size(); ++j) {
                    String columnName = (String)columnNames.get(j);
                    columns.add(new ColumnNode(tableName, columnName, corrName, schemaName));
                }
            }
            this._select.setColumnList(columns);
        }
    }

    @Override
    public void addColumn(String tableSpec, String columnName) {
        Table table = this._from.findTable(tableSpec);
        ColumnNode col = new ColumnNode(table, columnName);
        this._select.addColumn(col);
        if (this._groupBy != null) {
            this._groupBy.addColumn(col);
        }
    }

    @Override
    public void removeColumn(String tableSpec, String columnName) {
        this._select.removeColumn(tableSpec, columnName);
        if (this._groupBy != null) {
            this._groupBy.removeColumn(tableSpec, columnName);
        }
        this.removeSortSpecification(tableSpec, columnName);
    }

    @Override
    public void renameTableSpec(String oldTableSpec, String corrName) {
        this._from.renameTableSpec(oldTableSpec, corrName);
        this._select.renameTableSpec(oldTableSpec, corrName);
        if (this._where != null) {
            this._where.renameTableSpec(oldTableSpec, corrName);
        }
        if (this._groupBy != null) {
            this._groupBy.renameTableSpec(oldTableSpec, corrName);
        }
        if (this._having != null) {
            this._having.renameTableSpec(oldTableSpec, corrName);
        }
        if (this._orderBy != null) {
            this._orderBy.renameTableSpec(oldTableSpec, corrName);
        }
    }

    @Override
    public void getReferencedColumns(Collection columns) {
        this._from.getReferencedColumns(columns);
        this._select.getReferencedColumns(columns);
        if (this._where != null) {
            this._where.getReferencedColumns(columns);
        }
        if (this._groupBy != null) {
            this._groupBy.getReferencedColumns(columns);
        }
        if (this._having != null) {
            this._having.getReferencedColumns(columns);
        }
        if (this._orderBy != null) {
            this._orderBy.getReferencedColumns(columns);
        }
    }

    private void removeSortSpecification(String tableSpec) {
        if (this._orderBy != null) {
            this._orderBy.removeSortSpecification(tableSpec);
        }
    }

    private void removeSortSpecification(String tableSpec, String columnName) {
        if (this._orderBy != null) {
            this._orderBy.removeSortSpecification(tableSpec, columnName);
        }
    }
}

