/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.client;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.DistributedPropertySet;
import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.PropertySet;
import com.sun.xml.ws.api.message.Packet;
import com.sun.xml.ws.client.ContentNegotiation;
import com.sun.xml.ws.transport.Headers;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.jvnet.ws.message.PropertySet;

public final class RequestContext
extends DistributedPropertySet {
    private static final Logger LOGGER = Logger.getLogger(RequestContext.class.getName());
    private static ContentNegotiation defaultContentNegotiation = ContentNegotiation.obtainFromSystemProperty();
    private final Map<String, Object> others;
    @NotNull
    private EndpointAddress endpointAddress;
    public ContentNegotiation contentNegotiation = defaultContentNegotiation;
    private String soapAction;
    private Boolean soapActionUse;
    private final MapView mapView = new MapView();
    private static final PropertySet.PropertyMap propMap = RequestContext.parse(RequestContext.class);

    @PropertySet.Property(value={"javax.xml.ws.service.endpoint.address"})
    public String getEndPointAddressString() {
        return this.endpointAddress != null ? this.endpointAddress.toString() : null;
    }

    public void setEndPointAddressString(String s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        this.endpointAddress = EndpointAddress.create(s);
    }

    public void setEndpointAddress(@NotNull EndpointAddress epa) {
        this.endpointAddress = epa;
    }

    @NotNull
    public EndpointAddress getEndpointAddress() {
        return this.endpointAddress;
    }

    @PropertySet.Property(value={"com.sun.xml.ws.client.ContentNegotiation"})
    public String getContentNegotiationString() {
        return this.contentNegotiation.toString();
    }

    public void setContentNegotiationString(String s) {
        if (s == null) {
            this.contentNegotiation = ContentNegotiation.none;
        } else {
            try {
                this.contentNegotiation = ContentNegotiation.valueOf(s);
            }
            catch (IllegalArgumentException e) {
                this.contentNegotiation = ContentNegotiation.none;
            }
        }
    }

    @PropertySet.Property(value={"javax.xml.ws.soap.http.soapaction.uri"})
    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String sAction) {
        if (sAction == null) {
            throw new IllegalArgumentException("SOAPAction value cannot be null");
        }
        this.soapAction = sAction;
    }

    @PropertySet.Property(value={"javax.xml.ws.soap.http.soapaction.use"})
    public Boolean getSoapActionUse() {
        return this.soapActionUse;
    }

    public void setSoapActionUse(Boolean sActionUse) {
        this.soapActionUse = sActionUse;
    }

    RequestContext() {
        this.others = new HashMap<String, Object>();
    }

    private RequestContext(RequestContext that) {
        this.others = new HashMap<String, Object>(that.others);
        this.mapView.fallbackMap = that.mapView.fallbackMap != null ? new HashMap(that.mapView.fallback()) : null;
        this.endpointAddress = that.endpointAddress;
        this.soapAction = that.soapAction;
        this.contentNegotiation = that.contentNegotiation;
        that.copySatelliteInto(this);
    }

    @Override
    public Object get(Object key) {
        if (super.supports(key)) {
            return super.get(key);
        }
        return this.others.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        if (super.supports(key)) {
            return super.put(key, value);
        }
        return this.others.put(key, value);
    }

    public Map<String, Object> getMapView() {
        return this.mapView;
    }

    public void fill(Packet packet, boolean isAddressingEnabled) {
        if (this.mapView.fallbackMap == null) {
            if (this.endpointAddress != null) {
                packet.endpointAddress = this.endpointAddress;
            }
            packet.contentNegotiation = this.contentNegotiation;
            if ((this.soapActionUse != null && this.soapActionUse.booleanValue() || this.soapActionUse == null && isAddressingEnabled) && this.soapAction != null) {
                packet.soapAction = this.soapAction;
            }
            if (!(isAddressingEnabled || this.soapActionUse != null && this.soapActionUse.booleanValue() || this.soapAction == null)) {
                LOGGER.warning("BindingProvider.SOAPACTION_URI_PROPERTY is set in the RequestContext but is ineffective, Either set BindingProvider.SOAPACTION_USE_PROPERTY to true or enable AddressingFeature");
            }
            this.copySatelliteInto(packet);
            if (!this.others.isEmpty()) {
                Headers headerFromPacketProperty = (Headers)packet.invocationProperties.get("javax.xml.ws.http.request.headers");
                Map headerFromOthers = (Map)this.others.get("javax.xml.ws.http.request.headers");
                if (headerFromPacketProperty != null && headerFromOthers != null) {
                    for (String key : headerFromOthers.keySet()) {
                        if (key == null || key.trim().length() == 0) continue;
                        List valueFromPacketProperty = (List)headerFromPacketProperty.get(key);
                        if (valueFromPacketProperty != null) {
                            valueFromPacketProperty.addAll((Collection)headerFromOthers.get(key));
                            continue;
                        }
                        headerFromPacketProperty.put(key, headerFromOthers.get(key));
                    }
                    this.others.put("javax.xml.ws.http.request.headers", headerFromPacketProperty);
                }
                packet.invocationProperties.putAll(this.others);
                packet.getHandlerScopePropertyNames(false).addAll(this.others.keySet());
            }
        } else {
            HashSet<String> handlerScopePropertyNames = new HashSet<String>();
            for (Map.Entry entry : this.mapView.fallbackMap.entrySet()) {
                String key = (String)entry.getKey();
                if (packet.supports(key)) {
                    packet.put(key, entry.getValue());
                } else {
                    packet.invocationProperties.put(key, entry.getValue());
                }
                if (super.supports(key)) continue;
                handlerScopePropertyNames.add(key);
            }
            if (!handlerScopePropertyNames.isEmpty()) {
                packet.getHandlerScopePropertyNames(false).addAll(handlerScopePropertyNames);
            }
        }
    }

    public RequestContext copy() {
        return new RequestContext(this);
    }

    @Override
    protected PropertySet.PropertyMap getPropertyMap() {
        return propMap;
    }

    private final class MapView
    implements Map<String, Object> {
        private Map<String, Object> fallbackMap;

        private MapView() {
        }

        private Map<String, Object> fallback() {
            if (this.fallbackMap == null) {
                this.fallbackMap = new HashMap<String, Object>(RequestContext.this.others);
                this.fallbackMap.putAll(RequestContext.this.createMapView());
            }
            return this.fallbackMap;
        }

        @Override
        public int size() {
            return this.fallback().size();
        }

        @Override
        public boolean isEmpty() {
            return this.fallback().isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.fallback().containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.fallback().containsValue(value);
        }

        @Override
        public Object get(Object key) {
            if (this.fallbackMap == null) {
                return RequestContext.this.get(key);
            }
            return this.fallback().get(key);
        }

        @Override
        public Object put(String key, Object value) {
            if (this.fallbackMap == null) {
                return RequestContext.this.put(key, value);
            }
            return this.fallback().put(key, value);
        }

        @Override
        public Object remove(Object key) {
            if (this.fallbackMap == null) {
                return RequestContext.this.remove(key);
            }
            return this.fallback().remove(key);
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> t) {
            for (Map.Entry<? extends String, ? extends Object> e : t.entrySet()) {
                this.put(e.getKey(), e.getValue());
            }
        }

        @Override
        public void clear() {
            this.fallback().clear();
        }

        @Override
        public Set<String> keySet() {
            return this.fallback().keySet();
        }

        @Override
        public Collection<Object> values() {
            return this.fallback().values();
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.fallback().entrySet();
        }
    }
}

