/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.gsp.editor;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.modules.csl.api.CslActions;
import org.netbeans.modules.html.editor.api.HtmlKit;
import org.openide.util.HelpCtx;

public class GspKit
extends HtmlKit {
    static final long serialVersionUID = -1381945567613910297L;

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.groovy.gsp.editor.GspKit");
    }

    public GspKit() {
        super("text/x-gsp");
    }

    public String getContentType() {
        return "text/x-gsp";
    }

    protected Action[] createActions() {
        Action[] superActions = super.createActions();
        return TextAction.augmentList(superActions, new Action[]{new GspDeleteCharAction("delete-previous", false), new GspDefaultKeyTypedAction(), CslActions.createSelectCodeElementAction((boolean)true), CslActions.createSelectCodeElementAction((boolean)false), CslActions.createCamelCasePositionAction((Action)GspKit.findAction(superActions, "caret-next-word"), (boolean)true), CslActions.createCamelCasePositionAction((Action)GspKit.findAction(superActions, "caret-previous-word"), (boolean)false), CslActions.createSelectCamelCasePositionAction((Action)GspKit.findAction(superActions, "selection-next-word"), (boolean)true), CslActions.createSelectCamelCasePositionAction((Action)GspKit.findAction(superActions, "selection-previous-word"), (boolean)false), CslActions.createDeleteToCamelCasePositionAction((Action)GspKit.findAction(superActions, "remove-word-next"), (boolean)true), CslActions.createDeleteToCamelCasePositionAction((Action)GspKit.findAction(superActions, "remove-word-previous"), (boolean)false), CslActions.createInstantRenameAction()});
    }

    private static Action findAction(Action[] actions, String name) {
        for (Action a : actions) {
            Object nameObj = a.getValue("Name");
            if (!(nameObj instanceof String) || !name.equals(nameObj)) continue;
            return a;
        }
        return null;
    }

    private boolean handleDeletion(BaseDocument doc, int dotPos) {
        return false;
    }

    private boolean handleInsertion(BaseDocument doc, Caret caret, char c) {
        return false;
    }

    public Object clone() {
        return new GspKit();
    }

    private static Token<?> getToken(BaseDocument doc, int offset, boolean checkEmbedded) {
        TokenSequence es;
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        TokenSequence ts = th.tokenSequence();
        ts.move(offset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return null;
        }
        if (checkEmbedded && (es = ts.embedded()) != null) {
            es.move(offset);
            if (es.moveNext() || es.movePrevious()) {
                return es.token();
            }
        }
        return ts.token();
    }

    private class GspDeleteCharAction
    extends ExtKit.ExtDeleteCharAction {
        public GspDeleteCharAction(String nm, boolean nextChar) {
            super(nm, nextChar);
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            int dotPos;
            Caret caret = target.getCaret();
            BaseDocument doc = (BaseDocument)target.getDocument();
            if (GspKit.this.handleDeletion(doc, dotPos = caret.getDot())) {
                return;
            }
            super.actionPerformed(evt, target);
        }
    }

    private class GspDefaultKeyTypedAction
    extends ExtKit.ExtDefaultKeyTypedAction {
        private GspDefaultKeyTypedAction() {
        }

        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            char c;
            Caret caret = target.getCaret();
            BaseDocument doc = (BaseDocument)target.getDocument();
            String cmd = evt.getActionCommand();
            if (cmd.length() > 0 && GspKit.this.handleInsertion(doc, caret, c = cmd.charAt(0))) {
                return;
            }
            super.actionPerformed(evt, target);
        }
    }
}

