/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.v8debug.ui.annotation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.lib.v8debug.V8Frame;
import org.netbeans.lib.v8debug.V8Script;
import org.netbeans.modules.javascript.v8debug.ScriptsHandler;
import org.netbeans.modules.javascript.v8debug.V8Debugger;
import org.netbeans.modules.javascript.v8debug.frames.CallFrame;
import org.netbeans.modules.javascript.v8debug.frames.CallStack;
import org.netbeans.modules.javascript.v8debug.ui.EditorUtils;
import org.netbeans.modules.javascript.v8debug.ui.annotation.CallStackAnnotation;
import org.netbeans.modules.javascript.v8debug.ui.annotation.CurrentLineAnnotation;
import org.openide.filesystems.FileObject;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.RequestProcessor;

public final class CallStackAnnotationListener
extends DebuggerManagerAdapter
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(CallStackAnnotationListener.class.getName());
    private final List<Annotation> annotations = new ArrayList<Annotation>();
    private final Map<V8Debugger, V8Debugger.Listener> dbgListeners = new HashMap<V8Debugger, V8Debugger.Listener>();
    private volatile V8Debugger currentV8Dbg;
    private final RequestProcessor annotationProcessor = new RequestProcessor(CallStackAnnotationListener.class);

    public String[] getProperties() {
        return new String[]{"debuggerEngines", "currentEngine"};
    }

    public void engineAdded(DebuggerEngine engine) {
        V8Debugger dbg = (V8Debugger)engine.lookupFirst(null, V8Debugger.class);
        if (dbg != null) {
            DbgListener l = new DbgListener(dbg);
            this.dbgListeners.put(dbg, l);
            dbg.addListener((V8Debugger.Listener)l);
            if (dbg == this.currentV8Dbg) {
                this.annotationProcessor.post((Runnable)new AnnotateTask(dbg));
            }
        }
    }

    public void engineRemoved(DebuggerEngine engine) {
        V8Debugger dbg = (V8Debugger)engine.lookupFirst(null, V8Debugger.class);
        if (dbg != null) {
            V8Debugger.Listener l = this.dbgListeners.remove(dbg);
            dbg.removeListener(l);
            if (dbg == this.currentV8Dbg) {
                this.annotationProcessor.post((Runnable)new AnnotateTask(null));
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "currentEngine": {
                V8Debugger dbg;
                DebuggerEngine engine = (DebuggerEngine)evt.getNewValue();
                if (engine == null) break;
                this.currentV8Dbg = dbg = (V8Debugger)engine.lookupFirst(null, V8Debugger.class);
                this.annotationProcessor.post((Runnable)new AnnotateTask(dbg));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAnnotations(V8Debugger dbg) {
        this.clearAnnotations();
        if (!dbg.isSuspended()) {
            LOG.fine("updateAnnotations(), dbg is NOT suspended.");
            return;
        }
        CallStack cs = dbg.getCurrentCallStack();
        LOG.fine("updateAnnotations(), dbg IS suspended, call stack = " + cs);
        if (cs != null && !cs.isEmpty()) {
            ArrayList<Annotation> newAnnotations = new ArrayList<Annotation>();
            ScriptsHandler scriptsHandler = dbg.getScriptsHandler();
            boolean first = true;
            for (V8Frame f : cs.getFrames()) {
                Annotation anno;
                V8Script script = cs.getScript(f);
                if (script == null) continue;
                FileObject fo = scriptsHandler.getFile(script);
                Line line = EditorUtils.getLine(dbg, fo, (int)f.getLine(), (int)f.getColumn());
                if (line == null) {
                    first = false;
                    continue;
                }
                if (first) {
                    anno = new CurrentLineAnnotation((Annotatable)line);
                    EditorUtils.showLine(line, true);
                    first = false;
                } else {
                    anno = new CallStackAnnotation((Annotatable)line);
                }
                newAnnotations.add(anno);
            }
            List<Annotation> list = this.annotations;
            synchronized (list) {
                LOG.fine("Created and stored " + newAnnotations.size() + " annotations.");
                this.annotations.addAll(newAnnotations);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAnnotations() {
        List<Annotation> list = this.annotations;
        synchronized (list) {
            LOG.fine("Clearing " + this.annotations.size() + " annotations.");
            for (Annotation ann : this.annotations) {
                ann.detach();
            }
            this.annotations.clear();
        }
    }

    private final class AnnotateTask
    implements Runnable {
        private final V8Debugger dbg;

        public AnnotateTask(V8Debugger dbg) {
            this.dbg = dbg;
        }

        @Override
        public void run() {
            if (this.dbg != null) {
                CallStackAnnotationListener.this.updateAnnotations(this.dbg);
            } else {
                CallStackAnnotationListener.this.clearAnnotations();
            }
        }
    }

    private final class DbgListener
    implements V8Debugger.Listener {
        private final V8Debugger dbg;
        private volatile boolean topFrameShown;

        public DbgListener(V8Debugger dbg) {
            this.dbg = dbg;
        }

        public void notifySuspended(boolean suspended) {
            if (CallStackAnnotationListener.this.currentV8Dbg == this.dbg) {
                if (suspended) {
                    CallStackAnnotationListener.this.annotationProcessor.post((Runnable)new AnnotateTask(this.dbg));
                    this.topFrameShown = true;
                } else {
                    CallStackAnnotationListener.this.annotationProcessor.post((Runnable)new AnnotateTask(null));
                    this.topFrameShown = false;
                }
            }
        }

        public void notifyCurrentFrame(CallFrame cf) {
            if (cf == null) {
                return;
            }
            if (this.topFrameShown && cf.isTopFrame()) {
                return;
            }
            this.topFrameShown = false;
            EditorUtils.showFrameLine(this.dbg, cf, true);
        }

        public void notifyFinished() {
        }
    }
}

