/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.image;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.modules.image.ImageOpenSupport;
import org.netbeans.modules.image.ImagePrintSupport;
import org.openide.actions.OpenAction;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class ImageDataObject
extends MultiDataObject
implements CookieSet.Factory {
    static final long serialVersionUID = -6035788991669336965L;
    private static final String IMAGE_ICON_BASE = "org/netbeans/modules/image/imageObject.png";
    private transient ImageOpenSupport openSupport;
    private transient ImagePrintSupport printSupport;

    public ImageDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException {
        super(pf, loader);
        this.getCookieSet().add(ImageOpenSupport.class, (CookieSet.Factory)this);
        this.getCookieSet().add(ImagePrintSupport.class, (CookieSet.Factory)this);
    }

    public Node.Cookie createCookie(Class clazz) {
        if (clazz.isAssignableFrom(ImageOpenSupport.class)) {
            return this.getOpenSupport();
        }
        if (clazz.isAssignableFrom(ImagePrintSupport.class)) {
            return this.getPrintSupport();
        }
        return null;
    }

    public Lookup getLookup() {
        return this.getCookieSet().getLookup();
    }

    private synchronized ImageOpenSupport getOpenSupport() {
        if (this.openSupport == null) {
            this.openSupport = new ImageOpenSupport(this.getPrimaryEntry());
        }
        return this.openSupport;
    }

    protected synchronized ImagePrintSupport getPrintSupport() {
        if (this.printSupport == null) {
            this.printSupport = new ImagePrintSupport(this);
        }
        return this.printSupport;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    URL getImageURL() {
        return this.getPrimaryFile().toURL();
    }

    @Deprecated
    private byte[] getImageData() {
        try {
            FileObject fo = this.getPrimaryFile();
            byte[] imageData = new byte[(int)fo.getSize()];
            BufferedInputStream in = new BufferedInputStream(fo.getInputStream());
            in.read(imageData, 0, (int)fo.getSize());
            in.close();
            return imageData;
        }
        catch (IOException ioe) {
            return new byte[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImage() throws IOException {
        try (InputStream input = this.getPrimaryFile().getInputStream();){
            BufferedImage bufferedImage = ImageIO.read(input);
            return bufferedImage;
        }
    }

    protected Node createNodeDelegate() {
        return new ImageNode(this);
    }

    private static final class ImageNode
    extends DataNode {
        public ImageNode(ImageDataObject obj) {
            super((DataObject)obj, Children.LEAF);
            this.setIconBaseWithExtension(ImageDataObject.IMAGE_ICON_BASE);
            this.setDefaultAction(SystemAction.get(OpenAction.class));
        }

        protected Sheet createSheet() {
            Sheet s = super.createSheet();
            Sheet.Set ss = s.get("properties");
            if (ss == null) {
                ss = Sheet.createPropertiesSet();
                s.put(ss);
            }
            ss.put((Node.Property)new ImageWidthProperty());
            ss.put((Node.Property)new ImageHeightProperty());
            ss.put((Node.Property)new ThumbnailProperty(this.getDataObject()));
            return s;
        }

        private final class ImageHeightProperty
        extends PropertySupport.ReadOnly<Integer> {
            public ImageHeightProperty() {
                super("height", Integer.class, NbBundle.getMessage(ImageDataObject.class, (String)"PROP_Image_Height"), NbBundle.getMessage(ImageDataObject.class, (String)"HINT_Image_Height"));
            }

            public Integer getValue() throws InvocationTargetException {
                ImageIcon icon = new ImageIcon(ImageNode.this.getDataObject().getPrimaryFile().toURL());
                return icon.getIconHeight();
            }
        }

        private final class ImageWidthProperty
        extends PropertySupport.ReadOnly<Integer> {
            public ImageWidthProperty() {
                super("width", Integer.class, NbBundle.getMessage(ImageDataObject.class, (String)"PROP_Image_Width"), NbBundle.getMessage(ImageDataObject.class, (String)"HINT_Image_Width"));
            }

            public Integer getValue() throws InvocationTargetException {
                ImageIcon icon = new ImageIcon(ImageNode.this.getDataObject().getPrimaryFile().toURL());
                return icon.getIconWidth();
            }
        }

        private static final class ThumbnailProperty
        extends PropertySupport.ReadOnly<Icon> {
            private final DataObject obj;

            public ThumbnailProperty(DataObject obj) {
                super("thumbnail", Icon.class, NbBundle.getMessage(ImageDataObject.class, (String)"PROP_Thumbnail"), NbBundle.getMessage(ImageDataObject.class, (String)"HINT_Thumbnail"));
                this.obj = obj;
            }

            public Icon getValue() {
                return new ImageIcon(this.obj.getPrimaryFile().toURL());
            }

            public PropertyEditor getPropertyEditor() {
                return new ThumbnailPropertyEditor();
            }

            private final class ThumbnailPropertyEditor
            extends PropertyEditorSupport {
                private ThumbnailPropertyEditor() {
                }

                @Override
                public boolean isPaintable() {
                    return true;
                }

                @Override
                public void paintValue(Graphics g, Rectangle r) {
                    ImageIcon icon = null;
                    icon = (ImageIcon)ThumbnailProperty.this.getValue();
                    if (icon != null) {
                        int iconWidth = icon.getIconWidth();
                        int iconHeight = icon.getIconHeight();
                        double scale = (double)iconWidth / (double)iconHeight;
                        if (iconWidth > r.width) {
                            iconWidth = r.width;
                            iconHeight = (int)((double)iconWidth / scale);
                        }
                        if (iconHeight > r.height) {
                            iconHeight = r.height;
                            iconWidth = (int)((double)iconHeight * scale);
                        }
                        int x = iconWidth < r.x ? (r.x - iconWidth) / 2 : 5;
                        int y = iconHeight < r.y ? (r.y - iconHeight) / 2 : 0;
                        Graphics g2 = g.create(r.x, r.y, r.width, r.height);
                        g.drawImage(icon.getImage(), x, y, iconWidth, iconHeight, null);
                    }
                }

                @Override
                public String getAsText() {
                    return null;
                }
            }
        }
    }
}

