/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.input;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.tregex.nodes.input.InputLengthNodeGen;
import com.oracle.truffle.regex.tregex.util.Exceptions;

@GenerateUncached
public abstract class InputLengthNode
extends Node {
    public static InputLengthNode create() {
        return InputLengthNodeGen.create();
    }

    public abstract int execute(Object var1);

    @Specialization
    static int doBytes(byte[] input) {
        return input.length;
    }

    @Specialization
    static int doString(String input) {
        return input.length();
    }

    @Specialization(guards={"inputs.hasArrayElements(input)"}, limit="2")
    static int doTruffleObj(Object input, @CachedLibrary(value="input") InteropLibrary inputs) {
        try {
            long length = inputs.getArraySize(input);
            if (length > Integer.MAX_VALUE) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw Exceptions.shouldNotReachHere();
            }
            return (int)length;
        }
        catch (UnsupportedMessageException e) {
            throw Exceptions.shouldNotReachHere();
        }
    }
}

