/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.disco;

import java.awt.Component;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.checkerframework.checker.guieffect.qual.UIEffect;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.modules.java.disco.BrowseWizardPanel;
import org.netbeans.modules.java.disco.DownloadWizardPanel;
import org.netbeans.modules.java.disco.J2SEPlatformUtils;
import org.netbeans.modules.java.disco.SelectPackageWizardPanel;
import org.netbeans.modules.java.disco.WizardState;
import org.openide.WizardDescriptor;

public final class FoojayPlatformIt
implements WizardDescriptor.InstantiatingIterator<WizardDescriptor> {
    public static final String PROP_DOWNLOAD = "download";
    public static final String PROP_DOWNLOAD_FOLDER = "downloadFolder";
    private int index;
    private List<WizardDescriptor.Panel<WizardDescriptor>> panels;
    private WizardDescriptor wizard;
    private WizardState state = new WizardState();
    private String[] names;
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();

    private List<WizardDescriptor.Panel<WizardDescriptor>> getPanels() {
        if (this.panels == null) {
            this.panels = new ArrayList<WizardDescriptor.Panel<WizardDescriptor>>();
            this.panels.add((WizardDescriptor.Panel<WizardDescriptor>)new SelectPackageWizardPanel(this.state));
            this.panels.add((WizardDescriptor.Panel<WizardDescriptor>)new BrowseWizardPanel(this.state));
            this.panels.add((WizardDescriptor.Panel<WizardDescriptor>)new DownloadWizardPanel(this.state));
            String[] steps = new String[this.panels.size()];
            for (int i = 0; i < this.panels.size(); ++i) {
                Component c = this.panels.get(i).getComponent();
                steps[i] = c.getName();
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", true);
                jc.putClientProperty("WizardPanel_contentDisplayed", true);
                jc.putClientProperty("WizardPanel_contentNumbered", true);
            }
        }
        return this.panels;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.getPanels().get(this.index);
    }

    public String name() {
        return this.index + 1 + ". from " + this.getPanels().size();
    }

    public boolean hasNext() {
        return this.index < this.getPanels().size() - 1;
    }

    public boolean hasPrevious() {
        return this.index == 1;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    @UIEffect
    protected void fireChangeListeners() {
        ChangeEvent ce = new ChangeEvent(this);
        for (ChangeListener l : this.listeners) {
            l.stateChanged(ce);
        }
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
        this.getPanels();
    }

    public Set<JavaPlatform> instantiate() throws IOException {
        String downloadedFolder = (String)this.wizard.getProperty(PROP_DOWNLOAD);
        if (downloadedFolder != null) {
            File f = new File(downloadedFolder);
            if (!f.isDirectory()) {
                Desktop.getDesktop().open(f.getParentFile());
                return Collections.EMPTY_SET;
            }
            String name = this.state.selection.getJavaPlatformDisplayName();
            return Collections.singleton(J2SEPlatformUtils.register(new File(downloadedFolder), name));
        }
        return Collections.EMPTY_SET;
    }

    public void uninitialize(WizardDescriptor wd) {
    }
}

