/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc;

import com.oracle.bmc.Service;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Services {
    private static final Logger LOG = LoggerFactory.getLogger(Services.class);
    private static final Map<String, Service> SERVICE_CACHE = new HashMap<String, Service>();

    @Deprecated
    public static Service create(String serviceName, String serviceEndpointPrefix) {
        return Services.serviceBuilder().serviceName(serviceName).serviceEndpointPrefix(serviceEndpointPrefix).build();
    }

    public static Service getServiceByName(String serviceName) {
        return SERVICE_CACHE.get(serviceName);
    }

    private static synchronized Service create(String serviceName, String serviceEndpointPrefix, String serviceEndpointTemplate) {
        Validate.notBlank((CharSequence)serviceName);
        BasicService newInstance = new BasicService(serviceName, serviceEndpointPrefix, serviceEndpointTemplate);
        if (SERVICE_CACHE.containsKey(serviceName)) {
            Service existing = SERVICE_CACHE.get(serviceName);
            if (existing.equals(newInstance)) {
                return existing;
            }
            throw new IllegalArgumentException(String.format("Cannot redefine service '%s'. Existing: '%s', New: '%s'", serviceName, existing, newInstance));
        }
        LOG.info("Registering new service: {}", (Object)newInstance);
        SERVICE_CACHE.put(serviceName, newInstance);
        return newInstance;
    }

    public static ServiceBuilder serviceBuilder() {
        return new ServiceBuilder();
    }

    public static class ServiceBuilder {
        private String serviceName;
        private String serviceEndpointPrefix;
        private String serviceEndpointTemplate;

        ServiceBuilder() {
        }

        public ServiceBuilder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public ServiceBuilder serviceEndpointPrefix(String serviceEndpointPrefix) {
            this.serviceEndpointPrefix = serviceEndpointPrefix;
            return this;
        }

        public ServiceBuilder serviceEndpointTemplate(String serviceEndpointTemplate) {
            this.serviceEndpointTemplate = serviceEndpointTemplate;
            return this;
        }

        public Service build() {
            return Services.create(this.serviceName, this.serviceEndpointPrefix, this.serviceEndpointTemplate);
        }

        public String toString() {
            return "Services.ServiceBuilder(serviceName=" + this.serviceName + ", serviceEndpointPrefix=" + this.serviceEndpointPrefix + ", serviceEndpointTemplate=" + this.serviceEndpointTemplate + ")";
        }
    }

    private static final class BasicService
    implements Service {
        private final String serviceName;
        private final String serviceEndpointPrefix;
        private final String serviceEndpointTemplate;

        @ConstructorProperties(value={"serviceName", "serviceEndpointPrefix", "serviceEndpointTemplate"})
        public BasicService(String serviceName, String serviceEndpointPrefix, String serviceEndpointTemplate) {
            this.serviceName = serviceName;
            this.serviceEndpointPrefix = serviceEndpointPrefix;
            this.serviceEndpointTemplate = serviceEndpointTemplate;
        }

        @Override
        public String getServiceName() {
            return this.serviceName;
        }

        @Override
        public String getServiceEndpointPrefix() {
            return this.serviceEndpointPrefix;
        }

        @Override
        public String getServiceEndpointTemplate() {
            return this.serviceEndpointTemplate;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BasicService)) {
                return false;
            }
            BasicService other = (BasicService)o;
            String this$serviceName = this.getServiceName();
            String other$serviceName = other.getServiceName();
            if (this$serviceName == null ? other$serviceName != null : !this$serviceName.equals(other$serviceName)) {
                return false;
            }
            String this$serviceEndpointPrefix = this.getServiceEndpointPrefix();
            String other$serviceEndpointPrefix = other.getServiceEndpointPrefix();
            if (this$serviceEndpointPrefix == null ? other$serviceEndpointPrefix != null : !this$serviceEndpointPrefix.equals(other$serviceEndpointPrefix)) {
                return false;
            }
            String this$serviceEndpointTemplate = this.getServiceEndpointTemplate();
            String other$serviceEndpointTemplate = other.getServiceEndpointTemplate();
            return !(this$serviceEndpointTemplate == null ? other$serviceEndpointTemplate != null : !this$serviceEndpointTemplate.equals(other$serviceEndpointTemplate));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $serviceName = this.getServiceName();
            result = result * 59 + ($serviceName == null ? 43 : $serviceName.hashCode());
            String $serviceEndpointPrefix = this.getServiceEndpointPrefix();
            result = result * 59 + ($serviceEndpointPrefix == null ? 43 : $serviceEndpointPrefix.hashCode());
            String $serviceEndpointTemplate = this.getServiceEndpointTemplate();
            result = result * 59 + ($serviceEndpointTemplate == null ? 43 : $serviceEndpointTemplate.hashCode());
            return result;
        }

        public String toString() {
            return "Services.BasicService(serviceName=" + this.getServiceName() + ", serviceEndpointPrefix=" + this.getServiceEndpointPrefix() + ", serviceEndpointTemplate=" + this.getServiceEndpointTemplate() + ")";
        }
    }
}

