/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.openfile.OpenFile;
import org.openide.util.NbBundle;

public class PackagePanel
extends JPanel {
    private File f;
    private int pkgLevel;
    private List dirs;
    private List pkgs;
    private JButton okButton;
    private JButton cancelButton;
    private JList list;
    private JTextArea textArea;

    public PackagePanel(File f, int pkgLevel, List dirs, List pkgs) {
        this.f = f;
        this.pkgLevel = pkgLevel;
        this.dirs = dirs;
        this.pkgs = pkgs;
        this.initComponents2();
        this.initAccessibility();
    }

    JButton getOKButton() {
        return this.okButton;
    }

    JButton getCancelButton() {
        return this.cancelButton;
    }

    JList getList() {
        return this.list;
    }

    private void initComponents2() {
        this.okButton = new JButton(NbBundle.getMessage(PackagePanel.class, (String)"LBL_okButton"));
        this.cancelButton = new JButton(NbBundle.getMessage(PackagePanel.class, (String)"LBL_cancelButton"));
        this.list = new JList<Object>(this.pkgs.toArray());
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(new EmptyBorder(8, 8, 8, 8));
        this.textArea = new JTextArea();
        this.textArea.setDisabledTextColor(UIManager.getColor("Label.foreground"));
        this.textArea.setFont(UIManager.getFont("Label.font"));
        this.textArea.setText(NbBundle.getMessage(PackagePanel.class, (String)(this.pkgLevel == -1 ? "TXT_whereMountNoSuggest" : "TXT_whereMountSuggest"), (Object)this.f.getName()));
        this.textArea.setEditable(false);
        this.textArea.setEnabled(false);
        this.textArea.setOpaque(false);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.add((Component)this.textArea, "North");
        this.list.setVisibleRowCount(5);
        this.list.setSelectionMode(0);
        if (this.pkgLevel != -1) {
            this.list.setSelectedIndex(this.pkgLevel);
        }
        this.list.setCellRenderer(new ListCellRenderer(){
            private Icon folderIcon = new ImageIcon(OpenFile.class.getResource("folder.gif"));
            private Icon rootFolderIcon = new ImageIcon(OpenFile.class.getResource("rootFolder.gif"));
            private final JLabel lab = new JLabel();

            public Component getListCellRendererComponent(JList lst, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String pkg2 = (String)value;
                if (pkg2.equals("")) {
                    this.lab.setText(NbBundle.getMessage(PackagePanel.class, (String)"LBL_packageWillBeDefault"));
                    this.lab.setIcon(this.rootFolderIcon);
                } else {
                    this.lab.setText(NbBundle.getMessage(PackagePanel.class, (String)"LBL_packageWillBe", (Object)pkg2));
                    this.lab.setIcon(this.folderIcon);
                }
                if (isSelected) {
                    this.lab.setBackground(lst.getSelectionBackground());
                    this.lab.setForeground(lst.getSelectionForeground());
                } else {
                    this.lab.setBackground(lst.getBackground());
                    this.lab.setForeground(lst.getForeground());
                }
                this.lab.setEnabled(lst.isEnabled());
                this.lab.setFont(lst.getFont());
                this.lab.setOpaque(true);
                return this.lab;
            }
        });
        this.add((Component)new JScrollPane(this.list), "Center");
        final JTextField field = new JTextField();
        field.setEditable(false);
        field.setEnabled(true);
        field.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PackagePanel.class, (String)"ACS_Field"));
        field.selectAll();
        field.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                field.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.add((Component)field, "South");
        this.setPreferredSize(new Dimension(450, 300));
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                PackagePanel.updateLabelEtcFromList(field, PackagePanel.this.list, PackagePanel.this.dirs, PackagePanel.this.okButton);
            }
        });
        PackagePanel.updateLabelEtcFromList(field, this.list, this.dirs, this.okButton);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(this.textArea.getText());
        this.okButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PackagePanel.class, (String)"ACS_LBL_okButton"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PackagePanel.class, (String)"ACS_LBL_cancelButton"));
        this.list.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PackagePanel.class, (String)"ACSN_List"));
        this.list.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PackagePanel.class, (String)"ACSD_List"));
    }

    private static void updateLabelEtcFromList(JTextField field, JList list, List dirs, JButton okButton) {
        int idx = list.getSelectedIndex();
        if (idx == -1) {
            field.setText(" ");
            field.getAccessibleContext().setAccessibleName(" ");
            okButton.setEnabled(false);
        } else {
            File dir = (File)dirs.get(idx);
            field.setText(NbBundle.getMessage(PackagePanel.class, (String)"LBL_dirWillBe", (Object)dir.getAbsolutePath()));
            field.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PackagePanel.class, (String)"LBL_dirWillBe", (Object)dir.getAbsolutePath()));
            okButton.setEnabled(true);
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }
}

