/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.loaders;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.gradle.GradleProject;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.cache.ProjectInfoDiskCache;
import org.netbeans.modules.gradle.loaders.AbstractProjectLoader;
import org.netbeans.modules.gradle.loaders.GradleArtifactStore;
import org.netbeans.modules.gradle.options.GradleExperimentalSettings;

public class DiskCacheProjectLoader
extends AbstractProjectLoader {
    private static final Logger LOG = Logger.getLogger(DiskCacheProjectLoader.class.getName());

    DiskCacheProjectLoader(AbstractProjectLoader.ReloadContext ctx) {
        super(ctx);
    }

    @Override
    public GradleProject load() {
        ProjectInfoDiskCache cache = ProjectInfoDiskCache.get(this.ctx.project.getGradleFiles());
        if (cache.isCompatible()) {
            GradleProject prev = DiskCacheProjectLoader.createGradleProject((ProjectInfoDiskCache.QualifiedProjectInfo)cache.loadData());
            LOG.log(Level.FINER, "Loaded from cache: {0}, valid: {1}", new Object[]{prev, cache.isValid()});
            if (cache.isValid() && GradleArtifactStore.getDefault().sanityCheckCachedProject(prev)) {
                DiskCacheProjectLoader.updateSubDirectoryCache(prev);
                return prev;
            }
        }
        return null;
    }

    @Override
    boolean isEnabled() {
        return this.ctx.aim.betterThan(NbGradleProject.Quality.FALLBACK) && !GradleExperimentalSettings.getDefault().isCacheDisabled();
    }

    @Override
    boolean needsTrust() {
        return false;
    }
}

