/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.freeform.ui;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.ant.freeform.spi.TargetDescriptor;
import org.netbeans.modules.ant.freeform.spi.support.NewFreeformProjectSupport;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.java.freeform.spi.support.NewJavaFreeformProjectSupport;
import org.netbeans.modules.web.freeform.WebProjectGenerator;
import org.netbeans.modules.web.freeform.WebProjectNature;
import org.netbeans.modules.web.freeform.ui.WebClasspathWizardPanel;
import org.netbeans.modules.web.freeform.ui.WebLocationsWizardPanel;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class NewWebFreeformProjectWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    public static final String PROP_WEB_WEBMODULES = "webModules";
    public static final String PROP_WEB_SOURCE_FOLDERS = "webSourceFolders";
    public static final String PROP_WEB_INF_FOLDER = "webInfFolder";
    protected static final String PROP_WEB_CLASSPATH = "webClasspath";
    private static final long serialVersionUID = 1L;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wiz;

    private WizardDescriptor.Panel[] createPanels() {
        ArrayList<WizardDescriptor.Panel> l = new ArrayList<WizardDescriptor.Panel>();
        ArrayList<TargetDescriptor> extraTargets = new ArrayList<TargetDescriptor>();
        extraTargets.add(WebProjectNature.getExtraTarget());
        l.add(NewFreeformProjectSupport.createBasicProjectInfoWizardPanel());
        l.add(NewFreeformProjectSupport.createTargetMappingWizardPanel(extraTargets));
        l.add(new WebLocationsWizardPanel());
        l.addAll(Arrays.asList(NewJavaFreeformProjectSupport.createJavaPanels()));
        l.add(new WebClasspathWizardPanel());
        return l.toArray(new WizardDescriptor.Panel[l.size()]);
    }

    public Set<FileObject> instantiate() throws IOException {
        File f;
        SourceGroup[] grps;
        Sources srcs;
        final WizardDescriptor wiz = this.wiz;
        final IOException[] ioe = new IOException[1];
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                try {
                    AntProjectHelper helper = NewFreeformProjectSupport.instantiateBasicProjectInfoWizardPanel((WizardDescriptor)wiz);
                    NewFreeformProjectSupport.instantiateTargetMappingWizardPanel((AntProjectHelper)helper, (WizardDescriptor)wiz);
                    NewJavaFreeformProjectSupport.instantiateJavaPanels((AntProjectHelper)helper, (WizardDescriptor)wiz);
                    List webSources = (List)wiz.getProperty(NewWebFreeformProjectWizardIterator.PROP_WEB_SOURCE_FOLDERS);
                    List webInf = (List)wiz.getProperty(NewWebFreeformProjectWizardIterator.PROP_WEB_INF_FOLDER);
                    AuxiliaryConfiguration aux = Util.getAuxiliaryConfiguration((AntProjectHelper)helper);
                    WebProjectGenerator.putWebSourceFolder(helper, webSources);
                    WebProjectGenerator.putWebInfFolder(helper, webInf);
                    List webModules = (List)wiz.getProperty(NewWebFreeformProjectWizardIterator.PROP_WEB_WEBMODULES);
                    if (webModules != null) {
                        String webClasspath = (String)wiz.getProperty(NewWebFreeformProjectWizardIterator.PROP_WEB_CLASSPATH);
                        Iterator iter = webModules.iterator();
                        for (WebProjectGenerator.WebModule wm : webModules) {
                            wm.classpath = webClasspath;
                        }
                        WebProjectGenerator.putWebModules(helper, aux, webModules);
                    }
                    Project p = ProjectManager.getDefault().findProject(helper.getProjectDirectory());
                    ProjectManager.getDefault().saveProject(p);
                }
                catch (IOException e) {
                    ioe[0] = e;
                    return;
                }
            }
        });
        if (ioe[0] != null) {
            throw ioe[0];
        }
        File nbProjectFolder = (File)wiz.getProperty("projectFolder");
        HashSet<FileObject> resultSet = new HashSet<FileObject>();
        resultSet.add(FileUtil.toFileObject((File)nbProjectFolder));
        Project p = ProjectManager.getDefault().findProject(FileUtil.toFileObject((File)nbProjectFolder));
        if (p != null && (srcs = ProjectUtils.getSources((Project)p)) != null && (grps = srcs.getSourceGroups("doc_root")) != null && grps.length > 0) {
            resultSet.add(grps[0].getRootFolder());
        }
        if ((f = nbProjectFolder.getParentFile()) != null) {
            ProjectChooser.setProjectsFolder((File)f);
        }
        return resultSet;
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        this.index = 0;
        this.panels = this.createPanels();
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            assert (c instanceof JComponent);
            JComponent jc = (JComponent)c;
            l.add(jc.getName());
        }
        String[] steps = l.toArray(new String[l.size()]);
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            assert (c instanceof JComponent);
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
            jc.putClientProperty("NewProjectWizard_Title", NbBundle.getMessage(NewWebFreeformProjectWizardIterator.class, (String)"TXT_NewWebFreeformProjectWizardIterator_NewProjectWizardTitle"));
            jc.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewWebFreeformProjectWizardIterator.class, (String)"ACSD_NewWebFreeformProjectWizardIterator_NewProjectWizardTitle"));
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        NewFreeformProjectSupport.uninitializeBasicProjectInfoWizardPanel((WizardDescriptor)wiz);
        NewFreeformProjectSupport.uninitializeTargetMappingWizardPanel((WizardDescriptor)wiz);
        NewJavaFreeformProjectSupport.uninitializeJavaPanels((WizardDescriptor)wiz);
        wiz.putProperty(PROP_WEB_SOURCE_FOLDERS, null);
        wiz.putProperty(PROP_WEB_INF_FOLDER, null);
        wiz.putProperty(PROP_WEB_WEBMODULES, null);
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return MessageFormat.format(NbBundle.getMessage(NewWebFreeformProjectWizardIterator.class, (String)"TXT_NewWebFreeformProjectWizardIterator_TitleFormat"), this.index + 1, this.panels.length);
    }

    public boolean hasNext() {
        if (!NewJavaFreeformProjectSupport.enableNextButton((WizardDescriptor.Panel)this.current())) {
            return false;
        }
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }
}

