/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.tree;

import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BindingPatternTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DefaultCaseLabelTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExportsTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.GuardedPatternTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.IntersectionTypeTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.OpensTree;
import com.sun.source.tree.PackageTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedPatternTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ProvidesTree;
import com.sun.source.tree.RequiresTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.SwitchExpressionTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.UsesTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.tree.YieldTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;

public class TreeCopier<P>
implements TreeVisitor<JCTree, P> {
    private TreeMaker M;

    public TreeCopier(TreeMaker M) {
        this.M = M;
    }

    public <T extends JCTree> T copy(T tree) {
        return this.copy(tree, null);
    }

    public <T extends JCTree> T copy(T tree, P p) {
        if (tree == null) {
            return null;
        }
        return (T)((JCTree)tree.accept(this, p));
    }

    public <T extends JCTree> List<T> copy(List<T> trees) {
        return this.copy(trees, null);
    }

    public <T extends JCTree> List<T> copy(List<T> trees, P p) {
        if (trees == null) {
            return null;
        }
        ListBuffer<JCTree> lb = new ListBuffer<JCTree>();
        for (JCTree tree : trees) {
            lb.append(this.copy(tree, p));
        }
        return lb.toList();
    }

    @Override
    public JCTree visitAnnotatedType(AnnotatedTypeTree node, P p) {
        JCTree.JCAnnotatedType t = (JCTree.JCAnnotatedType)node;
        List<JCTree.JCAnnotation> annotations = this.copy(t.annotations, p);
        JCTree.JCExpression underlyingType = this.copy(t.underlyingType, p);
        return this.M.at(t.pos).AnnotatedType(annotations, underlyingType);
    }

    @Override
    public JCTree visitAnnotation(AnnotationTree node, P p) {
        JCTree.JCAnnotation t = (JCTree.JCAnnotation)node;
        JCTree annotationType = this.copy(t.annotationType, p);
        List<JCTree.JCExpression> args = this.copy(t.args, p);
        if (t.getKind() == Tree.Kind.TYPE_ANNOTATION) {
            JCTree.JCAnnotation newTA = this.M.at(t.pos).TypeAnnotation(annotationType, args);
            newTA.attribute = t.attribute;
            return newTA;
        }
        JCTree.JCAnnotation newT = this.M.at(t.pos).Annotation(annotationType, args);
        newT.attribute = t.attribute;
        return newT;
    }

    @Override
    public JCTree visitAssert(AssertTree node, P p) {
        JCTree.JCAssert t = (JCTree.JCAssert)node;
        JCTree.JCExpression cond = this.copy(t.cond, p);
        JCTree.JCExpression detail = this.copy(t.detail, p);
        return this.M.at(t.pos).Assert(cond, detail);
    }

    @Override
    public JCTree visitAssignment(AssignmentTree node, P p) {
        JCTree.JCAssign t = (JCTree.JCAssign)node;
        JCTree.JCExpression lhs = this.copy(t.lhs, p);
        JCTree.JCExpression rhs = this.copy(t.rhs, p);
        return this.M.at(t.pos).Assign(lhs, rhs);
    }

    @Override
    public JCTree visitCompoundAssignment(CompoundAssignmentTree node, P p) {
        JCTree.JCAssignOp t = (JCTree.JCAssignOp)node;
        JCTree.JCExpression lhs = this.copy(t.lhs, p);
        JCTree.JCExpression rhs = this.copy(t.rhs, p);
        return this.M.at(t.pos).Assignop(t.getTag(), lhs, rhs);
    }

    @Override
    public JCTree visitBinary(BinaryTree node, P p) {
        JCTree.JCBinary t = (JCTree.JCBinary)node;
        JCTree.JCExpression lhs = this.copy(t.lhs, p);
        JCTree.JCExpression rhs = this.copy(t.rhs, p);
        return this.M.at(t.pos).Binary(t.getTag(), lhs, rhs);
    }

    @Override
    public JCTree visitBlock(BlockTree node, P p) {
        JCTree.JCBlock t = (JCTree.JCBlock)node;
        List<JCTree.JCStatement> stats = this.copy(t.stats, p);
        return this.M.at(t.pos).Block(t.flags, stats);
    }

    @Override
    public JCTree visitBreak(BreakTree node, P p) {
        JCTree.JCBreak t = (JCTree.JCBreak)node;
        return this.M.at(t.pos).Break(t.label);
    }

    @Override
    public JCTree visitYield(YieldTree node, P p) {
        JCTree.JCYield t = (JCTree.JCYield)node;
        JCTree.JCExpression value = this.copy(t.value, p);
        return this.M.at(t.pos).Yield(value);
    }

    @Override
    public JCTree visitCase(CaseTree node, P p) {
        JCTree.JCCase t = (JCTree.JCCase)node;
        List<JCTree.JCCaseLabel> labels = this.copy(t.labels, p);
        List<JCTree.JCStatement> stats = this.copy(t.stats, p);
        JCTree body = node.getCaseKind() == CaseTree.CaseKind.RULE ? (t.body instanceof JCTree.JCExpression && ((JCTree.JCStatement)t.stats.head).hasTag(JCTree.Tag.YIELD) ? ((JCTree.JCYield)t.stats.head).value : (JCTree)t.stats.head) : null;
        return this.M.at(t.pos).Case(t.caseKind, labels, stats, body);
    }

    @Override
    public JCTree visitCatch(CatchTree node, P p) {
        JCTree.JCCatch t = (JCTree.JCCatch)node;
        JCTree.JCVariableDecl param = this.copy(t.param, p);
        JCTree.JCBlock body = this.copy(t.body, p);
        return this.M.at(t.pos).Catch(param, body);
    }

    @Override
    public JCTree visitClass(ClassTree node, P p) {
        JCTree.JCClassDecl t = (JCTree.JCClassDecl)node;
        JCTree.JCModifiers mods = this.copy(t.mods, p);
        List<JCTree.JCTypeParameter> typarams = this.copy(t.typarams, p);
        JCTree.JCExpression extending = this.copy(t.extending, p);
        List<JCTree.JCExpression> implementing = this.copy(t.implementing, p);
        List<JCTree> defs = this.copy(t.defs, p);
        return this.M.at(t.pos).ClassDef(mods, t.name, typarams, extending, implementing, defs);
    }

    @Override
    public JCTree visitConditionalExpression(ConditionalExpressionTree node, P p) {
        JCTree.JCConditional t = (JCTree.JCConditional)node;
        JCTree.JCExpression cond = this.copy(t.cond, p);
        JCTree.JCExpression truepart = this.copy(t.truepart, p);
        JCTree.JCExpression falsepart = this.copy(t.falsepart, p);
        return this.M.at(t.pos).Conditional(cond, truepart, falsepart);
    }

    @Override
    public JCTree visitContinue(ContinueTree node, P p) {
        JCTree.JCContinue t = (JCTree.JCContinue)node;
        return this.M.at(t.pos).Continue(t.label);
    }

    @Override
    public JCTree visitDoWhileLoop(DoWhileLoopTree node, P p) {
        JCTree.JCDoWhileLoop t = (JCTree.JCDoWhileLoop)node;
        JCTree.JCStatement body = this.copy(t.body, p);
        JCTree.JCExpression cond = this.copy(t.cond, p);
        return this.M.at(t.pos).DoLoop(body, cond);
    }

    @Override
    public JCTree visitErroneous(ErroneousTree node, P p) {
        JCTree.JCErroneous t = (JCTree.JCErroneous)node;
        List<? extends JCTree> errs = this.copy(t.errs, p);
        return this.M.at(t.pos).Erroneous(errs);
    }

    @Override
    public JCTree visitExpressionStatement(ExpressionStatementTree node, P p) {
        JCTree.JCExpressionStatement t = (JCTree.JCExpressionStatement)node;
        JCTree.JCExpression expr = this.copy(t.expr, p);
        return this.M.at(t.pos).Exec(expr);
    }

    @Override
    public JCTree visitEnhancedForLoop(EnhancedForLoopTree node, P p) {
        JCTree.JCEnhancedForLoop t = (JCTree.JCEnhancedForLoop)node;
        JCTree.JCVariableDecl var = this.copy(t.var, p);
        JCTree.JCExpression expr = this.copy(t.expr, p);
        JCTree.JCStatement body = this.copy(t.body, p);
        return this.M.at(t.pos).ForeachLoop(var, expr, body);
    }

    @Override
    public JCTree visitForLoop(ForLoopTree node, P p) {
        JCTree.JCForLoop t = (JCTree.JCForLoop)node;
        List<JCTree.JCStatement> init = this.copy(t.init, p);
        JCTree.JCExpression cond = this.copy(t.cond, p);
        List<JCTree.JCExpressionStatement> step = this.copy(t.step, p);
        JCTree.JCStatement body = this.copy(t.body, p);
        return this.M.at(t.pos).ForLoop(init, cond, step, body);
    }

    @Override
    public JCTree visitIdentifier(IdentifierTree node, P p) {
        JCTree.JCIdent t = (JCTree.JCIdent)node;
        return this.M.at(t.pos).Ident(t.name);
    }

    @Override
    public JCTree visitIf(IfTree node, P p) {
        JCTree.JCIf t = (JCTree.JCIf)node;
        JCTree.JCExpression cond = this.copy(t.cond, p);
        JCTree.JCStatement thenpart = this.copy(t.thenpart, p);
        JCTree.JCStatement elsepart = this.copy(t.elsepart, p);
        return this.M.at(t.pos).If(cond, thenpart, elsepart);
    }

    @Override
    public JCTree visitImport(ImportTree node, P p) {
        JCTree.JCImport t = (JCTree.JCImport)node;
        JCTree qualid = this.copy(t.qualid, p);
        return this.M.at(t.pos).Import(qualid, t.staticImport);
    }

    @Override
    public JCTree visitArrayAccess(ArrayAccessTree node, P p) {
        JCTree.JCArrayAccess t = (JCTree.JCArrayAccess)node;
        JCTree.JCExpression indexed = this.copy(t.indexed, p);
        JCTree.JCExpression index = this.copy(t.index, p);
        return this.M.at(t.pos).Indexed(indexed, index);
    }

    @Override
    public JCTree visitLabeledStatement(LabeledStatementTree node, P p) {
        JCTree.JCLabeledStatement t = (JCTree.JCLabeledStatement)node;
        JCTree.JCStatement body = this.copy(t.body, p);
        return this.M.at(t.pos).Labelled(t.label, body);
    }

    @Override
    public JCTree visitLiteral(LiteralTree node, P p) {
        JCTree.JCLiteral t = (JCTree.JCLiteral)node;
        return this.M.at(t.pos).Literal(t.typetag, t.value);
    }

    @Override
    public JCTree visitMethod(MethodTree node, P p) {
        JCTree.JCMethodDecl t = (JCTree.JCMethodDecl)node;
        JCTree.JCModifiers mods = this.copy(t.mods, p);
        JCTree.JCExpression restype = this.copy(t.restype, p);
        List<JCTree.JCTypeParameter> typarams = this.copy(t.typarams, p);
        List<JCTree.JCVariableDecl> params = this.copy(t.params, p);
        JCTree.JCVariableDecl recvparam = this.copy(t.recvparam, p);
        List<JCTree.JCExpression> thrown = this.copy(t.thrown, p);
        JCTree.JCBlock body = this.copy(t.body, p);
        JCTree.JCExpression defaultValue = this.copy(t.defaultValue, p);
        return this.M.at(t.pos).MethodDef(mods, t.name, restype, typarams, recvparam, params, thrown, body, defaultValue);
    }

    @Override
    public JCTree visitMethodInvocation(MethodInvocationTree node, P p) {
        JCTree.JCMethodInvocation t = (JCTree.JCMethodInvocation)node;
        List<JCTree.JCExpression> typeargs = this.copy(t.typeargs, p);
        JCTree.JCExpression meth = this.copy(t.meth, p);
        List<JCTree.JCExpression> args = this.copy(t.args, p);
        return this.M.at(t.pos).Apply(typeargs, meth, args);
    }

    @Override
    public JCTree visitModifiers(ModifiersTree node, P p) {
        JCTree.JCModifiers t = (JCTree.JCModifiers)node;
        List<JCTree.JCAnnotation> annotations = this.copy(t.annotations, p);
        return this.M.at(t.pos).Modifiers(t.flags, annotations);
    }

    @Override
    public JCTree visitNewArray(NewArrayTree node, P p) {
        JCTree.JCNewArray t = (JCTree.JCNewArray)node;
        JCTree.JCExpression elemtype = this.copy(t.elemtype, p);
        List<JCTree.JCExpression> dims = this.copy(t.dims, p);
        List<JCTree.JCExpression> elems = this.copy(t.elems, p);
        return this.M.at(t.pos).NewArray(elemtype, dims, elems);
    }

    @Override
    public JCTree visitNewClass(NewClassTree node, P p) {
        JCTree.JCNewClass t = (JCTree.JCNewClass)node;
        JCTree.JCExpression encl = this.copy(t.encl, p);
        List<JCTree.JCExpression> typeargs = this.copy(t.typeargs, p);
        JCTree.JCExpression clazz = this.copy(t.clazz, p);
        List<JCTree.JCExpression> args = this.copy(t.args, p);
        JCTree.JCClassDecl def = this.copy(t.def, p);
        return this.M.at(t.pos).NewClass(encl, typeargs, clazz, args, def);
    }

    @Override
    public JCTree visitLambdaExpression(LambdaExpressionTree node, P p) {
        JCTree.JCLambda t = (JCTree.JCLambda)node;
        List<JCTree.JCVariableDecl> params = this.copy(t.params, p);
        JCTree body = this.copy(t.body, p);
        return this.M.at(t.pos).Lambda(params, body);
    }

    @Override
    public JCTree visitParenthesized(ParenthesizedTree node, P p) {
        JCTree.JCParens t = (JCTree.JCParens)node;
        JCTree.JCExpression expr = this.copy(t.expr, p);
        return this.M.at(t.pos).Parens(expr);
    }

    @Override
    public JCTree visitReturn(ReturnTree node, P p) {
        JCTree.JCReturn t = (JCTree.JCReturn)node;
        JCTree.JCExpression expr = this.copy(t.expr, p);
        return this.M.at(t.pos).Return(expr);
    }

    @Override
    public JCTree visitMemberSelect(MemberSelectTree node, P p) {
        JCTree.JCFieldAccess t = (JCTree.JCFieldAccess)node;
        JCTree.JCExpression selected = this.copy(t.selected, p);
        return this.M.at(t.pos).Select(selected, t.name);
    }

    @Override
    public JCTree visitMemberReference(MemberReferenceTree node, P p) {
        JCTree.JCMemberReference t = (JCTree.JCMemberReference)node;
        JCTree.JCExpression expr = this.copy(t.expr, p);
        List<JCTree.JCExpression> typeargs = this.copy(t.typeargs, p);
        return this.M.at(t.pos).Reference(t.mode, t.name, expr, typeargs);
    }

    @Override
    public JCTree visitEmptyStatement(EmptyStatementTree node, P p) {
        JCTree.JCSkip t = (JCTree.JCSkip)node;
        return this.M.at(t.pos).Skip();
    }

    @Override
    public JCTree visitSwitch(SwitchTree node, P p) {
        JCTree.JCSwitch t = (JCTree.JCSwitch)node;
        JCTree.JCExpression selector = this.copy(t.selector, p);
        List<JCTree.JCCase> cases = this.copy(t.cases, p);
        return this.M.at(t.pos).Switch(selector, cases);
    }

    @Override
    public JCTree visitSwitchExpression(SwitchExpressionTree node, P p) {
        JCTree.JCSwitchExpression t = (JCTree.JCSwitchExpression)node;
        JCTree.JCExpression selector = this.copy(t.selector, p);
        List<JCTree.JCCase> cases = this.copy(t.cases, p);
        return this.M.at(t.pos).SwitchExpression(selector, cases);
    }

    @Override
    public JCTree visitSynchronized(SynchronizedTree node, P p) {
        JCTree.JCSynchronized t = (JCTree.JCSynchronized)node;
        JCTree.JCExpression lock = this.copy(t.lock, p);
        JCTree.JCBlock body = this.copy(t.body, p);
        return this.M.at(t.pos).Synchronized(lock, body);
    }

    @Override
    public JCTree visitThrow(ThrowTree node, P p) {
        JCTree.JCThrow t = (JCTree.JCThrow)node;
        JCTree.JCExpression expr = this.copy(t.expr, p);
        return this.M.at(t.pos).Throw(expr);
    }

    @Override
    public JCTree visitCompilationUnit(CompilationUnitTree node, P p) {
        JCTree.JCCompilationUnit t = (JCTree.JCCompilationUnit)node;
        List<JCTree> defs = this.copy(t.defs, p);
        return this.M.at(t.pos).TopLevel(defs);
    }

    @Override
    public JCTree visitPackage(PackageTree node, P p) {
        JCTree.JCPackageDecl t = (JCTree.JCPackageDecl)node;
        List<JCTree.JCAnnotation> annotations = this.copy(t.annotations, p);
        JCTree.JCExpression pid = this.copy(t.pid, p);
        return this.M.at(t.pos).PackageDecl(annotations, pid);
    }

    @Override
    public JCTree visitTry(TryTree node, P p) {
        JCTree.JCTry t = (JCTree.JCTry)node;
        List<JCTree> resources = this.copy(t.resources, p);
        JCTree.JCBlock body = this.copy(t.body, p);
        List<JCTree.JCCatch> catchers = this.copy(t.catchers, p);
        JCTree.JCBlock finalizer = this.copy(t.finalizer, p);
        return this.M.at(t.pos).Try(resources, body, catchers, finalizer);
    }

    @Override
    public JCTree visitParameterizedType(ParameterizedTypeTree node, P p) {
        JCTree.JCTypeApply t = (JCTree.JCTypeApply)node;
        JCTree.JCExpression clazz = this.copy(t.clazz, p);
        List<JCTree.JCExpression> arguments = this.copy(t.arguments, p);
        return this.M.at(t.pos).TypeApply(clazz, arguments);
    }

    @Override
    public JCTree visitUnionType(UnionTypeTree node, P p) {
        JCTree.JCTypeUnion t = (JCTree.JCTypeUnion)node;
        List<JCTree.JCExpression> components = this.copy(t.alternatives, p);
        return this.M.at(t.pos).TypeUnion(components);
    }

    @Override
    public JCTree visitIntersectionType(IntersectionTypeTree node, P p) {
        JCTree.JCTypeIntersection t = (JCTree.JCTypeIntersection)node;
        List<JCTree.JCExpression> bounds = this.copy(t.bounds, p);
        return this.M.at(t.pos).TypeIntersection(bounds);
    }

    @Override
    public JCTree visitArrayType(ArrayTypeTree node, P p) {
        JCTree.JCArrayTypeTree t = (JCTree.JCArrayTypeTree)node;
        JCTree.JCExpression elemtype = this.copy(t.elemtype, p);
        return this.M.at(t.pos).TypeArray(elemtype);
    }

    @Override
    public JCTree visitTypeCast(TypeCastTree node, P p) {
        JCTree.JCTypeCast t = (JCTree.JCTypeCast)node;
        JCTree clazz = this.copy(t.clazz, p);
        JCTree.JCExpression expr = this.copy(t.expr, p);
        return this.M.at(t.pos).TypeCast(clazz, expr);
    }

    @Override
    public JCTree visitPrimitiveType(PrimitiveTypeTree node, P p) {
        JCTree.JCPrimitiveTypeTree t = (JCTree.JCPrimitiveTypeTree)node;
        return this.M.at(t.pos).TypeIdent(t.typetag);
    }

    @Override
    public JCTree visitTypeParameter(TypeParameterTree node, P p) {
        JCTree.JCTypeParameter t = (JCTree.JCTypeParameter)node;
        List<JCTree.JCAnnotation> annos = this.copy(t.annotations, p);
        List<JCTree.JCExpression> bounds = this.copy(t.bounds, p);
        return this.M.at(t.pos).TypeParameter(t.name, bounds, annos);
    }

    @Override
    public JCTree visitInstanceOf(InstanceOfTree node, P p) {
        JCTree.JCInstanceOf t = (JCTree.JCInstanceOf)node;
        JCTree.JCExpression expr = this.copy(t.expr, p);
        JCTree pattern = this.copy(t.pattern, p);
        return this.M.at(t.pos).TypeTest(expr, pattern);
    }

    @Override
    public JCTree visitBindingPattern(BindingPatternTree node, P p) {
        JCTree.JCBindingPattern t = (JCTree.JCBindingPattern)node;
        JCTree.JCVariableDecl var = this.copy(t.var, p);
        return this.M.at(t.pos).BindingPattern(var);
    }

    public JCTree visitGuardedPattern(GuardedPatternTree node, P p) {
        JCTree.JCGuardPattern t = (JCTree.JCGuardPattern)node;
        JCTree.JCPattern patt = this.copy(t.patt, p);
        JCTree.JCExpression expr = this.copy(t.expr, p);
        return this.M.at(t.pos).GuardPattern(patt, expr);
    }

    public JCTree visitParenthesizedPattern(ParenthesizedPatternTree node, P p) {
        JCTree.JCParenthesizedPattern t = (JCTree.JCParenthesizedPattern)node;
        JCTree.JCPattern pattern = this.copy(t.pattern, p);
        return this.M.at(t.pos).ParenthesizedPattern(pattern);
    }

    @Override
    public JCTree visitDefaultCaseLabel(DefaultCaseLabelTree node, P p) {
        JCTree.JCDefaultCaseLabel t = (JCTree.JCDefaultCaseLabel)node;
        return this.M.at(t.pos).DefaultCaseLabel();
    }

    @Override
    public JCTree visitUnary(UnaryTree node, P p) {
        JCTree.JCUnary t = (JCTree.JCUnary)node;
        JCTree.JCExpression arg = this.copy(t.arg, p);
        return this.M.at(t.pos).Unary(t.getTag(), arg);
    }

    @Override
    public JCTree visitVariable(VariableTree node, P p) {
        JCTree.JCVariableDecl t = (JCTree.JCVariableDecl)node;
        JCTree.JCModifiers mods = this.copy(t.mods, p);
        JCTree.JCExpression vartype = this.copy(t.vartype, p);
        if (t.nameexpr == null) {
            JCTree.JCExpression init = this.copy(t.init, p);
            return this.M.at(t.pos).VarDef(mods, t.name, vartype, init);
        }
        JCTree.JCExpression nameexpr = this.copy(t.nameexpr, p);
        return this.M.at(t.pos).ReceiverVarDef(mods, nameexpr, vartype);
    }

    @Override
    public JCTree visitWhileLoop(WhileLoopTree node, P p) {
        JCTree.JCWhileLoop t = (JCTree.JCWhileLoop)node;
        JCTree.JCStatement body = this.copy(t.body, p);
        JCTree.JCExpression cond = this.copy(t.cond, p);
        return this.M.at(t.pos).WhileLoop(cond, body);
    }

    @Override
    public JCTree visitWildcard(WildcardTree node, P p) {
        JCTree.JCWildcard t = (JCTree.JCWildcard)node;
        JCTree.TypeBoundKind kind = this.M.at(t.kind.pos).TypeBoundKind(t.kind.kind);
        JCTree inner = this.copy(t.inner, p);
        return this.M.at(t.pos).Wildcard(kind, inner);
    }

    @Override
    public JCTree visitModule(ModuleTree node, P p) {
        JCTree.JCModuleDecl t = (JCTree.JCModuleDecl)node;
        JCTree.JCModifiers mods = this.copy(t.mods, p);
        JCTree.JCExpression qualId = this.copy(t.qualId);
        List<JCTree.JCDirective> directives = this.copy(t.directives);
        return this.M.at(t.pos).ModuleDef(mods, t.getModuleType(), qualId, directives);
    }

    @Override
    public JCTree.JCExports visitExports(ExportsTree node, P p) {
        JCTree.JCExports t = (JCTree.JCExports)node;
        JCTree.JCExpression qualId = this.copy(t.qualid, p);
        List<JCTree.JCExpression> moduleNames = this.copy(t.moduleNames, p);
        return this.M.at(t.pos).Exports(qualId, moduleNames);
    }

    @Override
    public JCTree.JCOpens visitOpens(OpensTree node, P p) {
        JCTree.JCOpens t = (JCTree.JCOpens)node;
        JCTree.JCExpression qualId = this.copy(t.qualid, p);
        List<JCTree.JCExpression> moduleNames = this.copy(t.moduleNames, p);
        return this.M.at(t.pos).Opens(qualId, moduleNames);
    }

    @Override
    public JCTree.JCProvides visitProvides(ProvidesTree node, P p) {
        JCTree.JCProvides t = (JCTree.JCProvides)node;
        JCTree.JCExpression serviceName = this.copy(t.serviceName, p);
        List<JCTree.JCExpression> implNames = this.copy(t.implNames, p);
        return this.M.at(t.pos).Provides(serviceName, implNames);
    }

    @Override
    public JCTree.JCRequires visitRequires(RequiresTree node, P p) {
        JCTree.JCRequires t = (JCTree.JCRequires)node;
        JCTree.JCExpression moduleName = this.copy(t.moduleName, p);
        return this.M.at(t.pos).Requires(t.isTransitive, t.isStaticPhase, moduleName);
    }

    @Override
    public JCTree.JCUses visitUses(UsesTree node, P p) {
        JCTree.JCUses t = (JCTree.JCUses)node;
        JCTree.JCExpression serviceName = this.copy(t.qualid, p);
        return this.M.at(t.pos).Uses(serviceName);
    }

    @Override
    public JCTree visitOther(Tree node, P p) {
        JCTree tree = (JCTree)node;
        switch (tree.getTag()) {
            case LETEXPR: {
                JCTree.LetExpr t = (JCTree.LetExpr)node;
                List<JCTree.JCStatement> defs = this.copy(t.defs, p);
                JCTree.JCExpression expr = this.copy(t.expr, p);
                return this.M.at(t.pos).LetExpr(defs, expr);
            }
        }
        throw new AssertionError((Object)("unknown tree tag: " + (Object)((Object)tree.getTag())));
    }
}

