/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.websvc.rest.model.api.RestMethodDescription;
import org.netbeans.modules.websvc.rest.model.api.RestServiceDescription;
import org.netbeans.modules.websvc.rest.model.api.RestServices;
import org.netbeans.modules.websvc.rest.model.api.RestServicesMetadata;
import org.netbeans.modules.websvc.rest.model.api.RestServicesModel;
import org.netbeans.modules.websvc.rest.model.api.SubResourceLocator;
import org.netbeans.modules.websvc.rest.nodes.SubResourceLocatorNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;

class SubResourceLocatorsChildrenFactory
extends ChildFactory<SubResourceLocatorNode> {
    private static final Comparator<SubResourceLocator> COMPARATOR = new SubResourceLocatorComparator();
    private Project project;
    private RestServicesModel model;
    private String serviceName;

    SubResourceLocatorsChildrenFactory(Project project, RestServicesModel model, String serviceName) {
        this.project = project;
        this.model = model;
        this.serviceName = serviceName;
    }

    protected boolean createKeys(final List<SubResourceLocatorNode> list) {
        try {
            this.model.runReadAction((MetadataModelAction)new MetadataModelAction<RestServicesMetadata, Void>(){

                public Void run(RestServicesMetadata metadata) throws IOException {
                    RestServices root = metadata.getRoot();
                    RestServiceDescription desc = root.getRestServiceDescription(SubResourceLocatorsChildrenFactory.this.serviceName);
                    if (desc != null) {
                        String className = desc.getClassName();
                        List methods = desc.getMethods();
                        ArrayList<SubResourceLocator> locators = new ArrayList<SubResourceLocator>(methods.size());
                        for (RestMethodDescription method : methods) {
                            if (!(method instanceof SubResourceLocator)) continue;
                            locators.add((SubResourceLocator)method);
                        }
                        Collections.sort(locators, COMPARATOR);
                        for (SubResourceLocator locator : locators) {
                            list.add(new SubResourceLocatorNode(SubResourceLocatorsChildrenFactory.this.project, className, locator));
                        }
                    }
                    return null;
                }
            });
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return true;
    }

    protected Node createNodeForKey(SubResourceLocatorNode node) {
        return node;
    }

    private static class SubResourceLocatorComparator
    implements Comparator<SubResourceLocator> {
        private SubResourceLocatorComparator() {
        }

        @Override
        public int compare(SubResourceLocator locator1, SubResourceLocator locator2) {
            String key1 = SubResourceLocatorNode.getKey(locator1);
            String key2 = SubResourceLocatorNode.getKey(locator2);
            return key1.compareTo(key2);
        }
    }
}

