/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.css.live.LiveUpdater;
import org.netbeans.modules.web.common.api.ServerURLMapping;
import org.netbeans.modules.web.common.api.WebUtils;
import org.netbeans.modules.web.webkit.debugging.api.WebKitDebugging;
import org.netbeans.modules.web.webkit.debugging.api.css.CSS;
import org.netbeans.modules.web.webkit.debugging.api.css.StyleSheetHeader;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class CSSUpdater {
    private static CSSUpdater instance;
    private WebKitDebugging webKit;
    private Project project;
    private InetAddress localhost;
    private CSS.Listener listener;
    private final Map<String, StyleSheetHeader> sheetsMap = new HashMap<String, StyleSheetHeader>();
    private final Map<FileObject, StyleSheetHeader> fobToSheetMap = new HashMap<FileObject, StyleSheetHeader>();

    private CSSUpdater() {
    }

    static synchronized CSSUpdater getDefault() {
        if (instance == null) {
            instance = new CSSUpdater();
        }
        return instance;
    }

    synchronized void start(WebKitDebugging webKit, Project project) {
        assert (webKit != null) : "webKit allready assigned";
        this.webKit = webKit;
        this.project = project;
        this.localhost = null;
        try {
            this.localhost = WebUtils.getLocalhostInetAddress();
        }
        catch (IllegalStateException isex) {
            Logger.getLogger(CSSUpdater.class.getName()).log(Level.INFO, null, isex);
        }
        this.listener = new Listener();
        webKit.getCSS().addListener(this.listener);
        for (StyleSheetHeader header : webKit.getCSS().getAllStyleSheets()) {
            this.registerStyleSheet(header);
        }
    }

    synchronized void registerStyleSheet(StyleSheetHeader header) {
        try {
            FileObject fob;
            URL url = new URL(header.getSourceURL());
            this.sheetsMap.put(url.toString(), header);
            if (this.project != null && (fob = ServerURLMapping.fromServer((Project)this.project, (URL)url)) != null) {
                this.fobToSheetMap.put(fob, header);
            }
            if (this.localhost != null && this.localhost.equals(InetAddress.getByName(url.getHost()))) {
                this.sheetsMap.put(new URL(url.toExternalForm().replace(url.getHost(), "localhost")).toString(), header);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    synchronized void stop() {
        if (this.webKit != null) {
            this.webKit.getCSS().removeListener(this.listener);
        }
        this.webKit = null;
        this.localhost = null;
        this.project = null;
        this.listener = null;
        this.sheetsMap.clear();
        this.fobToSheetMap.clear();
    }

    synchronized boolean isStarted() {
        return this.webKit != null;
    }

    synchronized void update(FileObject fileObject, String content) {
        if (this.webKit == null) {
            return;
        }
        Project owner = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (owner == null) {
            return;
        }
        URL serverUrl = ServerURLMapping.toServer((Project)owner, (FileObject)fileObject);
        if (serverUrl == null) {
            return;
        }
        String mimeType = fileObject.getMIMEType();
        if (mimeType.equals("text/html")) {
            return;
        }
        StyleSheetHeader header = this.sheetsMap.get(serverUrl.toString());
        if (header == null) {
            header = this.fobToSheetMap.get(fileObject);
        }
        if (header != null) {
            this.webKit.getCSS().setStyleSheetText(header.getStyleSheetId(), content);
        }
    }

    private class Listener
    implements CSS.Listener {
        private Listener() {
        }

        public void mediaQueryResultChanged() {
        }

        public void styleSheetChanged(String styleSheetId) {
        }

        public void styleSheetAdded(StyleSheetHeader header) {
            CSSUpdater.this.registerStyleSheet(header);
        }

        public void styleSheetRemoved(String styleSheetId) {
        }
    }

    public static class LiveUpdaterImpl
    implements LiveUpdater {
        private final RequestProcessor RP = new RequestProcessor(LiveUpdaterImpl.class);

        public boolean update(final Document doc) {
            if (!CSSUpdater.getDefault().isStarted()) {
                return false;
            }
            this.RP.post(new Runnable(){

                @Override
                public void run() {
                    doc.render(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                String text = doc.getText(0, doc.getLength());
                                CSSUpdater.getDefault().update(LiveUpdaterImpl.getDataObject(doc).getPrimaryFile(), text);
                            }
                            catch (BadLocationException badLocationException) {
                                Exceptions.printStackTrace((Throwable)badLocationException);
                            }
                        }
                    });
                }
            });
            return false;
        }

        private static DataObject getDataObject(Document doc) {
            Object sdp;
            Object object = sdp = doc == null ? null : doc.getProperty("stream");
            if (sdp instanceof DataObject) {
                return (DataObject)sdp;
            }
            return null;
        }
    }
}

