/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.moduletask.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import org.netbeans.modules.java.j2seproject.moduletask.classfile.Attribute;
import org.netbeans.modules.java.j2seproject.moduletask.classfile.ConstantPool;
import org.netbeans.modules.java.j2seproject.moduletask.classfile.FieldInfo;
import org.netbeans.modules.java.j2seproject.moduletask.classfile.MethodInfo;
import org.netbeans.modules.java.j2seproject.moduletask.classfile.Reader;
import org.netbeans.modules.java.j2seproject.moduletask.classfile.Writer;

public final class ClassFile {
    private static final long MAGIC = 3405691582L;
    private final int minorVersion;
    private final int majorVersion;
    private ConstantPool cp;
    private final int accessFlags;
    private final int thisIndex;
    private final int superIndex;
    private final int[] interfacesIndexes;
    private final FieldInfo[] fields;
    private final MethodInfo[] methods;
    private Attribute[] attributes;

    public ClassFile(InputStream input) throws IOException {
        int i;
        Reader in = new Reader(new DataInputStream(input));
        if (in.readUnsignedInt() != 3405691582L) {
            throw new IllegalArgumentException("Not a classfile");
        }
        this.minorVersion = in.readUnsignedShort();
        this.majorVersion = in.readUnsignedShort();
        this.cp = new ConstantPool(in);
        this.accessFlags = in.readUnsignedShort();
        this.thisIndex = in.readUnsignedShort();
        this.superIndex = in.readUnsignedShort();
        this.interfacesIndexes = new int[in.readUnsignedShort()];
        for (i = 0; i < this.interfacesIndexes.length; ++i) {
            this.interfacesIndexes[i] = in.readUnsignedShort();
        }
        this.fields = new FieldInfo[in.readUnsignedShort()];
        for (i = 0; i < this.fields.length; ++i) {
            this.fields[i] = new FieldInfo(in);
        }
        this.methods = new MethodInfo[in.readUnsignedShort()];
        for (i = 0; i < this.methods.length; ++i) {
            this.methods[i] = new MethodInfo(in);
        }
        this.attributes = new Attribute[in.readUnsignedShort()];
        for (i = 0; i < this.attributes.length; ++i) {
            this.attributes[i] = new Attribute(in);
        }
    }

    public void write(OutputStream output) throws IOException {
        int i;
        Writer out = new Writer(new DataOutputStream(output));
        out.writeUnsignedInt(3405691582L);
        out.writeUnsignedShort(this.minorVersion);
        out.writeUnsignedShort(this.majorVersion);
        this.cp.write(out);
        out.writeUnsignedShort(this.accessFlags);
        out.writeUnsignedShort(this.thisIndex);
        out.writeUnsignedShort(this.superIndex);
        out.writeUnsignedShort(this.interfacesIndexes.length);
        for (i = 0; i < this.interfacesIndexes.length; ++i) {
            out.writeUnsignedShort(this.interfacesIndexes[i]);
        }
        out.writeUnsignedShort(this.fields.length);
        for (i = 0; i < this.fields.length; ++i) {
            this.fields[i].write(out);
        }
        out.writeUnsignedShort(this.methods.length);
        for (i = 0; i < this.methods.length; ++i) {
            this.methods[i].write(out);
        }
        out.writeUnsignedShort(this.attributes.length);
        for (i = 0; i < this.attributes.length; ++i) {
            this.attributes[i].write(out);
        }
        out.flush();
    }

    public ConstantPool getConstantPool() {
        return this.cp;
    }

    public Attribute[] getAttributes() {
        return Arrays.copyOf(this.attributes, this.attributes.length);
    }

    public boolean addAttribute(Attribute attr) {
        this.attributes = Arrays.copyOf(this.attributes, this.attributes.length + 1);
        this.attributes[this.attributes.length - 1] = attr;
        return true;
    }

    public boolean removeAttribute(int index) {
        if (index < 0 || index >= this.attributes.length) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        Attribute[] newAttrs = new Attribute[this.attributes.length - 1];
        System.arraycopy(this.attributes, 0, newAttrs, 0, index);
        System.arraycopy(this.attributes, index + 1, newAttrs, index, newAttrs.length - index);
        this.attributes = newAttrs;
        return true;
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append(this.majorVersion).append('.').append(this.minorVersion).append('\n');
        res.append(this.cp).append('\n');
        res.append(Access.fromIntBits(this.accessFlags)).append('\n');
        res.append(this.thisIndex).append('\n');
        res.append(this.superIndex).append('\n');
        res.append('[');
        boolean first = true;
        for (int i : this.interfacesIndexes) {
            if (first) {
                first = false;
            } else {
                res.append(" ,");
            }
            res.append(i);
        }
        res.append(']');
        for (Attribute attr : this.attributes) {
            res.append(attr).append('\n');
        }
        return res.toString();
    }

    static enum Access {
        ACC_PUBLIC(1),
        ACC_FINAL(16),
        ACC_SUPER(32),
        ACC_INTERFACE(512),
        ACC_ABSTRACT(1024),
        ACC_SYNTHETIC(4096),
        ACC_ANNOTATION(8192),
        ACC_ENUM(16384);

        private final int mask;

        private Access(int mask) {
            this.mask = mask;
        }

        static Set<Access> fromIntBits(int val) {
            EnumSet<Access> s = EnumSet.noneOf(Access.class);
            for (Access a : Access.values()) {
                if ((val & a.mask) != a.mask) continue;
                s.add(a);
            }
            return s;
        }

        static int toIntBits(Set<? extends Access> set) {
            int res = 0;
            for (Access access : set) {
                res |= access.mask;
            }
            return res;
        }
    }
}

