/**
 * The MutationEvent interface provides specific contextual information associated with Mutation events.
 */
var MutationEvent = {
}
/**
 * prevValue indicates the previous value of the Attr node in DOMAttrModified events, and of the CharacterData node in DOMCharDataModified events.
 * @syntax mutationEvent.prevValue
 * @returns {String} 
 */
MutationEvent.prototype.prevValue = new String();

/**
 * The Attr was just removed.
 * @syntax MutationEvent.REMOVAL
 * @returns {Number} 
 * @static
 */
MutationEvent.REMOVAL = new Number();

/**
 * newValue indicates the new value of the Attr node in DOMAttrModified events, and of the CharacterData node in DOMCharDataModified events.
 * @syntax mutationEvent.newValue
 * @returns {String} 
 */
MutationEvent.prototype.newValue = new String();

/**
 * The Attr was just added.
 * @syntax MutationEvent.ADDITION
 * @returns {Number} 
 * @static
 */
MutationEvent.ADDITION = new Number();

/**
 * relatedNode is used to identify a secondary node related to a mutation event. For example, if a mutation event is dispatched to a node indicating that its parent has changed, the relatedNode is the changed parent. If an event is instead dispatched to a subtree indicating a node was changed within it, the relatedNode is the changed node. In the case of the DOMAttrModified event it indicates the Attr node which was modified, added, or removed.
 * @syntax mutationEvent.relatedNode
 * @returns {Node} 
 */
MutationEvent.prototype.relatedNode = new Node();

/**
 * attrName indicates the name of the changed Attr node in a DOMAttrModified event.
 * @syntax mutationEvent.attrName
 * @returns {String} 
 */
MutationEvent.prototype.attrName = new String();

/**
 * attrChange indicates the type of change which triggered the DOMAttrModified event. The values can be MODIFICATION, ADDITION, or REMOVAL.
 * @syntax mutationEvent.attrChange
 * @returns {Number} 
 */
MutationEvent.prototype.attrChange = new Number();

/**
 * The Attr was modified in place.
 * @syntax MutationEvent.MODIFICATION
 * @returns {Number} 
 * @static
 */
MutationEvent.MODIFICATION = new Number();

/**
 * The initMutationEvent method is used to initialize the value of a MutationEvent created through the DocumentEvent interface. This method may only be called before the MutationEvent has been dispatched via the dispatchEvent method, though it may be called multiple times during that phase if necessary. If called multiple times, the final invocation takes precedence.
 * @syntax mutationEvent.initMutationEvent(typeArg, canBubbleArg, cancelableArg, relatedNodeArg, prevValueArg, newValueArg, attrNameArg, attrChangeArg)
 * @param {String} typeArg Specifies the event type.
 * @param {boolean} canBubbleArg Specifies whether or not the event can bubble.
 * @param {boolean} cancelableArg Specifies whether or not the event's default action can be prevented.
 * @param {Node} relatedNodeArg Specifies the Event's related Node.
 * @param {String} prevValueArg Specifies the Event's prevValue attribute. This value may be null.
 * @param {String} newValueArg Specifies the Event's newValue attribute. This value may be null.
 * @param {String} attrNameArg Specifies the Event's attrName attribute. This value may be null.
 * @param {Number} attrChangeArg Specifies the Event's attrChange attribute
 * @returns {undefined} 
 */
MutationEvent.prototype.initMutationEvent = function(typeArg,  canBubbleArg,  cancelableArg,  relatedNodeArg,  prevValueArg,  newValueArg,  attrNameArg,  attrChangeArg) {};

/**
 * Represents the MutationEvent prototype object.
 * @syntax MutationEvent.prototype
 * @static
 */
MutationEvent.prototype;

