/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.ui.FlatBorder;
import com.formdev.flatlaf.ui.FlatButtonBorder;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeEvent;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;

public class FlatButtonUI
extends BasicButtonUI {
    protected int focusWidth;
    protected int arc;
    protected int minimumWidth;
    protected int iconTextGap;
    protected Color startBackground;
    protected Color endBackground;
    protected Color focusedBackground;
    protected Color hoverBackground;
    protected Color pressedBackground;
    protected Color disabledText;
    protected Color defaultBackground;
    protected Color defaultEndBackground;
    protected Color defaultForeground;
    protected Color defaultFocusedBackground;
    protected Color defaultHoverBackground;
    protected Color defaultPressedBackground;
    protected boolean defaultBoldText;
    protected int shadowWidth;
    protected Color shadowColor;
    protected Color defaultShadowColor;
    protected Insets toolbarSpacingInsets;
    protected Color toolbarHoverBackground;
    protected Color toolbarPressedBackground;
    private Icon helpButtonIcon;
    private boolean defaults_initialized = false;
    private static ComponentUI instance;

    public static ComponentUI createUI(JComponent c) {
        if (instance == null) {
            instance = new FlatButtonUI();
        }
        return instance;
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        Color bg;
        super.installDefaults(b);
        if (!this.defaults_initialized) {
            String prefix = this.getPropertyPrefix();
            this.focusWidth = UIManager.getInt("Component.focusWidth");
            this.arc = UIManager.getInt("Button.arc");
            this.minimumWidth = UIManager.getInt(prefix + "minimumWidth");
            this.iconTextGap = FlatUIUtils.getUIInt(prefix + "iconTextGap", 4);
            this.startBackground = UIManager.getColor(prefix + "startBackground");
            this.endBackground = UIManager.getColor(prefix + "endBackground");
            this.focusedBackground = UIManager.getColor(prefix + "focusedBackground");
            this.hoverBackground = UIManager.getColor(prefix + "hoverBackground");
            this.pressedBackground = UIManager.getColor(prefix + "pressedBackground");
            this.disabledText = UIManager.getColor(prefix + "disabledText");
            if (UIManager.getBoolean("Button.paintShadow")) {
                this.shadowWidth = FlatUIUtils.getUIInt("Button.shadowWidth", 2);
                this.shadowColor = UIManager.getColor("Button.shadowColor");
                this.defaultShadowColor = UIManager.getColor("Button.default.shadowColor");
            } else {
                this.shadowWidth = 0;
                this.shadowColor = null;
                this.defaultShadowColor = null;
            }
            this.defaultBackground = FlatUIUtils.getUIColor("Button.default.startBackground", "Button.default.background");
            this.defaultEndBackground = UIManager.getColor("Button.default.endBackground");
            this.defaultForeground = UIManager.getColor("Button.default.foreground");
            this.defaultFocusedBackground = UIManager.getColor("Button.default.focusedBackground");
            this.defaultHoverBackground = UIManager.getColor("Button.default.hoverBackground");
            this.defaultPressedBackground = UIManager.getColor("Button.default.pressedBackground");
            this.defaultBoldText = UIManager.getBoolean("Button.default.boldText");
            this.toolbarSpacingInsets = UIManager.getInsets("Button.toolbar.spacingInsets");
            this.toolbarHoverBackground = UIManager.getColor(prefix + "toolbar.hoverBackground");
            this.toolbarPressedBackground = UIManager.getColor(prefix + "toolbar.pressedBackground");
            this.helpButtonIcon = UIManager.getIcon("HelpButton.icon");
            this.defaults_initialized = true;
        }
        if (this.startBackground != null && ((bg = b.getBackground()) == null || bg instanceof UIResource)) {
            b.setBackground(this.startBackground);
        }
        LookAndFeel.installProperty(b, "opaque", false);
        LookAndFeel.installProperty(b, "iconTextGap", UIScale.scale(this.iconTextGap));
        MigLayoutVisualPadding.install((JComponent)b, this.getFocusWidth(b));
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        MigLayoutVisualPadding.uninstall(b);
        this.defaults_initialized = false;
    }

    @Override
    protected BasicButtonListener createButtonListener(final AbstractButton b) {
        return new BasicButtonListener(b){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                super.propertyChange(e);
                FlatButtonUI.this.propertyChange(b, e);
            }
        };
    }

    protected void propertyChange(AbstractButton b, PropertyChangeEvent e) {
        switch (e.getPropertyName()) {
            case "JComponent.minimumWidth": 
            case "JComponent.minimumHeight": {
                b.revalidate();
            }
        }
    }

    static boolean isContentAreaFilled(Component c) {
        return !(c instanceof AbstractButton) || ((AbstractButton)c).isContentAreaFilled();
    }

    static boolean isDefaultButton(Component c) {
        return c instanceof JButton && ((JButton)c).isDefaultButton();
    }

    static boolean isIconOnlyButton(Component c) {
        if (!(c instanceof JButton) && !(c instanceof JToggleButton)) {
            return false;
        }
        Icon icon = ((AbstractButton)c).getIcon();
        String text = ((AbstractButton)c).getText();
        return icon != null && (text == null || text.isEmpty()) || icon == null && text != null && ("...".equals(text) || text.length() == 1);
    }

    static boolean isSquareButton(Component c) {
        return c instanceof AbstractButton && FlatClientProperties.clientPropertyEquals((AbstractButton)c, "JButton.buttonType", "square");
    }

    static boolean isHelpButton(Component c) {
        return c instanceof JButton && FlatClientProperties.clientPropertyEquals((JButton)c, "JButton.buttonType", "help");
    }

    static boolean isToolBarButton(Component c) {
        return c.getParent() instanceof JToolBar;
    }

    @Override
    public void update(Graphics g, JComponent c) {
        if (c.isOpaque()) {
            FlatUIUtils.paintParentBackground(g, c);
        }
        if (FlatButtonUI.isHelpButton(c)) {
            this.helpButtonIcon.paintIcon(c, g, 0, 0);
            return;
        }
        if (FlatButtonUI.isContentAreaFilled(c)) {
            this.paintBackground(g, c);
        }
        this.paint(g, c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintBackground(Graphics g, JComponent c) {
        Color background = this.getBackground(c);
        if (background != null) {
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                Color endBg;
                Color shadowColor;
                FlatUIUtils.setRenderingHints(g2);
                Border border = c.getBorder();
                boolean isToolBarButton = FlatButtonUI.isToolBarButton(c);
                float focusWidth = border instanceof FlatBorder && !isToolBarButton ? UIScale.scale((float)this.getFocusWidth(c)) : 0.0f;
                float arc = border instanceof FlatButtonBorder && !FlatButtonUI.isSquareButton(c) || isToolBarButton ? UIScale.scale((float)this.arc) : 0.0f;
                boolean def = FlatButtonUI.isDefaultButton(c);
                int x = 0;
                int y = 0;
                int width = c.getWidth();
                int height = c.getHeight();
                if (isToolBarButton) {
                    Insets spacing = UIScale.scale(this.toolbarSpacingInsets);
                    x += spacing.left;
                    y += spacing.top;
                    width -= spacing.left + spacing.right;
                    height -= spacing.top + spacing.bottom;
                }
                Color color = shadowColor = def ? this.defaultShadowColor : this.shadowColor;
                if (!isToolBarButton && shadowColor != null && this.shadowWidth > 0 && focusWidth > 0.0f && !FlatUIUtils.isPermanentFocusOwner(c) && c.isEnabled()) {
                    g2.setColor(shadowColor);
                    g2.fill(new RoundRectangle2D.Float(focusWidth, focusWidth + UIScale.scale((float)this.shadowWidth), (float)width - focusWidth * 2.0f, (float)height - focusWidth * 2.0f, arc, arc));
                }
                Color startBg = def ? this.defaultBackground : this.startBackground;
                Color color2 = endBg = def ? this.defaultEndBackground : this.endBackground;
                if (background == startBg && endBg != null && !startBg.equals(endBg)) {
                    g2.setPaint(new GradientPaint(0.0f, 0.0f, startBg, 0.0f, height, endBg));
                } else {
                    FlatUIUtils.setColor(g2, background, def ? this.defaultBackground : c.getBackground());
                }
                FlatUIUtils.paintComponentBackground(g2, x, y, width, height, focusWidth, arc);
            }
            finally {
                g2.dispose();
            }
        }
    }

    @Override
    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        if (FlatButtonUI.isHelpButton(b)) {
            return;
        }
        if (this.defaultBoldText && FlatButtonUI.isDefaultButton(b) && b.getFont() instanceof UIResource) {
            Font boldFont = g.getFont().deriveFont(1);
            g.setFont(boldFont);
            int boldWidth = b.getFontMetrics(boldFont).stringWidth(text);
            if (boldWidth > textRect.width) {
                textRect.x -= (boldWidth - textRect.width) / 2;
                textRect.width = boldWidth;
            }
        }
        FlatButtonUI.paintText(g, b, textRect, text, b.isEnabled() ? this.getForeground(b) : this.disabledText);
    }

    public static void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text, Color foreground) {
        FontMetrics fm = b.getFontMetrics(b.getFont());
        int mnemonicIndex = FlatLaf.isShowMnemonics() ? b.getDisplayedMnemonicIndex() : -1;
        g.setColor(foreground);
        FlatUIUtils.drawStringUnderlineCharAt(b, g, text, mnemonicIndex, textRect.x, textRect.y + fm.getAscent());
    }

    protected Color getBackground(JComponent c) {
        if (!c.isEnabled()) {
            return null;
        }
        if (FlatButtonUI.isToolBarButton(c)) {
            ButtonModel model = ((AbstractButton)c).getModel();
            if (model.isPressed()) {
                return this.toolbarPressedBackground;
            }
            if (model.isRollover()) {
                return this.toolbarHoverBackground;
            }
            return c.getParent().getBackground();
        }
        boolean def = FlatButtonUI.isDefaultButton(c);
        return FlatButtonUI.buttonStateColor(c, def ? this.defaultBackground : c.getBackground(), null, def ? this.defaultFocusedBackground : this.focusedBackground, def ? this.defaultHoverBackground : this.hoverBackground, def ? this.defaultPressedBackground : this.pressedBackground);
    }

    public static Color buttonStateColor(Component c, Color enabledColor, Color disabledColor, Color focusedColor, Color hoverColor, Color pressedColor) {
        AbstractButton b;
        AbstractButton abstractButton = b = c instanceof AbstractButton ? (AbstractButton)c : null;
        if (!c.isEnabled()) {
            return disabledColor;
        }
        if (pressedColor != null && b != null && b.getModel().isPressed()) {
            return pressedColor;
        }
        if (hoverColor != null && b != null && b.getModel().isRollover()) {
            return hoverColor;
        }
        if (focusedColor != null && FlatUIUtils.isPermanentFocusOwner(c)) {
            return focusedColor;
        }
        return enabledColor;
    }

    protected Color getForeground(JComponent c) {
        boolean def = FlatButtonUI.isDefaultButton(c);
        return def ? this.defaultForeground : c.getForeground();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (FlatButtonUI.isHelpButton(c)) {
            return new Dimension(this.helpButtonIcon.getIconWidth(), this.helpButtonIcon.getIconHeight());
        }
        Dimension prefSize = super.getPreferredSize(c);
        if (prefSize == null) {
            return null;
        }
        if (FlatButtonUI.isIconOnlyButton(c)) {
            prefSize.width = Math.max(prefSize.width, prefSize.height);
        } else if (!FlatButtonUI.isToolBarButton(c) && c.getBorder() instanceof FlatButtonBorder) {
            int focusWidth = this.getFocusWidth(c);
            prefSize.width = Math.max(prefSize.width, UIScale.scale(FlatUIUtils.minimumWidth(c, this.minimumWidth) + focusWidth * 2));
            prefSize.height = Math.max(prefSize.height, UIScale.scale(FlatUIUtils.minimumHeight(c, 0) + focusWidth * 2));
        }
        return prefSize;
    }

    protected int getFocusWidth(JComponent c) {
        return this.focusWidth;
    }
}

