/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.views.debugging;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.Session;
import org.netbeans.modules.debugger.ui.views.debugging.DebuggingViewComponent;
import org.netbeans.modules.debugger.ui.views.debugging.FiltersDescriptor;
import org.netbeans.modules.debugger.ui.views.debugging.TapPanel;
import org.netbeans.spi.debugger.ui.DebuggingView;
import org.openide.awt.DropDownButtonFactory;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class InfoPanel
extends JPanel {
    private static final int PANEL_HEIGHT = 40;
    private static final int FILTERS = 0;
    private static final int HITS = 1;
    private static final int DEADLOCKS = 2;
    private static final int DEADLOCKS_BY_DEBUGGER = 3;
    private static final int STEP_BRKP = 4;
    private Color hitsPanelColor;
    private Color deadlockPanelColor;
    private Color filterPanelColor;
    private Color stepBrkpColor;
    private int tapPanelMinimumHeight;
    private TapPanel tapPanel;
    private Item[] items;
    private JButton arrowButton;
    private JPopupMenu arrowMenu;
    private Map<DebuggingView.DVThread, JMenuItem> threadToMenuItem = new WeakHashMap<DebuggingView.DVThread, JMenuItem>();
    private DebuggingView.DVThread debuggerDeadlockThread;
    private WeakReference<DebuggingView.DVSupport> stepBrkpDVSupportRef;
    private DebuggingViewComponent debuggingView;
    private JPanel deadlocksInnerPanel;
    private JLabel deadlocksLabel;
    private JPanel debuggerDeadlocksInnerPanel;
    private JLabel debuggerDeadlocksLabel;
    private JPanel emptyPanel;
    private JPanel emptyPanel1;
    private JPanel emptyPanel2;
    private JPanel hitsInnerPanel;
    private JLabel hitsLabel;
    private JLabel infoIcon;
    private JLabel infoIcon1;
    private JLabel infoIcon2;
    private JLabel infoIcon3;
    private JButton resumeDebuggerDeadlockButton;
    private JLabel resumeDebuggerDeadlockLabel;
    private JButton stepBrkpIgnoreButton;
    private JPanel stepBrkpInnerPanel;
    private JLabel stepBrkpLabel;

    public InfoPanel(TapPanel tapPanel, DebuggingViewComponent debuggingView) {
        this.tapPanel = tapPanel;
        this.debuggingView = debuggingView;
        this.filterPanelColor = tapPanel.getBackground();
        this.deadlockPanelColor = this.hitsPanelColor = DebuggingViewComponent.hitsColor;
        this.stepBrkpColor = this.hitsPanelColor;
        this.tapPanelMinimumHeight = tapPanel.getMinimumHeight();
        this.initComponents();
        this.items = new Item[5];
        this.items[0] = new Item(this.filterPanelColor, 40, this.createFilterToolBar());
        this.items[1] = new Item(this.hitsPanelColor, 40, this.hitsInnerPanel);
        this.items[2] = new Item(this.hitsPanelColor, 40, this.deadlocksInnerPanel);
        this.items[3] = new Item(this.deadlockPanelColor, 80, this.debuggerDeadlocksInnerPanel);
        this.items[4] = new Item(this.stepBrkpColor, 80, this.stepBrkpInnerPanel);
        this.items[0].getPanel().setBorder(new EmptyBorder(1, 2, 1, 5));
        this.arrowButton = this.createArrowButton();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        this.hitsInnerPanel.add((Component)this.arrowButton, gridBagConstraints);
        this.removeAll();
        this.items[0].makeVisible(false, true, null);
        this.items[1].makeInvisible();
        this.items[2].makeInvisible();
        this.items[3].makeInvisible();
        this.items[4].makeInvisible();
        for (int x = this.items.length - 1; x >= 0; --x) {
            this.add(this.items[x].scrollPane);
            if (x <= 0) continue;
            this.add(this.items[x].separator);
        }
    }

    void clearBreakpointHits() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InfoPanel.this.arrowMenu.removeAll();
                InfoPanel.this.threadToMenuItem.clear();
                InfoPanel.this.hideHitsPanel();
            }
        });
    }

    void removeBreakpointHit(final DebuggingView.DVThread thread, final int newHitsCount) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JMenuItem item = (JMenuItem)InfoPanel.this.threadToMenuItem.remove(thread);
                if (item == null) {
                    return;
                }
                InfoPanel.this.arrowMenu.remove(item);
                InfoPanel.this.setHitsText(newHitsCount);
                if (newHitsCount == 0) {
                    InfoPanel.this.hideHitsPanel();
                }
            }
        });
    }

    void addBreakpointHit(final DebuggingView.DVThread thread, final int newHitsCount) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (InfoPanel.this.threadToMenuItem.get(thread) != null) {
                    return;
                }
                JMenuItem item = InfoPanel.this.createMenuItem(thread.getDVSupport(), thread);
                InfoPanel.this.threadToMenuItem.put(thread, item);
                InfoPanel.this.arrowMenu.add(item);
                InfoPanel.this.setHitsText(newHitsCount);
                if (newHitsCount == 1) {
                    InfoPanel.this.showHitsPanel();
                }
            }
        });
    }

    void setBreakpointHits(final DebuggingView.DVSupport dvs, final List<DebuggingView.DVThread> hits) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InfoPanel.this.arrowMenu.removeAll();
                InfoPanel.this.threadToMenuItem.clear();
                for (DebuggingView.DVThread thread : hits) {
                    JMenuItem item = InfoPanel.this.createMenuItem(dvs, thread);
                    InfoPanel.this.threadToMenuItem.put(thread, item);
                    InfoPanel.this.arrowMenu.add(item);
                }
                if (hits.size() == 0) {
                    InfoPanel.this.hideHitsPanel();
                } else {
                    InfoPanel.this.setHitsText(hits.size());
                    InfoPanel.this.showHitsPanel();
                }
            }
        });
    }

    public void recomputeMenuItems(final DebuggingView.DVSupport dvs, final List<DebuggingView.DVThread> hits) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                InfoPanel.this.arrowMenu.removeAll();
                InfoPanel.this.threadToMenuItem.clear();
                for (DebuggingView.DVThread thread : hits) {
                    JMenuItem item = InfoPanel.this.createMenuItem(dvs, thread);
                    InfoPanel.this.threadToMenuItem.put(thread, item);
                    InfoPanel.this.arrowMenu.add(item);
                }
            }
        });
    }

    private JMenuItem createMenuItem(DebuggingView.DVSupport dvs, final DebuggingView.DVThread thread) {
        String displayName = dvs.getDisplayName(thread);
        Image image = dvs.getIcon(thread);
        ImageIcon icon = image != null ? new ImageIcon(image) : null;
        JMenuItem item = new JMenuItem(displayName, icon);
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InfoPanel.this.debuggingView.makeThreadCurrent(thread);
            }
        });
        return item;
    }

    private void setHitsText(int hitsNumber) {
        String text = hitsNumber == 1 ? NbBundle.getMessage(InfoPanel.class, (String)"LBL_OneNewHit") : NbBundle.getMessage(InfoPanel.class, (String)"LBL_NewHits", (Object)hitsNumber);
        this.hitsLabel.setText(text);
    }

    void setShowDeadlock(final boolean visible) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (visible) {
                    InfoPanel.this.showDeadlocksPanel();
                } else {
                    InfoPanel.this.hideDeadlocksPanel();
                }
            }
        });
    }

    void setShowThreadLocks(final DebuggingView.DVThread thread, final List<DebuggingView.DVThread> lockerThreads) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (lockerThreads != null) {
                    InfoPanel.this.showDebuggerDeadlockPanel(thread, lockerThreads);
                } else {
                    InfoPanel.this.hideDebuggerDeadlockPanel();
                }
            }
        });
    }

    void setShowStepBrkp(final DebuggingView.DVSupport dvSupport, final DebuggingView.DVThread thread, final Breakpoint breakpoint) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (breakpoint != null) {
                    InfoPanel.this.showStepBrkpPanel(dvSupport, thread, breakpoint);
                } else {
                    InfoPanel.this.hideStepBrkpPanel();
                }
            }
        });
    }

    private void hidePanel(int index) {
        int i;
        Item item = this.items[index];
        if (!item.isVisible()) {
            return;
        }
        item.makeInvisible();
        boolean wasOnTop = true;
        for (i = index + 1; i < this.items.length; ++i) {
            if (!this.items[i].isVisible()) continue;
            wasOnTop = false;
            break;
        }
        if (wasOnTop) {
            for (i = index - 1; i >= 0; --i) {
                if (!this.items[i].isVisible()) continue;
                this.items[i].setTop(true);
                break;
            }
        }
    }

    private void showPanel(int index) {
        Item item = this.items[index];
        if (item.isVisible()) {
            return;
        }
        boolean isOnTop = true;
        for (int i = index + 1; i < this.items.length; ++i) {
            if (!this.items[i].isVisible()) continue;
            isOnTop = false;
            break;
        }
        Item previousTop = null;
        if (isOnTop) {
            for (int i = index - 1; i >= 0; --i) {
                if (!this.items[i].isVisible()) continue;
                previousTop = this.items[i];
                break;
            }
        }
        item.makeVisible(true, isOnTop, previousTop);
    }

    private void hideHitsPanel() {
        this.hidePanel(1);
    }

    private void showHitsPanel() {
        this.showPanel(1);
    }

    private void hideDeadlocksPanel() {
        this.hidePanel(2);
    }

    private void showDeadlocksPanel() {
        this.showPanel(2);
    }

    private void hideDebuggerDeadlockPanel() {
        this.hidePanel(3);
    }

    private void showDebuggerDeadlockPanel(DebuggingView.DVThread thread, List<DebuggingView.DVThread> lockerThreads) {
        String resumeResource;
        String infoResource;
        this.debuggerDeadlockThread = thread;
        int numThreads = lockerThreads.size();
        if (numThreads == 1) {
            String resumeTooltipResource;
            if (thread.isInStep()) {
                infoResource = "InfoPanel.debuggerDeadlocksLabelThread.text";
                resumeTooltipResource = "InfoPanel.resumeDebuggerDeadlockButtonThread.tooltip";
            } else {
                infoResource = "InfoPanel.debuggerDeadlocksLabelThread.Method.text";
                resumeTooltipResource = "InfoPanel.resumeDebuggerDeadlockButtonThread.Method.tooltip";
            }
            resumeResource = "InfoPanel.resumeDebuggerDeadlockLabelThread.text";
            this.debuggerDeadlocksLabel.setToolTipText(null);
            this.resumeDebuggerDeadlockButton.setToolTipText(NbBundle.getMessage(InfoPanel.class, (String)resumeTooltipResource, (Object)lockerThreads.get(0).getName()));
        } else {
            String resumeTooltipResource;
            if (thread.isInStep()) {
                infoResource = "InfoPanel.debuggerDeadlocksLabel.text";
                resumeTooltipResource = "InfoPanel.resumeDebuggerDeadlockButton.tooltip";
            } else {
                infoResource = "InfoPanel.debuggerDeadlocksLabel.Method.text";
                resumeTooltipResource = "InfoPanel.resumeDebuggerDeadlockButton.Method.tooltip";
            }
            resumeResource = "InfoPanel.resumeDebuggerDeadlockLabel.text";
            StringBuilder threadNamesBuilder = new StringBuilder(lockerThreads.get(0).getName());
            for (int i = 1; i < lockerThreads.size(); ++i) {
                threadNamesBuilder.append(", ");
                threadNamesBuilder.append(lockerThreads.get(i).getName());
            }
            String threadNames = threadNamesBuilder.toString();
            this.debuggerDeadlocksLabel.setToolTipText(NbBundle.getMessage(InfoPanel.class, (String)"InfoPanel.debuggerDeadlocksLabel.tooltip", (Object)threadNames));
            this.resumeDebuggerDeadlockButton.setToolTipText(NbBundle.getMessage(InfoPanel.class, (String)resumeTooltipResource, (Object)threadNames));
        }
        this.debuggerDeadlocksLabel.setText(NbBundle.getMessage(InfoPanel.class, (String)infoResource, (Object)lockerThreads.get(0).getName()));
        this.resumeDebuggerDeadlockLabel.setText(NbBundle.getMessage(InfoPanel.class, (String)resumeResource));
        if (this.items[2].isVisible()) {
            return;
        }
        this.showPanel(3);
    }

    private void hideStepBrkpPanel() {
        this.hidePanel(4);
    }

    private void showStepBrkpPanel(DebuggingView.DVSupport dvSupport, DebuggingView.DVThread thread, Breakpoint breakpoint) {
        this.stepBrkpDVSupportRef = new WeakReference<DebuggingView.DVSupport>(dvSupport);
        String text = NbBundle.getMessage(InfoPanel.class, (String)"InfoPanel.stepBrkpLabel.text", (Object)thread.getName());
        this.stepBrkpLabel.setText(text);
        this.stepBrkpLabel.setToolTipText(text);
        this.showPanel(4);
    }

    private JButton createArrowButton() {
        this.arrowMenu = new JPopupMenu();
        JButton button = DropDownButtonFactory.createDropDownButton((Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/debugger/resources/debuggingView/unvisited_bpkt_arrow_small_16.png", (boolean)false), (JPopupMenu)this.arrowMenu);
        button.setPreferredSize(new Dimension(40, button.getPreferredSize().height));
        button.setMaximumSize(new Dimension(40, button.getPreferredSize().height));
        button.setFocusable(false);
        button.setOpaque(false);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (InfoPanel.this.arrowMenu.getComponentCount() > 0) {
                    Component item = InfoPanel.this.arrowMenu.getComponent(0);
                    for (Map.Entry entry : InfoPanel.this.threadToMenuItem.entrySet()) {
                        if (entry.getValue() != item) continue;
                        InfoPanel.this.debuggingView.makeThreadCurrent((DebuggingView.DVThread)entry.getKey());
                    }
                }
            }
        });
        return button;
    }

    private JToolBar createFilterToolBar() {
        final FiltersDescriptor filtersDesc = FiltersDescriptor.getInstance();
        final NoBorderToolBar toolbar = new NoBorderToolBar();
        toolbar.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        toolbar.setFloatable(false);
        toolbar.setBorderPainted(false);
        toolbar.setOpaque(false);
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            toolbar.setBackground(UIManager.getColor("NbExplorerView.background"));
        }
        this.createFilterToolBarUI(toolbar, filtersDesc);
        filtersDesc.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        InfoPanel.this.createFilterToolBarUI(toolbar, filtersDesc);
                    }
                });
            }
        });
        return toolbar;
    }

    private void createFilterToolBarUI(JToolBar toolbar, FiltersDescriptor filtersDesc) {
        int i;
        toolbar.removeAll();
        int filterCount = filtersDesc.getFilterCount();
        ArrayList<JToggleButton> toggles = new ArrayList<JToggleButton>(filterCount);
        JToggleButton toggleButton = null;
        for (i = 0; i < filterCount; ++i) {
            toggleButton = this.createToggle(filtersDesc, i);
            toggles.add(toggleButton);
        }
        for (i = 0; i < toggles.size(); ++i) {
            JToggleButton curToggle = (JToggleButton)toggles.get(i);
            curToggle.addActionListener(new ToggleButtonActionListener(i));
            toolbar.add(curToggle);
            if (i == toggles.size() - 1) continue;
            toolbar.addSeparator(new Dimension(3, 0));
        }
    }

    private JToggleButton createToggle(FiltersDescriptor filtersDesc, int index) {
        boolean isSelected = filtersDesc.isSelected(index);
        Icon icon = filtersDesc.getSelectedIcon(index);
        JToggleButton toggleButton = new JToggleButton(icon, isSelected);
        toggleButton.setMargin(new Insets(2, 2, 2, 2));
        toggleButton.setToolTipText(filtersDesc.getTooltip(index));
        toggleButton.setFocusable(false);
        filtersDesc.connectToggleButton(index, toggleButton);
        return toggleButton;
    }

    private void resumeThreadToFreeMonitor(DebuggingView.DVThread thread) {
        try {
            Method resumeToFreeMonitorMethod = thread.getClass().getMethod("resumeBlockingThreads", new Class[0]);
            resumeToFreeMonitorMethod.invoke((Object)thread, new Object[0]);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void initComponents() {
        this.stepBrkpInnerPanel = new JPanel();
        this.infoIcon3 = new JLabel();
        this.stepBrkpLabel = new JLabel();
        this.stepBrkpIgnoreButton = new JButton();
        this.debuggerDeadlocksInnerPanel = new JPanel();
        this.infoIcon2 = new JLabel();
        this.debuggerDeadlocksLabel = new JLabel();
        this.resumeDebuggerDeadlockLabel = new JLabel();
        this.emptyPanel2 = new JPanel();
        this.resumeDebuggerDeadlockButton = new JButton();
        this.deadlocksInnerPanel = new JPanel();
        this.infoIcon1 = new JLabel();
        this.deadlocksLabel = new JLabel();
        this.emptyPanel1 = new JPanel();
        this.hitsInnerPanel = new JPanel();
        this.infoIcon = new JLabel();
        this.hitsLabel = new JLabel();
        this.emptyPanel = new JPanel();
        this.setLayout(new BoxLayout(this, 3));
        this.stepBrkpInnerPanel.setOpaque(false);
        this.stepBrkpInnerPanel.setLayout(new GridBagLayout());
        this.infoIcon3.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/debugger/resources/debuggingView/info_big.png")));
        this.infoIcon3.setText(NbBundle.getMessage(InfoPanel.class, (String)"InfoPanel.infoIcon3.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.stepBrkpInnerPanel.add((Component)this.infoIcon3, gridBagConstraints);
        this.stepBrkpLabel.setText(NbBundle.getMessage(InfoPanel.class, (String)"InfoPanel.stepBrkpLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.stepBrkpInnerPanel.add((Component)this.stepBrkpLabel, gridBagConstraints);
        this.stepBrkpIgnoreButton.setText(NbBundle.getMessage(InfoPanel.class, (String)"InfoPanel.stepBrkpIgnoreButton.text"));
        this.stepBrkpIgnoreButton.setToolTipText(NbBundle.getMessage(InfoPanel.class, (String)"InfoPanel.stepBrkpIgnoreButton.tooltip"));
        this.stepBrkpIgnoreButton.setMargin(new Insets(0, 3, 0, 3));
        this.stepBrkpIgnoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InfoPanel.this.stepBrkpIgnoreButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.stepBrkpInnerPanel.add((Component)this.stepBrkpIgnoreButton, gridBagConstraints);
        this.add(this.stepBrkpInnerPanel);
        this.debuggerDeadlocksInnerPanel.setOpaque(false);
        this.debuggerDeadlocksInnerPanel.setPreferredSize(new Dimension(0, 16));
        this.debuggerDeadlocksInnerPanel.setLayout(new GridBagLayout());
        this.infoIcon2.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/debugger/resources/wrong_pass.png")));
        this.infoIcon2.setText(NbBundle.getMessage(InfoPanel.class, (String)"InfoPanel.infoIcon2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.debuggerDeadlocksInnerPanel.add((Component)this.infoIcon2, gridBagConstraints);
        this.debuggerDeadlocksLabel.setForeground(UIManager.getDefaults().getColor("nb.errorForeground"));
        this.debuggerDeadlocksLabel.setText(NbBundle.getMessage(InfoPanel.class, (String)"InfoPanel.debuggerDeadlocksLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 9);
        this.debuggerDeadlocksInnerPanel.add((Component)this.debuggerDeadlocksLabel, gridBagConstraints);
        this.resumeDebuggerDeadlockLabel.setText(NbBundle.getMessage(InfoPanel.class, (String)"InfoPanel.resumeDebuggerDeadlockLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.debuggerDeadlocksInnerPanel.add((Component)this.resumeDebuggerDeadlockLabel, gridBagConstraints);
        this.emptyPanel2.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.debuggerDeadlocksInnerPanel.add((Component)this.emptyPanel2, gridBagConstraints);
        this.resumeDebuggerDeadlockButton.setText(NbBundle.getMessage(InfoPanel.class, (String)"InfoPanel.resumeDebuggerDeadlockButton.text"));
        this.resumeDebuggerDeadlockButton.setMargin(new Insets(0, 3, 0, 3));
        this.resumeDebuggerDeadlockButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InfoPanel.this.resumeDebuggerDeadlockButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 2.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 9);
        this.debuggerDeadlocksInnerPanel.add((Component)this.resumeDebuggerDeadlockButton, gridBagConstraints);
        this.add(this.debuggerDeadlocksInnerPanel);
        this.deadlocksInnerPanel.setOpaque(false);
        this.deadlocksInnerPanel.setPreferredSize(new Dimension(0, 16));
        this.deadlocksInnerPanel.setLayout(new GridBagLayout());
        this.infoIcon1.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/debugger/resources/wrong_pass.png")));
        this.infoIcon1.setText(NbBundle.getMessage(InfoPanel.class, (String)"InfoPanel.infoIcon1.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.deadlocksInnerPanel.add((Component)this.infoIcon1, gridBagConstraints);
        this.deadlocksLabel.setForeground(UIManager.getDefaults().getColor("nb.errorForeground"));
        this.deadlocksLabel.setText(NbBundle.getMessage(InfoPanel.class, (String)"InfoPanel.deadlocksLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.deadlocksInnerPanel.add((Component)this.deadlocksLabel, gridBagConstraints);
        this.emptyPanel1.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.deadlocksInnerPanel.add((Component)this.emptyPanel1, gridBagConstraints);
        this.add(this.deadlocksInnerPanel);
        this.hitsInnerPanel.setOpaque(false);
        this.hitsInnerPanel.setLayout(new GridBagLayout());
        this.infoIcon.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/debugger/resources/debuggingView/info_big.png")));
        this.infoIcon.setText(NbBundle.getMessage(InfoPanel.class, (String)"InfoPanel.infoIcon.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 10, 0, 10);
        this.hitsInnerPanel.add((Component)this.infoIcon, gridBagConstraints);
        this.hitsLabel.setText(NbBundle.getMessage(InfoPanel.class, (String)"InfoPanel.hitsLabel.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.hitsInnerPanel.add((Component)this.hitsLabel, gridBagConstraints);
        this.emptyPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.hitsInnerPanel.add((Component)this.emptyPanel, gridBagConstraints);
        this.add(this.hitsInnerPanel);
    }

    private void resumeDebuggerDeadlockButtonActionPerformed(ActionEvent evt) {
        RequestProcessor rp;
        final DebuggingView.DVThread blockedThread = this.debuggerDeadlockThread;
        try {
            DebuggingView.DVSupport debugger = blockedThread.getDVSupport();
            rp = InfoPanel.getRP(debugger);
            if (rp == null) {
                return;
            }
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
            return;
        }
        rp.post(new Runnable(){

            @Override
            public void run() {
                blockedThread.resumeBlockingThreads();
            }
        });
        this.hideDebuggerDeadlockPanel();
    }

    private static RequestProcessor getRP(DebuggingView.DVSupport debugger) {
        Session s = debugger.getSession();
        RequestProcessor rp = (RequestProcessor)s.lookupFirst(null, RequestProcessor.class);
        if (rp == null) {
            rp = new RequestProcessor(InfoPanel.class);
        }
        return rp;
    }

    private void stepBrkpIgnoreButtonActionPerformed(ActionEvent evt) {
        DebuggingView.DVSupport ds;
        if (this.stepBrkpDVSupportRef != null && (ds = (DebuggingView.DVSupport)this.stepBrkpDVSupportRef.get()) != null) {
            RequestProcessor rp = InfoPanel.getRP(ds);
            if (rp == null) {
                return;
            }
            rp.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        ds.resume();
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }
    }

    private static class NoBorderToolBar
    extends JToolBar {
        public NoBorderToolBar() {
        }

        public NoBorderToolBar(int layout) {
            super(layout);
        }

        @Override
        protected void paintComponent(Graphics g) {
        }
    }

    public class Item {
        private Color backgroundColor;
        private int preferredHeight;
        private JPanel topGapPanel;
        private JPanel bottomGapPanel;
        private JPanel outerPanel;
        private JComponent innerPanel;
        private JScrollPane scrollPane;
        private JPanel separator;
        private boolean animationRunning = false;
        private boolean isTop = false;

        Item(Color backgroundColor, int preferredHeight, JComponent innerPanel) {
            this.backgroundColor = backgroundColor;
            this.preferredHeight = preferredHeight;
            this.innerPanel = innerPanel;
            this.topGapPanel = this.createGapPanel();
            this.bottomGapPanel = this.createGapPanel();
            this.separator = this.createSeparator();
            this.outerPanel = new JPanel();
            this.outerPanel.setBackground(backgroundColor);
            this.outerPanel.setLayout(new BorderLayout());
            this.outerPanel.add("North", this.topGapPanel);
            this.outerPanel.add("Center", innerPanel);
            this.outerPanel.add("South", this.bottomGapPanel);
            this.outerPanel.setPreferredSize(new Dimension(0, preferredHeight));
            this.scrollPane = new JScrollPane();
            this.scrollPane.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.scrollPane.setPreferredSize(new Dimension(0, preferredHeight));
            this.scrollPane.setVerticalScrollBarPolicy(21);
            this.scrollPane.setHorizontalScrollBarPolicy(31);
            this.scrollPane.setViewportView(this.outerPanel);
        }

        public JPanel getPanel() {
            return this.outerPanel;
        }

        public boolean isVisible() {
            return this.scrollPane.isVisible() || this.animationRunning;
        }

        private JPanel createGapPanel() {
            JPanel panel = new JPanel();
            panel.setOpaque(false);
            panel.setPreferredSize(new Dimension(0, InfoPanel.this.tapPanelMinimumHeight));
            return panel;
        }

        private JPanel createSeparator() {
            JPanel panel = new JPanel();
            panel.setBackground(UIManager.getDefaults().getColor("Separator.foreground"));
            panel.setMaximumSize(new Dimension(Short.MAX_VALUE, 1));
            panel.setMinimumSize(new Dimension(10, 1));
            panel.setPreferredSize(new Dimension(0, 1));
            return panel;
        }

        private synchronized void makeInvisible() {
            this.scrollPane.setVisible(false);
            this.separator.setVisible(false);
            if (this.animationRunning) {
                this.animationRunning = false;
            }
            this.setTop(this.isTop);
        }

        private synchronized void makeVisible(boolean animate, boolean top, Item lastTop) {
            int height;
            if (this.animationRunning) {
                return;
            }
            int n = height = top ? this.preferredHeight - InfoPanel.this.tapPanelMinimumHeight : this.preferredHeight;
            if (!animate) {
                this.setTop(top);
                if (top && lastTop != null) {
                    lastTop.setTop(false);
                }
                this.scrollPane.setPreferredSize(new Dimension(0, height));
                this.outerPanel.setPreferredSize(new Dimension(0, height));
                this.scrollPane.setVisible(true);
                this.separator.setVisible(true);
            } else {
                this.scrollPane.setPreferredSize(new Dimension(0, 1));
                this.outerPanel.setPreferredSize(new Dimension(0, height));
                this.animationRunning = true;
                this.isTop = top;
                if (this.isTop && lastTop != null) {
                    lastTop.setTop(false);
                }
                this.topGapPanel.setVisible(!this.isTop);
                if (this.animationRunning) {
                    this.scrollPane.setVisible(true);
                    this.separator.setVisible(true);
                    InfoPanel.this.tapPanel.revalidate();
                }
                if (this.isTop) {
                    InfoPanel.this.tapPanel.setBackground(this.backgroundColor);
                }
                int delta = 1;
                int currHeight = 1;
                Timer animationTimer = new Timer(20, null);
                animationTimer.addActionListener(new AnimationTimerListener(animationTimer, delta, currHeight));
                animationTimer.setCoalesce(false);
                animationTimer.start();
            }
        }

        private synchronized void setTop(boolean isTop) {
            this.isTop = isTop;
            if (isTop) {
                this.topGapPanel.setVisible(false);
                if (!this.animationRunning) {
                    this.outerPanel.setPreferredSize(new Dimension(0, this.preferredHeight - InfoPanel.this.tapPanelMinimumHeight));
                    this.scrollPane.setPreferredSize(new Dimension(0, this.preferredHeight - InfoPanel.this.tapPanelMinimumHeight));
                }
                InfoPanel.this.tapPanel.setBackground(this.backgroundColor);
            } else {
                this.topGapPanel.setVisible(true);
                this.outerPanel.setPreferredSize(new Dimension(0, this.preferredHeight));
                this.scrollPane.setPreferredSize(new Dimension(0, this.preferredHeight));
            }
        }

        private class AnimationTimerListener
        implements ActionListener {
            private int delta;
            private int currHeight;
            private Timer animationTimer;
            private long time = 0L;

            public AnimationTimerListener(Timer animationTimer, int delta, int currHeight) {
                this.delta = delta;
                this.currHeight = currHeight;
                this.animationTimer = animationTimer;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                int height;
                long now = System.nanoTime();
                int step = this.time > 0L ? this.delta * ((int)(now - this.time) / (this.animationTimer.getDelay() * 1000000) + 1) : this.delta;
                this.time = now;
                this.currHeight += step;
                int n = height = Item.this.isTop ? Item.this.preferredHeight - InfoPanel.this.tapPanelMinimumHeight : Item.this.preferredHeight;
                if (this.currHeight > height) {
                    this.currHeight = height;
                }
                Item.this.scrollPane.setPreferredSize(new Dimension(0, this.currHeight));
                InfoPanel.this.revalidate();
                InfoPanel.this.doLayout();
                if (this.currHeight >= (Item.this.isTop ? Item.this.preferredHeight - InfoPanel.this.tapPanelMinimumHeight : Item.this.preferredHeight)) {
                    this.animationTimer.stop();
                    Item item = Item.this;
                    synchronized (item) {
                        Item.this.animationRunning = false;
                    }
                }
            }
        }
    }

    private static class ToggleButtonActionListener
    implements ActionListener {
        private int index;

        public ToggleButtonActionListener(int index) {
            this.index = index;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JToggleButton curToggle = (JToggleButton)e.getSource();
            FiltersDescriptor.getInstance().setSelected(this.index, curToggle.isSelected());
        }
    }
}

