/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.vars.models;

import java.awt.Color;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JTable;
import javax.swing.UIManager;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.truffle.LanguageName;
import org.netbeans.modules.debugger.jpda.truffle.access.CurrentPCInfo;
import org.netbeans.modules.debugger.jpda.truffle.access.TruffleAccess;
import org.netbeans.modules.debugger.jpda.truffle.frames.TruffleStackFrame;
import org.netbeans.modules.debugger.jpda.truffle.vars.TruffleVariable;
import org.netbeans.modules.debugger.jpda.truffle.vars.impl.TruffleScope;
import org.netbeans.modules.debugger.jpda.truffle.vars.impl.TruffleVariableImpl;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableHTMLModel;
import org.netbeans.spi.viewmodel.TableHTMLModelFilter;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;

public class TruffleVariablesTableModel
implements TableModelFilter,
TableHTMLModelFilter {
    private final JPDADebugger debugger;
    private final List<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();

    public TruffleVariablesTableModel(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
    }

    private static TruffleVariable getTruffleVariable(Object node) {
        if (node instanceof Variable) {
            return TruffleVariableImpl.get((Variable)node);
        }
        if (node instanceof TruffleVariable) {
            return (TruffleVariable)node;
        }
        return null;
    }

    public Object getValueAt(TableModel original, Object node, String columnID) throws UnknownTypeException {
        if (node instanceof TruffleScope) {
            return "";
        }
        TruffleVariable tv = TruffleVariablesTableModel.getTruffleVariable(node);
        if (tv != null) {
            switch (columnID) {
                case "LocalsType": 
                case "WatchType": {
                    return tv.getType();
                }
                case "LocalsValue": 
                case "WatchValue": {
                    return tv.getValue();
                }
                case "LocalsToString": 
                case "WatchToString": {
                    Object var = tv.getValue();
                    return String.valueOf(var);
                }
            }
        }
        return original.getValueAt(node, columnID);
    }

    public boolean isReadOnly(TableModel original, Object node, String columnID) throws UnknownTypeException {
        if (node instanceof TruffleScope) {
            return true;
        }
        if (node instanceof TruffleVariable) {
            if ("LocalsValue".equals(columnID) || "WatchValue".equals(columnID)) {
                return !((TruffleVariable)node).isWritable();
            }
            return true;
        }
        return original.isReadOnly(node, columnID);
    }

    public void setValueAt(TableModel original, Object node, String columnID, Object value) throws UnknownTypeException {
        if (node instanceof TruffleVariable) {
            boolean success;
            boolean bl = success = ((TruffleVariable)node).setValue(this.debugger, value.toString()) != null;
            if (success) {
                ModelEvent.NodeChanged evt = new ModelEvent.NodeChanged((Object)this, node);
                for (ModelListener l : this.listeners) {
                    l.modelChanged((ModelEvent)evt);
                }
            }
        } else {
            original.setValueAt(node, columnID, value);
        }
    }

    public boolean hasHTMLValueAt(TableHTMLModel original, Object node, String columnID) throws UnknownTypeException {
        if (node instanceof TruffleVariable) {
            switch (columnID) {
                case "LocalsType": 
                case "WatchType": {
                    return true;
                }
            }
        }
        return original.hasHTMLValueAt(node, columnID);
    }

    public String getHTMLValueAt(TableHTMLModel original, Object node, String columnID) throws UnknownTypeException {
        switch (columnID) {
            case "LocalsType": 
            case "WatchType": {
                LanguageName valueLanguage;
                TruffleVariable tv = TruffleVariablesTableModel.getTruffleVariable(node);
                if (tv == null) break;
                LanguageName frameLanguage = LanguageName.NONE;
                CurrentPCInfo currentPCInfo = TruffleAccess.getCurrentPCInfo(this.debugger.getCurrentThread());
                if (currentPCInfo != null) {
                    TruffleStackFrame selectedStackFrame = currentPCInfo.getSelectedStackFrame();
                    frameLanguage = selectedStackFrame.getLanguage();
                }
                if (LanguageName.NONE.equals(valueLanguage = tv.getLanguage()) || frameLanguage.equals(valueLanguage)) break;
                return TruffleVariablesTableModel.toHTML(valueLanguage.getName(), tv.getType());
            }
        }
        return original.getHTMLValueAt(node, columnID);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    public static String toHTML(String id, String text) {
        if (text == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        Color color = UIManager.getColor("Table.foreground");
        if (color == null) {
            color = new JTable().getForeground();
        }
        sb.append("<font color=\"#");
        String hexColor = Integer.toHexString(color.getRGB() & 0xFFFFFF);
        for (int i = hexColor.length(); i < 6; ++i) {
            sb.append("0");
        }
        sb.append(hexColor);
        sb.append("\">");
        sb.append("<font color=\"#808080\">[");
        sb.append(id);
        sb.append("]</font> ");
        text = text.replaceAll("&", "&amp;");
        text = text.replaceAll("<", "&lt;");
        text = text.replaceAll(">", "&gt;");
        sb.append(text);
        sb.append("</font>");
        sb.append("</html>");
        return sb.toString();
    }
}

