/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.truffle.vars.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.netbeans.modules.debugger.jpda.truffle.access.CurrentPCInfo;
import org.netbeans.modules.debugger.jpda.truffle.access.TruffleAccess;
import org.netbeans.modules.debugger.jpda.truffle.frames.TruffleStackFrame;
import org.netbeans.modules.debugger.jpda.truffle.vars.TruffleVariable;
import org.netbeans.modules.debugger.jpda.truffle.vars.impl.TruffleScope;
import org.netbeans.modules.debugger.jpda.truffle.vars.models.TruffleVariablesTreeModel;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;

public class TruffleLocalVariablesTreeModel
extends TruffleVariablesTreeModel {
    private final WeakSet<CurrentPCInfo> cpisListening = new WeakSet();
    private final CurrentInfoPropertyChangeListener cpiChL = new CurrentInfoPropertyChangeListener();

    public TruffleLocalVariablesTreeModel(ContextProvider lookupProvider) {
        super(lookupProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] getChildren(TreeModel original, Object parent, int from, int to) throws UnknownTypeException {
        if (parent == original.getRoot()) {
            CurrentPCInfo currentPCInfo = TruffleAccess.getCurrentPCInfo(this.getDebugger().getCurrentThread());
            if (currentPCInfo != null) {
                WeakSet<CurrentPCInfo> weakSet = this.cpisListening;
                synchronized (weakSet) {
                    if (!this.cpisListening.contains((Object)currentPCInfo)) {
                        currentPCInfo.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.cpiChL, (Object)currentPCInfo));
                        this.cpisListening.add((Object)currentPCInfo);
                    }
                }
                TruffleStackFrame selectedStackFrame = currentPCInfo.getSelectedStackFrame();
                TruffleScope[] scopes = selectedStackFrame.getScopes();
                if (scopes.length == 0) {
                    return new Object[0];
                }
                Object[] innerMostVars = scopes[0].getVariables();
                if (scopes.length == 1) {
                    return innerMostVars;
                }
                Object[] varsAndScopes = new Object[innerMostVars.length + scopes.length - 1];
                System.arraycopy(innerMostVars, 0, varsAndScopes, 0, innerMostVars.length);
                System.arraycopy(scopes, 1, varsAndScopes, innerMostVars.length, scopes.length - 1);
                return varsAndScopes;
            }
        } else {
            if (parent instanceof TruffleScope) {
                TruffleScope scope = (TruffleScope)parent;
                return scope.getVariables();
            }
            if (parent instanceof TruffleVariable) {
                return ((TruffleVariable)parent).getChildren();
            }
        }
        return original.getChildren(parent, from, to);
    }

    private void fireVarsChanged() {
        ModelEvent.TreeChanged evt = new ModelEvent.TreeChanged((Object)this);
        for (ModelListener l : this.listeners) {
            l.modelChanged((ModelEvent)evt);
        }
    }

    private class CurrentInfoPropertyChangeListener
    implements PropertyChangeListener {
        private CurrentInfoPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            TruffleLocalVariablesTreeModel.this.fireVarsChanged();
        }
    }
}

