/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.DDFragmentDataObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.xml.sax.SAXException;

public class DDDataNode
extends DataNode {
    private DDDataObject dataObject;
    public static final String PROPERTY_DOCUMENT_TYPE = "documentType";
    private PropertyChangeListener ddListener;
    private static final Image ERROR_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/ddloaders/web/resources/error-badge.gif");
    private static final Image WEB_XML = ImageUtilities.loadImage((String)"org/netbeans/modules/j2ee/ddloaders/web/resources/DDDataIcon.gif");

    public DDDataNode(DDDataObject obj) {
        this(obj, Children.LEAF);
    }

    public DDDataNode(DDDataObject obj, Children ch) {
        super((DataObject)obj, ch);
        this.dataObject = obj;
        this.initListeners();
    }

    public Image getIcon(int type) {
        if (this.dataObject.getSaxError() == null) {
            return WEB_XML;
        }
        return ImageUtilities.mergeImages((Image)WEB_XML, (Image)ERROR_BADGE, (int)6, (int)6);
    }

    public String getShortDescription() {
        SAXException saxError = this.dataObject.getSaxError();
        if (saxError == null) {
            if (this.dataObject instanceof DDFragmentDataObject) {
                URL url = null;
                try {
                    url = this.dataObject.getPrimaryFile().getURL();
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
                return NbBundle.getBundle(DDDataNode.class).getString("HINT_web_fragment_dd") + (url != null ? " [" + url + "]" : "");
            }
            return NbBundle.getBundle(DDDataNode.class).getString("HINT_web_dd");
        }
        return saxError.getMessage();
    }

    void iconChanged() {
        this.fireIconChange();
    }

    private void initListeners() {
        this.ddListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                Object newValue = evt.getNewValue();
                Object oldValue = evt.getOldValue();
                if ("documentDTD".equals(propertyName)) {
                    DDDataNode.this.firePropertyChange(DDDataNode.PROPERTY_DOCUMENT_TYPE, oldValue, newValue);
                }
                if ("valid".equals(propertyName) && Boolean.TRUE.equals(newValue)) {
                    DDDataNode.this.removePropertyChangeListener(DDDataNode.this.ddListener);
                }
                if ("propertySets".equals(propertyName)) {
                    DDDataNode.this.firePropertySetsChange(null, null);
                }
                if ("sax_error".equals(propertyName)) {
                    DDDataNode.this.fireShortDescriptionChange((String)oldValue, (String)newValue);
                }
            }
        };
        this.getDataObject().addPropertyChangeListener(this.ddListener);
    }

    protected Sheet createSheet() {
        Sheet s = super.createSheet();
        Sheet.Set ss = s.get("properties");
        PropertySupport.ReadOnly p = new PropertySupport.ReadOnly(PROPERTY_DOCUMENT_TYPE, String.class, NbBundle.getBundle(DDDataNode.class).getString("PROP_documentDTD"), NbBundle.getBundle(DDDataNode.class).getString("HINT_documentDTD")){

            public Object getValue() {
                return DDDataNode.this.dataObject.getWebApp().getVersion();
            }
        };
        ss.put((Node.Property)p);
        s.put(ss);
        return s;
    }
}

