/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.array.dyn;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.array.ArrayAllocationSite;
import com.oracle.truffle.js.runtime.array.DynamicArray;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractConstantArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractDoubleArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractIntArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractJSObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.AbstractObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.ContiguousDoubleArray;
import com.oracle.truffle.js.runtime.array.dyn.ContiguousIntArray;
import com.oracle.truffle.js.runtime.array.dyn.ContiguousJSObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.ContiguousObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedDoubleArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedIntArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedJSObjectArray;
import com.oracle.truffle.js.runtime.array.dyn.ZeroBasedObjectArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSArray;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractConstantEmptyArray
extends AbstractConstantArray {
    protected AbstractConstantEmptyArray(int integrityLevel, DynamicArray.DynamicArrayCache cache) {
        super(integrityLevel, cache);
    }

    protected static void setCapacity(DynamicObject object, long length) {
        JSArray.arraySetLength(object, length);
    }

    protected static long getCapacity(DynamicObject object) {
        return JSArray.arrayGetLength(object);
    }

    protected static long getCapacity(DynamicObject object, boolean condition) {
        return JSArray.arrayGetLength(object, condition);
    }

    @Override
    public Object getElementInBounds(DynamicObject object, int index, boolean condition) {
        return Undefined.instance;
    }

    @Override
    public int lengthInt(DynamicObject object, boolean condition) {
        return (int)AbstractConstantEmptyArray.getCapacity(object, condition);
    }

    @Override
    public Object[] toArray(DynamicObject object) {
        int cap = (int)AbstractConstantEmptyArray.getCapacity(object);
        Object[] arr = new Object[cap];
        Arrays.fill(arr, Undefined.instance);
        return arr;
    }

    @Override
    public boolean hasElement(DynamicObject object, long index, boolean condition) {
        return false;
    }

    @Override
    public ScriptArray deleteElementImpl(DynamicObject object, long index, boolean strict, boolean condition) {
        return this;
    }

    @Override
    public long firstElementIndex(DynamicObject object, boolean condition) {
        return 0L;
    }

    @Override
    public long lastElementIndex(DynamicObject object, boolean condition) {
        return -1L;
    }

    @Override
    public long nextElementIndex(DynamicObject object, long index, boolean condition) {
        return JSRuntime.MAX_SAFE_INTEGER_LONG;
    }

    @Override
    public long previousElementIndex(DynamicObject object, long index, boolean condition) {
        return -1L;
    }

    @Override
    public AbstractIntArray createWriteableInt(DynamicObject object, long index, int value, boolean condition, ScriptArray.ProfileHolder profile) {
        assert (index >= 0L);
        int capacity = this.lengthInt(object, condition);
        int[] initialArray = new int[AbstractConstantEmptyArray.calcNewArraySize(capacity, profile)];
        AbstractIntArray newArray = CREATE_WRITABLE_PROFILE.indexZero(profile, index == 0L) ? ZeroBasedIntArray.makeZeroBasedIntArray(object, capacity, 0, initialArray, this.integrityLevel) : this.createWritableIntContiguous(object, capacity, index, initialArray, profile);
        if (JSConfig.TraceArrayTransitions) {
            AbstractConstantEmptyArray.traceArrayTransition(this, newArray, index, value);
        }
        this.notifyAllocationSite(object, newArray);
        return newArray;
    }

    private AbstractIntArray createWritableIntContiguous(DynamicObject object, int capacity, long index, int[] initialArray, ScriptArray.ProfileHolder profile) {
        long length = Math.max(index + 1L, (long)capacity);
        int arrayOffset = 0;
        long indexOffset = index;
        if (CREATE_WRITABLE_PROFILE.indexLessThanLength(profile, index < (long)initialArray.length)) {
            arrayOffset = (int)index;
            indexOffset = 0L;
        }
        return ContiguousIntArray.makeContiguousIntArray(object, length, initialArray, indexOffset, arrayOffset, 0, this.integrityLevel);
    }

    private static int calcNewArraySize(int capacity, ScriptArray.ProfileHolder profile) {
        if (CREATE_WRITABLE_PROFILE.lengthZero(profile, capacity == 0)) {
            return 8;
        }
        if (CREATE_WRITABLE_PROFILE.lengthBelowLimit(profile, capacity < 1000000)) {
            return capacity;
        }
        return 8;
    }

    @Override
    public AbstractDoubleArray createWriteableDouble(DynamicObject object, long index, double value, boolean condition, ScriptArray.ProfileHolder profile) {
        int capacity = this.lengthInt(object, condition);
        double[] initialArray = new double[AbstractConstantEmptyArray.calcNewArraySize(capacity, profile)];
        AbstractDoubleArray newArray = CREATE_WRITABLE_PROFILE.indexZero(profile, index == 0L) ? ZeroBasedDoubleArray.makeZeroBasedDoubleArray(object, capacity, 0, initialArray, this.integrityLevel) : this.createWritableDoubleContiguous(object, capacity, index, initialArray, profile);
        if (JSConfig.TraceArrayTransitions) {
            AbstractConstantEmptyArray.traceArrayTransition(this, newArray, index, value);
        }
        this.notifyAllocationSite(object, newArray);
        return newArray;
    }

    private AbstractDoubleArray createWritableDoubleContiguous(DynamicObject object, int capacity, long index, double[] initialArray, ScriptArray.ProfileHolder profile) {
        long length = Math.max(index + 1L, (long)capacity);
        int arrayOffset = 0;
        long indexOffset = index;
        if (CREATE_WRITABLE_PROFILE.indexLessThanLength(profile, index < (long)initialArray.length)) {
            arrayOffset = (int)index;
            indexOffset = 0L;
        }
        return ContiguousDoubleArray.makeContiguousDoubleArray(object, length, initialArray, indexOffset, arrayOffset, 0, this.integrityLevel);
    }

    @Override
    public AbstractJSObjectArray createWriteableJSObject(DynamicObject object, long index, DynamicObject value, boolean condition, ScriptArray.ProfileHolder profile) {
        int capacity = this.lengthInt(object, condition);
        DynamicObject[] initialArray = new DynamicObject[AbstractConstantEmptyArray.calcNewArraySize(capacity, profile)];
        AbstractJSObjectArray newArray = CREATE_WRITABLE_PROFILE.indexZero(profile, index == 0L) ? ZeroBasedJSObjectArray.makeZeroBasedJSObjectArray(object, capacity, 0, initialArray, this.integrityLevel) : this.createWritableJSObjectContiguous(object, capacity, index, initialArray, profile);
        if (JSConfig.TraceArrayTransitions) {
            AbstractConstantEmptyArray.traceArrayTransition(this, newArray, index, value);
        }
        this.notifyAllocationSite(object, newArray);
        return newArray;
    }

    private AbstractJSObjectArray createWritableJSObjectContiguous(DynamicObject object, int capacity, long index, DynamicObject[] initialArray, ScriptArray.ProfileHolder profile) {
        long length = Math.max(index + 1L, (long)capacity);
        int arrayOffset = 0;
        long indexOffset = index;
        if (CREATE_WRITABLE_PROFILE.indexLessThanLength(profile, index < (long)initialArray.length)) {
            arrayOffset = (int)index;
            indexOffset = 0L;
        }
        return ContiguousJSObjectArray.makeContiguousJSObjectArray(object, length, initialArray, indexOffset, arrayOffset, 0, this.integrityLevel);
    }

    @Override
    public AbstractObjectArray createWriteableObject(DynamicObject object, long index, Object value, boolean condition, ScriptArray.ProfileHolder profile) {
        int capacity = this.lengthInt(object, condition);
        Object[] initialArray = new Object[AbstractConstantEmptyArray.calcNewArraySize(capacity, profile)];
        AbstractObjectArray newArray = CREATE_WRITABLE_PROFILE.indexZero(profile, index == 0L) ? ZeroBasedObjectArray.makeZeroBasedObjectArray(object, capacity, 0, initialArray, this.integrityLevel) : this.createWritableObjectContiguous(object, capacity, index, initialArray, profile);
        if (JSConfig.TraceArrayTransitions) {
            AbstractConstantEmptyArray.traceArrayTransition(this, newArray, index, value);
        }
        this.notifyAllocationSite(object, newArray);
        return newArray;
    }

    private AbstractObjectArray createWritableObjectContiguous(DynamicObject object, int capacity, long index, Object[] initialArray, ScriptArray.ProfileHolder profile) {
        long length = Math.max(index + 1L, (long)capacity);
        int arrayOffset = 0;
        long indexOffset = index;
        if (CREATE_WRITABLE_PROFILE.indexLessThanLength(profile, index < (long)initialArray.length)) {
            arrayOffset = (int)index;
            indexOffset = 0L;
        }
        return ContiguousObjectArray.makeContiguousObjectArray(object, length, initialArray, indexOffset, arrayOffset, 0, this.integrityLevel);
    }

    @Override
    public boolean isHolesType() {
        return true;
    }

    @Override
    public boolean hasHoles(DynamicObject object, boolean condition) {
        return AbstractConstantEmptyArray.getCapacity(object, condition) != 0L;
    }

    @Override
    public List<Object> ownPropertyKeys(DynamicObject object) {
        return this.ownPropertyKeysContiguous(object);
    }

    private void notifyAllocationSite(DynamicObject object, ScriptArray newArray) {
        ArrayAllocationSite site;
        if (JSConfig.TrackArrayAllocationSites && CompilerDirectives.inInterpreter() && (site = JSAbstractArray.arrayGetAllocationSite(object)) != null) {
            site.notifyArrayTransition(newArray, this.lengthInt(object));
        }
    }
}

