/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phpdoc.ui;

import java.util.prefs.Preferences;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.phpdoc.ui.BrowseFolderPanel;

public final class PhpDocPreferences {
    private static final String PHPDOC_ENABLED = "enabled";
    private static final String PHPDOC_TARGET = "target";
    private static final String PHPDOC_TITLE = "title";

    private PhpDocPreferences() {
    }

    public static boolean isEnabled(PhpModule phpModule) {
        return PhpDocPreferences.getPreferences(phpModule).getBoolean(PHPDOC_ENABLED, false);
    }

    public static void setEnabled(PhpModule phpModule, boolean enabled) {
        PhpDocPreferences.getPreferences(phpModule).putBoolean(PHPDOC_ENABLED, enabled);
    }

    public static String getPhpDocTarget(PhpModule phpModule, boolean showPanel) {
        Preferences preferences = PhpDocPreferences.getPreferences(phpModule);
        String phpDocTarget = preferences.get(PHPDOC_TARGET, null);
        if ((phpDocTarget == null || phpDocTarget.isEmpty()) && showPanel) {
            phpDocTarget = BrowseFolderPanel.open(phpModule);
            if (phpDocTarget == null) {
                return null;
            }
            PhpDocPreferences.setPhpDocTarget(phpModule, phpDocTarget);
        }
        return phpDocTarget;
    }

    public static void setPhpDocTarget(PhpModule phpModule, String phpDocTarget) {
        PhpDocPreferences.getPreferences(phpModule).put(PHPDOC_TARGET, phpDocTarget);
    }

    public static String getPhpDocTitle(PhpModule phpModule) {
        return PhpDocPreferences.getPreferences(phpModule).get(PHPDOC_TITLE, PhpDocPreferences.getDefaultPhpDocTitle(phpModule));
    }

    public static void setPhpDocTitle(PhpModule phpModule, String phpDocTitle) {
        if (phpDocTitle.equals(PhpDocPreferences.getDefaultPhpDocTitle(phpModule))) {
            return;
        }
        PhpDocPreferences.getPreferences(phpModule).put(PHPDOC_TITLE, phpDocTitle);
    }

    private static Preferences getPreferences(PhpModule phpModule) {
        return phpModule.getPreferences(PhpDocPreferences.class, false);
    }

    private static String getDefaultPhpDocTitle(PhpModule phpModule) {
        return phpModule.getDisplayName();
    }
}

