/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import com.google.common.collect.Lists;
import java.util.Collections;
import org.glassfish.jersey.server.ContainerRequest;

public interface Router {
    public Continuation apply(ContainerRequest var1);

    public static interface Builder {
        public Builder child(Router var1);

        public Router build();
    }

    public static final class Continuation {
        private final ContainerRequest request;
        private final Iterable<Router> next;

        public static Continuation of(ContainerRequest result) {
            return new Continuation(result, null);
        }

        public static Continuation of(ContainerRequest result, Iterable<Router> next) {
            return new Continuation(result, next);
        }

        public static Continuation of(ContainerRequest request, Router next) {
            return new Continuation(request, Lists.newArrayList((Object[])new Router[]{next}));
        }

        private Continuation(ContainerRequest request, Iterable<Router> next) {
            this.request = request;
            this.next = next == null ? Collections.emptyList() : next;
        }

        public ContainerRequest requestContext() {
            return this.request;
        }

        public Iterable<Router> next() {
            return this.next;
        }

        public boolean hasNext() {
            return this.next.iterator().hasNext();
        }
    }
}

