/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.singlesourcefile;

import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;

class SingleSourceFileUtil {
    public static final String FILE_ARGUMENTS = "single_file_run_arguments";
    public static final String FILE_VM_OPTIONS = "single_file_vm_options";

    SingleSourceFileUtil() {
    }

    static FileObject getJavaFileWithoutProjectFromLookup(Lookup lookup) {
        for (DataObject dObj : lookup.lookupAll(DataObject.class)) {
            FileObject fObj = dObj.getPrimaryFile();
            if (!SingleSourceFileUtil.isSingleSourceFile(fObj)) continue;
            return fObj;
        }
        return null;
    }

    static boolean isSingleSourceFile(FileObject fObj) {
        int version;
        Project p = FileOwnerQuery.getOwner((FileObject)fObj);
        if (p != null || !fObj.getExt().equalsIgnoreCase("java")) {
            return false;
        }
        String javaVersion = System.getProperty("java.specification.version");
        if (javaVersion.startsWith("1.")) {
            javaVersion = javaVersion.substring(2);
        }
        return (version = Integer.parseInt(javaVersion)) >= 11;
    }
}

