/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cpplite.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.modules.cpplite.debugger.DebuggerBreakpointAnnotation;
import org.netbeans.modules.cpplite.debugger.breakpoints.CPPLiteBreakpoint;

public class BreakpointAnnotationListener
extends DebuggerManagerAdapter
implements PropertyChangeListener {
    private Map breakpointToAnnotation = new HashMap();

    public String[] getProperties() {
        return new String[]{"breakpoints"};
    }

    public void breakpointAdded(Breakpoint b) {
        if (!(b instanceof CPPLiteBreakpoint)) {
            return;
        }
        this.addAnnotation((CPPLiteBreakpoint)b);
    }

    public void breakpointRemoved(Breakpoint b) {
        if (!(b instanceof CPPLiteBreakpoint)) {
            return;
        }
        this.removeAnnotation(b);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() != "enabled") {
            return;
        }
        this.removeAnnotation((Breakpoint)evt.getSource());
        this.addAnnotation((CPPLiteBreakpoint)((Object)evt.getSource()));
    }

    private void addAnnotation(CPPLiteBreakpoint b) {
        this.breakpointToAnnotation.put(b, new DebuggerBreakpointAnnotation(b.isEnabled() ? "Breakpoint" : "DisabledBreakpoint", b));
        b.addPropertyChangeListener("enabled", this);
    }

    private void removeAnnotation(Breakpoint b) {
        DebuggerBreakpointAnnotation annotation = (DebuggerBreakpointAnnotation)((Object)this.breakpointToAnnotation.remove(b));
        if (annotation == null) {
            return;
        }
        annotation.detach();
        b.removePropertyChangeListener("enabled", (PropertyChangeListener)this);
    }
}

