/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.options;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.debugger.jpda.expr.formatters.VariablesFormatter;
import org.netbeans.modules.debugger.jpda.ui.options.CategoryPanelFormatters;
import org.netbeans.modules.debugger.jpda.ui.options.DisablingCellRenderer;
import org.openide.DialogDescriptor;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class VariableFormatterEditPanel
extends JPanel {
    private JButton addVarButton;
    private ButtonGroup childrenButtonGroup;
    private JEditorPane childrenCodeEditorPane;
    private JRadioButton childrenCodeRadioButton;
    private JScrollPane childrenCodeScrollPane;
    private JCheckBox childrenFormatCheckBox;
    private JRadioButton childrenVariablesRadioButton;
    private JTable childrenVariablesTable;
    private JLabel classTypesLabel;
    private JTextField classTypesTextField;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JButton moveDownVarButton;
    private JButton moveUpVarButton;
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JButton removeVarButton;
    private JCheckBox subtypesCheckBox;
    private JCheckBox testChildrenCheckBox;
    private JEditorPane testChildrenEditorPane;
    private JScrollPane testChildrenScrollPane;
    private JEditorPane valueEditorPane;
    private JCheckBox valueFormatCheckBox;
    private JScrollPane valueScrollPane;
    private final String[] tableColumnNames = new String[]{NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.formatChildrenListTable.Name"), NbBundle.getMessage(CategoryPanelFormatters.class, (String)"CategoryPanelFormatters.formatChildrenListTable.Value")};
    private Set<String> formatterNames;
    private DialogDescriptor validityDescriptor;
    private NotificationLineSupport validityNotificationSupport;
    private boolean continualValidityChecks = false;

    public VariableFormatterEditPanel() {
        this.initComponents();
        this.initChildrenVariablesTable();
    }

    public void load(VariablesFormatter f) {
        this.nameTextField.setText(f.getName());
        this.classTypesTextField.setText(f.getClassTypesCommaSeparated());
        this.subtypesCheckBox.setSelected(f.isIncludeSubTypes());
        this.valueFormatCheckBox.setSelected(f.getValueFormatCode().trim().length() > 0);
        this.valueEditorPane.setText(f.getValueFormatCode());
        this.childrenFormatCheckBox.setSelected(f.getChildrenFormatCode().trim().length() > 0 || f.getChildrenVariables().size() > 0);
        this.childrenCodeEditorPane.setText(f.getChildrenFormatCode());
        Map childrenVariables = f.getChildrenVariables();
        int n = childrenVariables.size();
        Iterator childrenVariablesEntries = childrenVariables.entrySet().iterator();
        Object[][] tableData = new String[n][2];
        for (int i = 0; i < n; ++i) {
            Map.Entry e = childrenVariablesEntries.next();
            tableData[i][0] = (String)e.getKey();
            tableData[i][1] = (String)e.getValue();
        }
        DefaultTableModel childrenVarsModel = new DefaultTableModel(tableData, this.tableColumnNames){

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return String.class;
            }
        };
        this.childrenVariablesTable.setModel(childrenVarsModel);
        DisablingCellRenderer.apply(this.childrenVariablesTable);
        this.childrenCodeRadioButton.setSelected(!f.isUseChildrenVariables());
        this.childrenVariablesRadioButton.setSelected(f.isUseChildrenVariables());
        this.testChildrenCheckBox.setSelected(f.getChildrenExpandTestCode().trim().length() > 0);
        this.testChildrenEditorPane.setText(f.getChildrenExpandTestCode());
        this.valueFormatCheckBoxActionPerformed(null);
        this.childrenFormatCheckBoxActionPerformed(null);
        this.nameTextField.requestFocusInWindow();
    }

    public void store(VariablesFormatter f) {
        f.setName(this.nameTextField.getText());
        f.setClassTypes(this.classTypesTextField.getText());
        f.setIncludeSubTypes(this.subtypesCheckBox.isSelected());
        f.setValueFormatCode(this.valueFormatCheckBox.isSelected() ? this.valueEditorPane.getText() : "");
        f.setChildrenFormatCode(this.childrenCodeEditorPane.getText());
        TableModel tableModel = this.childrenVariablesTable.getModel();
        f.getChildrenVariables().clear();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            f.addChildrenVariable((String)tableModel.getValueAt(i, 0), (String)tableModel.getValueAt(i, 1));
        }
        f.setUseChildrenVariables(this.childrenVariablesRadioButton.isSelected());
        f.setChildrenExpandTestCode(this.testChildrenCheckBox.isSelected() ? this.testChildrenEditorPane.getText() : "");
    }

    void setFormatterNames(Set<String> formatterNames) {
        this.formatterNames = formatterNames;
    }

    void setValidityObjects(DialogDescriptor validityDescriptor, NotificationLineSupport validityNotificationSupport, boolean continualValidityChecks) {
        this.validityDescriptor = validityDescriptor;
        this.validityNotificationSupport = validityNotificationSupport;
        this.continualValidityChecks = continualValidityChecks;
        this.attachValidityChecks();
    }

    private void attachValidityChecks() {
        DocumentListener validityDocumentListener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                VariableFormatterEditPanel.this.checkValid();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                VariableFormatterEditPanel.this.checkValid();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                VariableFormatterEditPanel.this.checkValid();
            }
        };
        this.nameTextField.getDocument().addDocumentListener(validityDocumentListener);
        this.classTypesTextField.getDocument().addDocumentListener(validityDocumentListener);
        this.checkValid();
    }

    private boolean checkValidName() {
        String name = this.nameTextField.getText().trim();
        if (name.length() == 0) {
            this.validityDescriptor.setValid(false);
            this.validityNotificationSupport.setErrorMessage(NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"MSG_EmptyFormatterName"));
            return false;
        }
        if (this.formatterNames.contains(name)) {
            this.validityDescriptor.setValid(false);
            this.validityNotificationSupport.setErrorMessage(NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"MSG_ExistingFormatterName"));
            return false;
        }
        return true;
    }

    private boolean checkValidClasses() {
        String name = this.classTypesTextField.getText().trim();
        if (name.length() == 0) {
            this.validityDescriptor.setValid(false);
            this.validityNotificationSupport.setErrorMessage(NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"MSG_EmptyClassName"));
            return false;
        }
        int i = 0;
        char c = name.charAt(i);
        if (Character.isJavaIdentifierStart(c)) {
            boolean start = true;
            ++i;
            while (i < name.length()) {
                c = name.charAt(i);
                if (c == ',' || Character.isWhitespace(c)) {
                    start = true;
                } else {
                    if (start && !Character.isJavaIdentifierStart(c) || !start && !Character.isJavaIdentifierPart(c) && c != '.') break;
                    start = false;
                }
                ++i;
            }
        }
        if (i < name.length()) {
            this.validityDescriptor.setValid(false);
            this.validityNotificationSupport.setErrorMessage(NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"MSG_InvalidClassNameAtPos", (Object)(i + 1)));
            return false;
        }
        return true;
    }

    private void checkFormatterSelected() {
        boolean is;
        boolean bl = is = this.valueFormatCheckBox.isSelected() || this.childrenFormatCheckBox.isSelected();
        if (is) {
            this.validityDescriptor.setValid(true);
            this.validityNotificationSupport.clearMessages();
        } else {
            this.validityDescriptor.setValid(false);
            this.validityNotificationSupport.setErrorMessage(NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"MSG_NoFormatSelected"));
        }
    }

    private void checkValid() {
        if (this.validityNotificationSupport == null || !this.continualValidityChecks) {
            return;
        }
        if (this.checkValidName() && this.checkValidClasses()) {
            this.checkFormatterSelected();
        }
    }

    public boolean checkValidInput() {
        this.continualValidityChecks = true;
        this.checkValid();
        if (!this.validityDescriptor.isValid()) {
            if (!this.checkValidName()) {
                this.nameTextField.requestFocusInWindow();
            } else if (!this.checkValidClasses()) {
                this.classTypesTextField.requestFocusInWindow();
            } else {
                this.valueFormatCheckBox.requestFocusInWindow();
            }
            return false;
        }
        return true;
    }

    static Color getDisabledFieldBackground() {
        JTextField disabledField = new JTextField();
        disabledField.setEditable(false);
        disabledField.setEnabled(false);
        return disabledField.getBackground();
    }

    private void initComponents() {
        this.childrenButtonGroup = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.nameLabel = new JLabel();
        this.nameTextField = new JTextField();
        this.classTypesLabel = new JLabel();
        this.classTypesTextField = new JTextField();
        this.subtypesCheckBox = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.valueFormatCheckBox = new JCheckBox();
        this.valueScrollPane = new JScrollPane();
        this.valueEditorPane = new JEditorPane();
        this.childrenFormatCheckBox = new JCheckBox();
        this.childrenCodeRadioButton = new JRadioButton();
        this.childrenCodeScrollPane = new JScrollPane();
        this.childrenCodeEditorPane = new JEditorPane();
        this.childrenVariablesRadioButton = new JRadioButton();
        this.jScrollPane1 = new JScrollPane();
        this.childrenVariablesTable = new JTable();
        this.jPanel3 = new JPanel();
        this.addVarButton = new JButton();
        this.removeVarButton = new JButton();
        this.moveUpVarButton = new JButton();
        this.moveDownVarButton = new JButton();
        this.testChildrenCheckBox = new JCheckBox();
        this.testChildrenScrollPane = new JScrollPane();
        this.testChildrenEditorPane = new JEditorPane();
        this.nameLabel.setLabelFor(this.nameTextField);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.nameLabel.text"));
        this.nameTextField.setText(NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.nameTextField.text"));
        this.classTypesLabel.setLabelFor(this.classTypesTextField);
        Mnemonics.setLocalizedText((JLabel)this.classTypesLabel, (String)NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.classTypesLabel.text"));
        this.classTypesTextField.setText(NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.classTypesTextField.text"));
        this.classTypesTextField.setToolTipText(NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.classTypesLabel.tooltip"));
        this.subtypesCheckBox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.subtypesCheckBox, (String)NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.subtypesCheckBox.text"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.classTypesLabel).addComponent(this.nameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.classTypesTextField, -1, 286, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.subtypesCheckBox)).addComponent(this.nameTextField, -1, 449, Short.MAX_VALUE))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.classTypesLabel).addComponent(this.classTypesTextField, -2, -1, -2).addComponent(this.subtypesCheckBox)).addContainerGap(-1, Short.MAX_VALUE)));
        this.nameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.nameLabel.AccessibleContext.accessibleDescription"));
        this.classTypesLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.classTypesLabel.AccessibleContext.accessibleDescription"));
        this.subtypesCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.subtypesCheckBox.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.valueFormatCheckBox, (String)NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.valueFormatCheckBox.text"));
        this.valueFormatCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VariableFormatterEditPanel.this.valueFormatCheckBoxActionPerformed(evt);
            }
        });
        this.valueScrollPane.setViewportView(this.valueEditorPane);
        Mnemonics.setLocalizedText((AbstractButton)this.childrenFormatCheckBox, (String)NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.childrenFormatCheckBox.text"));
        this.childrenFormatCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VariableFormatterEditPanel.this.childrenFormatCheckBoxActionPerformed(evt);
            }
        });
        this.childrenButtonGroup.add(this.childrenCodeRadioButton);
        this.childrenCodeRadioButton.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.childrenCodeRadioButton, (String)NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.childrenCodeRadioButton.text"));
        this.childrenCodeRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VariableFormatterEditPanel.this.childrenCodeRadioButtonActionPerformed(evt);
            }
        });
        this.childrenCodeScrollPane.setViewportView(this.childrenCodeEditorPane);
        this.childrenButtonGroup.add(this.childrenVariablesRadioButton);
        Mnemonics.setLocalizedText((AbstractButton)this.childrenVariablesRadioButton, (String)NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.childrenVariablesRadioButton.text"));
        this.childrenVariablesRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VariableFormatterEditPanel.this.childrenVariablesRadioButtonActionPerformed(evt);
            }
        });
        this.childrenVariablesTable.setModel(new DefaultTableModel(new Object[][]{{null, null}, {null, null}}, new String[]{"Name", "Value"}){
            Class[] types;
            {
                this.types = new Class[]{String.class, String.class};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView(this.childrenVariablesTable);
        this.childrenVariablesTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.childrenVariablesTable.a11y.name"));
        this.childrenVariablesTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.childrenVariablesTable.a11y.description"));
        Mnemonics.setLocalizedText((AbstractButton)this.addVarButton, (String)NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.addVarButton.text"));
        this.addVarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VariableFormatterEditPanel.this.addVarButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.removeVarButton, (String)NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.removeVarButton.text"));
        this.removeVarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VariableFormatterEditPanel.this.removeVarButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.moveUpVarButton, (String)NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.moveUpVarButton.text"));
        this.moveUpVarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VariableFormatterEditPanel.this.moveUpVarButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.moveDownVarButton, (String)NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.moveDownVarButton.text"));
        this.moveDownVarButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VariableFormatterEditPanel.this.moveDownVarButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.addVarButton, GroupLayout.Alignment.TRAILING).addComponent(this.removeVarButton).addComponent(this.moveUpVarButton).addComponent(this.moveDownVarButton));
        jPanel3Layout.linkSize(0, this.addVarButton, this.moveDownVarButton, this.moveUpVarButton, this.removeVarButton);
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.addVarButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeVarButton).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.moveUpVarButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.moveDownVarButton)));
        this.addVarButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.addVarButton.AccessibleContext.accessibleDescription"));
        this.removeVarButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.removeVarButton.AccessibleContext.accessibleDescription"));
        this.moveUpVarButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.moveUpVarButton.AccessibleContext.accessibleDescription"));
        this.moveDownVarButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.moveDownVarButton.AccessibleContext.accessibleDescription"));
        Mnemonics.setLocalizedText((AbstractButton)this.testChildrenCheckBox, (String)NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.testChildrenCheckBox.text"));
        this.testChildrenCheckBox.setToolTipText(NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.testChildrenCheckBox.tooltip"));
        this.testChildrenCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VariableFormatterEditPanel.this.testChildrenCheckBoxActionPerformed(evt);
            }
        });
        this.testChildrenScrollPane.setHorizontalScrollBarPolicy(31);
        this.testChildrenScrollPane.setVerticalScrollBarPolicy(21);
        this.testChildrenScrollPane.setViewportView(this.testChildrenEditorPane);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.valueFormatCheckBox).addContainerGap(235, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.valueScrollPane)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.childrenFormatCheckBox).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGap(42, 42, 42).addComponent(this.jScrollPane1, -1, 421, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, -1, -2).addGap(0, 0, 0)).addGroup(jPanel2Layout.createSequentialGroup().addGap(21, 21, 21).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.testChildrenScrollPane)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.testChildrenCheckBox).addContainerGap()).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.childrenVariablesRadioButton).addContainerGap()).addGroup(jPanel2Layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.childrenCodeScrollPane)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.childrenCodeRadioButton).addContainerGap()))));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.valueFormatCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.valueScrollPane, -1, 46, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.childrenFormatCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.childrenCodeRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.childrenCodeScrollPane, -1, 46, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.childrenVariablesRadioButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane1, 0, 0, Short.MAX_VALUE).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.testChildrenCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.testChildrenScrollPane, -2, -1, -2).addGap(0, 0, 0)));
        this.valueFormatCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.valueFormatCheckBox.AccessibleContext.accessibleDescription"));
        this.childrenFormatCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.childrenFormatCheckBox.AccessibleContext.accessibleDescription"));
        this.childrenCodeRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.childrenCodeRadioButton.AccessibleContext.accessibleDescription"));
        this.childrenVariablesRadioButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(VariableFormatterEditPanel.class, (String)"VariableFormatterEditPanel.childrenVariablesRadioButton.AccessibleContext.accessibleDescription"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void addVarButtonActionPerformed(ActionEvent evt) {
        final DefaultTableModel model = (DefaultTableModel)this.childrenVariablesTable.getModel();
        model.addRow(new Object[]{"", ""});
        final int index = model.getRowCount() - 1;
        this.childrenVariablesTable.getSelectionModel().setSelectionInterval(index, index);
        this.childrenVariablesTable.editCellAt(index, 0);
        this.childrenVariablesTable.requestFocus();
        this.childrenVariablesTable.getCellEditor(index, 0).shouldSelectCell(new ListSelectionEvent(this.childrenVariablesTable, index, index, true));
        this.addVarButton.setEnabled(false);
        this.removeVarButton.setEnabled(false);
        this.childrenVariablesTable.getCellEditor(index, 0).addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String value = (String)model.getValueAt(index, 0);
                        if (value.trim().length() == 0) {
                            model.removeRow(index);
                        }
                    }
                });
                VariableFormatterEditPanel.this.childrenVariablesTable.getCellEditor(index, 0).removeCellEditorListener(this);
                VariableFormatterEditPanel.this.addVarButton.setEnabled(true);
                VariableFormatterEditPanel.this.removeVarButton.setEnabled(VariableFormatterEditPanel.this.childrenVariablesTable.getSelectedRow() >= 0);
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                model.removeRow(index);
                VariableFormatterEditPanel.this.childrenVariablesTable.getCellEditor(index, 0).removeCellEditorListener(this);
                VariableFormatterEditPanel.this.addVarButton.setEnabled(true);
                VariableFormatterEditPanel.this.removeVarButton.setEnabled(VariableFormatterEditPanel.this.childrenVariablesTable.getSelectedRow() >= 0);
            }
        });
    }

    private void removeVarButtonActionPerformed(ActionEvent evt) {
        int index = this.childrenVariablesTable.getSelectedRow();
        if (index < 0) {
            return;
        }
        DefaultTableModel model = (DefaultTableModel)this.childrenVariablesTable.getModel();
        model.removeRow(index);
        if (index < this.childrenVariablesTable.getRowCount() || --index >= 0) {
            this.childrenVariablesTable.setRowSelectionInterval(index, index);
        }
    }

    private void moveUpVarButtonActionPerformed(ActionEvent evt) {
        int index = this.childrenVariablesTable.getSelectedRow();
        if (index <= 0) {
            return;
        }
        DefaultTableModel model = (DefaultTableModel)this.childrenVariablesTable.getModel();
        Object[] row = new Object[]{model.getValueAt(index, 0), model.getValueAt(index, 1)};
        model.removeRow(index);
        model.insertRow(index - 1, row);
        this.childrenVariablesTable.getSelectionModel().setSelectionInterval(index - 1, index - 1);
    }

    private void moveDownVarButtonActionPerformed(ActionEvent evt) {
        int index = this.childrenVariablesTable.getSelectedRow();
        if (index < 0) {
            return;
        }
        DefaultTableModel model = (DefaultTableModel)this.childrenVariablesTable.getModel();
        if (index >= model.getRowCount() - 1) {
            return;
        }
        Object[] row = new Object[]{model.getValueAt(index, 0), model.getValueAt(index, 1)};
        model.removeRow(index);
        model.insertRow(index + 1, row);
        this.childrenVariablesTable.getSelectionModel().setSelectionInterval(index + 1, index + 1);
    }

    private void valueFormatCheckBoxActionPerformed(ActionEvent evt) {
        if (this.valueFormatCheckBox.isSelected()) {
            this.valueEditorPane.setEnabled(true);
            this.valueEditorPane.setBackground(this.nameTextField.getBackground());
            this.valueEditorPane.requestFocusInWindow();
        } else {
            this.valueEditorPane.setEnabled(false);
            this.valueEditorPane.setBackground(VariableFormatterEditPanel.getDisabledFieldBackground());
        }
        this.checkValid();
    }

    private void childrenFormatCheckBoxActionPerformed(ActionEvent evt) {
        boolean selected = this.childrenFormatCheckBox.isSelected();
        this.childrenCodeRadioButton.setEnabled(selected);
        this.childrenVariablesRadioButton.setEnabled(selected);
        this.testChildrenCheckBox.setEnabled(selected);
        this.childrenCodeRadioButtonActionPerformed(null);
        this.childrenVariablesRadioButtonActionPerformed(null);
        this.testChildrenCheckBoxActionPerformed(null);
        this.checkValid();
    }

    private void childrenCodeRadioButtonActionPerformed(ActionEvent evt) {
        if (this.childrenCodeRadioButton.isSelected() && this.childrenCodeRadioButton.isEnabled()) {
            this.childrenCodeEditorPane.setEnabled(true);
            this.childrenCodeEditorPane.setBackground(this.nameTextField.getBackground());
            this.childrenCodeEditorPane.requestFocusInWindow();
        }
        if (!this.childrenVariablesRadioButton.isSelected() || !this.childrenVariablesRadioButton.isEnabled()) {
            this.childrenVariablesTable.getSelectionModel().clearSelection();
            if (this.childrenVariablesTable.isEditing()) {
                this.childrenVariablesTable.getCellEditor().stopCellEditing();
            }
            this.childrenVariablesTable.setEnabled(false);
            this.addVarButton.setEnabled(false);
            this.removeVarButton.setEnabled(false);
            this.moveUpVarButton.setEnabled(false);
            this.moveDownVarButton.setEnabled(false);
        }
    }

    private void childrenVariablesRadioButtonActionPerformed(ActionEvent evt) {
        if (this.childrenVariablesRadioButton.isSelected() && this.childrenVariablesRadioButton.isEnabled()) {
            this.childrenVariablesTable.setEnabled(true);
            this.childrenVariablesTable.requestFocusInWindow();
            this.addVarButton.setEnabled(true);
            int row = this.childrenVariablesTable.getSelectedRow();
            this.removeVarButton.setEnabled(row >= 0);
            this.moveUpVarButton.setEnabled(row > 0);
            this.moveDownVarButton.setEnabled(row >= 0 && row < this.childrenVariablesTable.getRowCount() - 1);
        }
        if (!this.childrenCodeRadioButton.isSelected() || !this.childrenCodeRadioButton.isEnabled()) {
            this.childrenCodeEditorPane.setEnabled(false);
            this.childrenCodeEditorPane.setBackground(VariableFormatterEditPanel.getDisabledFieldBackground());
        }
    }

    private void testChildrenCheckBoxActionPerformed(ActionEvent evt) {
        if (this.testChildrenCheckBox.isSelected() && this.testChildrenCheckBox.isEnabled()) {
            this.testChildrenEditorPane.setEnabled(true);
            this.testChildrenEditorPane.setBackground(this.nameTextField.getBackground());
            this.testChildrenEditorPane.requestFocusInWindow();
        } else {
            this.testChildrenEditorPane.setEnabled(false);
            this.testChildrenEditorPane.setBackground(VariableFormatterEditPanel.getDisabledFieldBackground());
        }
    }

    private void initChildrenVariablesTable() {
        this.removeVarButton.setEnabled(false);
        this.moveUpVarButton.setEnabled(false);
        this.moveDownVarButton.setEnabled(false);
        this.childrenVariablesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int row = VariableFormatterEditPanel.this.childrenVariablesTable.getSelectedRow();
                VariableFormatterEditPanel.this.removeVarButton.setEnabled(row >= 0);
                VariableFormatterEditPanel.this.moveUpVarButton.setEnabled(row > 0);
                VariableFormatterEditPanel.this.moveDownVarButton.setEnabled(row >= 0 && row < VariableFormatterEditPanel.this.childrenVariablesTable.getRowCount() - 1);
            }
        });
    }
}

