/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.DocValuesWriter;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedLongValues;

class SortedNumericDocValuesWriter
extends DocValuesWriter {
    private PackedLongValues.Builder pending;
    private PackedLongValues.Builder pendingCounts;
    private final Counter iwBytesUsed;
    private long bytesUsed;
    private final FieldInfo fieldInfo;
    private int currentDoc;
    private long[] currentValues = new long[8];
    private int currentUpto = 0;

    public SortedNumericDocValuesWriter(FieldInfo fieldInfo, Counter iwBytesUsed) {
        this.fieldInfo = fieldInfo;
        this.iwBytesUsed = iwBytesUsed;
        this.pending = PackedLongValues.deltaPackedBuilder(0.0f);
        this.pendingCounts = PackedLongValues.deltaPackedBuilder(0.0f);
        this.bytesUsed = this.pending.ramBytesUsed() + this.pendingCounts.ramBytesUsed();
        iwBytesUsed.addAndGet(this.bytesUsed);
    }

    public void addValue(int docID, long value) {
        if (docID != this.currentDoc) {
            this.finishCurrentDoc();
        }
        while (this.currentDoc < docID) {
            this.pendingCounts.add(0L);
            ++this.currentDoc;
        }
        this.addOneValue(value);
        this.updateBytesUsed();
    }

    private void finishCurrentDoc() {
        Arrays.sort(this.currentValues, 0, this.currentUpto);
        for (int i = 0; i < this.currentUpto; ++i) {
            this.pending.add(this.currentValues[i]);
        }
        this.pendingCounts.add(this.currentUpto);
        this.currentUpto = 0;
        ++this.currentDoc;
    }

    @Override
    public void finish(int maxDoc) {
        this.finishCurrentDoc();
        for (int i = this.currentDoc; i < maxDoc; ++i) {
            this.pendingCounts.add(0L);
        }
    }

    private void addOneValue(long value) {
        if (this.currentUpto == this.currentValues.length) {
            this.currentValues = ArrayUtil.grow(this.currentValues, this.currentValues.length + 1);
        }
        this.currentValues[this.currentUpto] = value;
        ++this.currentUpto;
    }

    private void updateBytesUsed() {
        long newBytesUsed = this.pending.ramBytesUsed() + this.pendingCounts.ramBytesUsed() + RamUsageEstimator.sizeOf(this.currentValues);
        this.iwBytesUsed.addAndGet(newBytesUsed - this.bytesUsed);
        this.bytesUsed = newBytesUsed;
    }

    @Override
    public void flush(SegmentWriteState state, DocValuesConsumer dvConsumer) throws IOException {
        int maxDoc = state.segmentInfo.maxDoc();
        assert (this.pendingCounts.size() == (long)maxDoc);
        final PackedLongValues values = this.pending.build();
        final PackedLongValues valueCounts = this.pendingCounts.build();
        dvConsumer.addSortedNumericField(this.fieldInfo, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                return new CountIterator(valueCounts);
            }
        }, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                return new ValuesIterator(values);
            }
        });
    }

    private static class CountIterator
    implements Iterator<Number> {
        final PackedLongValues.Iterator iter;

        CountIterator(PackedLongValues valueCounts) {
            this.iter = valueCounts.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Number next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ValuesIterator
    implements Iterator<Number> {
        final PackedLongValues.Iterator iter;

        ValuesIterator(PackedLongValues values) {
            this.iter = values.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Number next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

