/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.v8debug.commands;

import org.netbeans.lib.v8debug.PropertyBoolean;
import org.netbeans.lib.v8debug.PropertyLong;
import org.netbeans.lib.v8debug.V8Arguments;
import org.netbeans.lib.v8debug.V8Body;
import org.netbeans.lib.v8debug.V8Command;
import org.netbeans.lib.v8debug.V8Request;

public final class ChangeLive {
    private ChangeLive() {
    }

    public static V8Request createRequest(long sequence, long scriptId, String newSource) {
        return ChangeLive.createRequest(sequence, scriptId, newSource, null);
    }

    public static V8Request createRequest(long sequence, long scriptId, String newSource, Boolean previewOnly) {
        return new V8Request(sequence, V8Command.Changelive, new Arguments(scriptId, newSource, previewOnly));
    }

    public static final class ChangeLog {
        private final BreakpointUpdate[] breakpointsUpdate;
        private final String[] namesLinkedToOldScript;
        private final String[] droppedFrames;
        private final FunctionPatched functionPatched;
        private final PositionPatched[] patchedPositions;

        public ChangeLog(BreakpointUpdate[] breakpointsUpdate, String[] namesLinkedToOldScript, String[] droppedFrames, FunctionPatched functionPatched, PositionPatched[] patchedPositions) {
            this.breakpointsUpdate = breakpointsUpdate;
            this.namesLinkedToOldScript = namesLinkedToOldScript;
            this.droppedFrames = droppedFrames;
            this.functionPatched = functionPatched;
            this.patchedPositions = patchedPositions;
        }

        public BreakpointUpdate[] getBreakpointsUpdate() {
            return this.breakpointsUpdate;
        }

        public String[] getNamesLinkedToOldScript() {
            return this.namesLinkedToOldScript;
        }

        public String[] getDroppedFrames() {
            return this.droppedFrames;
        }

        public FunctionPatched getFunctionPatched() {
            return this.functionPatched;
        }

        public PositionPatched[] getPatchedPositions() {
            return this.patchedPositions;
        }

        public static final class PositionPatched {
            private final String name;
            private final PropertyBoolean infoNotFound;

            public PositionPatched(String name, PropertyBoolean infoNotFound) {
                this.name = name;
                this.infoNotFound = infoNotFound;
            }

            public String getName() {
                return this.name;
            }

            public PropertyBoolean getInfoNotFound() {
                return this.infoNotFound;
            }
        }

        public static final class FunctionPatched {
            private final String function;
            private final PropertyBoolean functionInfoNotFound;

            public FunctionPatched(String function, PropertyBoolean functionInfoNotFound) {
                this.function = function;
                this.functionInfoNotFound = functionInfoNotFound;
            }

            public String getFunction() {
                return this.function;
            }

            public PropertyBoolean getFunctionInfoNotFound() {
                return this.functionInfoNotFound;
            }
        }

        public static final class BreakpointUpdate {
            private final Type type;
            private final long id;
            private final PropertyLong newId;
            private final Position oldPositions;
            private final Position newPositions;

            public BreakpointUpdate(Type type, long id, PropertyLong newId, Position oldPositions, Position newPositions) {
                this.type = type;
                this.id = id;
                this.newId = newId;
                this.oldPositions = oldPositions;
                this.newPositions = newPositions;
            }

            public Type getType() {
                return this.type;
            }

            public long getId() {
                return this.id;
            }

            public PropertyLong getNewId() {
                return this.newId;
            }

            public Position getOldPositions() {
                return this.oldPositions;
            }

            public Position getNewPositions() {
                return this.newPositions;
            }

            public static final class Position {
                private final long position;
                private final long line;
                private final long column;

                public Position(long position, long line, long column) {
                    this.position = position;
                    this.line = line;
                    this.column = column;
                }

                public long getPosition() {
                    return this.position;
                }

                public long getLine() {
                    return this.line;
                }

                public long getColumn() {
                    return this.column;
                }
            }

            public static enum Type {
                CopiedToOld,
                PositionChanged;


                public static Type fromString(String typeName) {
                    int i = 0;
                    StringBuilder typeEnumStr = new StringBuilder();
                    while (i < typeName.length()) {
                        typeEnumStr.append(Character.toUpperCase(typeName.charAt(i)));
                        int i2 = typeName.indexOf(95, i);
                        if (i2 < 0) {
                            i2 = typeName.length();
                        }
                        typeEnumStr.append(typeName.substring(i + 1, i2));
                        i = i2 + 1;
                    }
                    return Type.valueOf(typeEnumStr.toString());
                }
            }
        }
    }

    public static final class Result {
        private final ChangeTree changeTree;
        private final TextualDiff diff;
        private final boolean updated;
        private final PropertyBoolean stackModified;
        private final PropertyBoolean stackUpdateNeedsStepIn;
        private final String createdScriptName;

        public Result(ChangeTree changeTree, TextualDiff diff, boolean updated, Boolean stackModified, Boolean stackUpdateNeedsStepIn, String createdScriptName) {
            this.changeTree = changeTree;
            this.diff = diff;
            this.updated = updated;
            this.stackModified = new PropertyBoolean(stackModified);
            this.stackUpdateNeedsStepIn = new PropertyBoolean(stackUpdateNeedsStepIn);
            this.createdScriptName = createdScriptName;
        }

        public ChangeTree getChangeTree() {
            return this.changeTree;
        }

        public TextualDiff getDiff() {
            return this.diff;
        }

        public boolean isUpdated() {
            return this.updated;
        }

        public PropertyBoolean getStackModified() {
            return this.stackModified;
        }

        public PropertyBoolean getStackUpdateNeedsStepIn() {
            return this.stackUpdateNeedsStepIn;
        }

        public String getCreatedScriptName() {
            return this.createdScriptName;
        }

        public static final class TextualDiff {
            private final long oldLength;
            private final long newLength;
            private final long[] chunks;

            public TextualDiff(long oldLength, long newLength, long[] chunks) {
                this.oldLength = oldLength;
                this.newLength = newLength;
                this.chunks = chunks;
            }

            public long getOldLength() {
                return this.oldLength;
            }

            public long getNewLength() {
                return this.newLength;
            }

            public long[] getChunks() {
                return this.chunks;
            }
        }

        public static final class ChangeTree {
            private final String name;
            private final Positions positions;
            private final Positions newPositions;
            private final FunctionStatus status;
            private final String statusExplanation;
            private final ChangeTree[] children;
            private final ChangeTree[] newChildren;

            public ChangeTree(String name, Positions positions, Positions newPositions, FunctionStatus status, String statusExplanation, ChangeTree[] children, ChangeTree[] newChildren) {
                this.name = name;
                this.positions = positions;
                this.newPositions = newPositions;
                this.status = status;
                this.statusExplanation = statusExplanation;
                this.children = children;
                this.newChildren = newChildren;
            }

            public String getName() {
                return this.name;
            }

            public Positions getPositions() {
                return this.positions;
            }

            public Positions getNewPositions() {
                return this.newPositions;
            }

            public FunctionStatus getStatus() {
                return this.status;
            }

            public String getStatusExplanation() {
                return this.statusExplanation;
            }

            public ChangeTree[] getChildren() {
                return this.children;
            }

            public ChangeTree[] getNewChildren() {
                return this.newChildren;
            }

            public static final class Positions {
                private final long startPosition;
                private final long endPosition;

                public Positions(long startPosition, long endPosition) {
                    this.startPosition = startPosition;
                    this.endPosition = endPosition;
                }

                public long getStartPosition() {
                    return this.startPosition;
                }

                public long getEndPosition() {
                    return this.endPosition;
                }
            }

            public static enum FunctionStatus {
                Unchanged,
                SourceChanged,
                Changed,
                Damaged;


                public static FunctionStatus fromString(String statusName) {
                    int i;
                    statusName = Character.toUpperCase(statusName.charAt(0)) + statusName.substring(1);
                    while ((i = statusName.indexOf(32)) > 0) {
                        statusName = statusName.substring(0, i) + Character.toUpperCase(statusName.charAt(i + 1)) + statusName.substring(i + 2);
                    }
                    return FunctionStatus.valueOf(statusName);
                }

                public String toString() {
                    String statusName = super.toString();
                    statusName = Character.toLowerCase(statusName.charAt(0)) + statusName.substring(1);
                    for (int i = 0; i < statusName.length(); ++i) {
                        if (!Character.isUpperCase(statusName.charAt(i))) continue;
                        statusName = statusName.substring(0, i) + " " + Character.toLowerCase(statusName.charAt(i)) + statusName.substring(i + 1);
                        ++i;
                    }
                    return statusName;
                }
            }
        }
    }

    public static final class ResponseBody
    extends V8Body {
        private final ChangeLog changeLog;
        private final Result result;
        private final PropertyBoolean stepInRecommended;

        public ResponseBody(ChangeLog changeLog, Result result, Boolean stepInRecommended) {
            this.changeLog = changeLog;
            this.result = result;
            this.stepInRecommended = new PropertyBoolean(stepInRecommended);
        }

        public ChangeLog getChangeLog() {
            return this.changeLog;
        }

        public Result getResult() {
            return this.result;
        }

        public PropertyBoolean getStepInRecommended() {
            return this.stepInRecommended;
        }
    }

    public static final class Arguments
    extends V8Arguments {
        private final long scriptId;
        private final String newSource;
        private final PropertyBoolean previewOnly;

        public Arguments(long scriptId, String newSource, Boolean previewOnly) {
            this.scriptId = scriptId;
            this.newSource = newSource;
            this.previewOnly = new PropertyBoolean(previewOnly);
        }

        public long getScriptId() {
            return this.scriptId;
        }

        public PropertyBoolean isPreviewOnly() {
            return this.previewOnly;
        }

        public String getNewSource() {
            return this.newSource;
        }
    }
}

