/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.weblogic.common.api;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.weblogic.common.ProxyUtils;
import org.netbeans.modules.weblogic.common.api.WebLogicConfiguration;
import org.netbeans.modules.weblogic.common.spi.WebLogicTrustHandler;
import org.openide.util.Lookup;

public final class WebLogicRemote {
    private final WebLogicConfiguration config;

    WebLogicRemote(WebLogicConfiguration config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T executeAction(@NonNull Callable<T> action, @NullAllowed Callable<String> nonProxy) throws Exception {
        WebLogicRemote webLogicRemote = this;
        synchronized (webLogicRemote) {
            WebLogicTrustHandler handler;
            String originalNonProxyHosts = System.getProperty("http.nonProxyHosts");
            String nonProxyHosts = ProxyUtils.getNonProxyHosts(nonProxy);
            if (nonProxyHosts != null) {
                System.setProperty("http.nonProxyHosts", nonProxyHosts);
            }
            if (this.config.isSecured() && (handler = (WebLogicTrustHandler)Lookup.getDefault().lookup(WebLogicTrustHandler.class)) != null) {
                for (Map.Entry<String, String> e : handler.getTrustProperties(this.config).entrySet()) {
                    System.setProperty(e.getKey(), e.getValue());
                }
            }
            T t = action.call();
            return t;
            finally {
                if (originalNonProxyHosts == null) {
                    System.clearProperty("http.nonProxyHosts");
                } else {
                    System.setProperty("http.nonProxyHosts", originalNonProxyHosts);
                }
            }
        }
    }

    public <T> T executeAction(final @NonNull JmxAction<T> action, @NullAllowed Callable<String> nonProxy) throws Exception {
        return this.executeAction(new Callable<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public T call() throws Exception {
                JMXServiceURL url = new JMXServiceURL(WebLogicRemote.this.config.isSecured() ? "t3s" : "t3", WebLogicRemote.this.config.getHost(), WebLogicRemote.this.config.getPort(), "/jndi/weblogic.management.mbeanservers.domainruntime");
                String username = WebLogicRemote.this.config.getUsername();
                String password = WebLogicRemote.this.config.getPassword();
                HashMap<String, Object> env = new HashMap<String, Object>();
                env.put("jmx.remote.protocol.provider.pkgs", "weblogic.management.remote");
                env.put("java.naming.security.principal", username);
                env.put("java.naming.security.credentials", password);
                env.put("jmx.remote.credentials", new String[]{username, password});
                env.put("jmx.remote.protocol.provider.class.loader", WebLogicRemote.this.config.getLayout().getClassLoader());
                jmxConnector.connect();
                try (JMXConnector jmxConnector = JMXConnectorFactory.newJMXConnector(url, env);){
                    Object t = action.execute(jmxConnector.getMBeanServerConnection());
                    return t;
                }
            }
        }, nonProxy);
    }

    public static interface JmxAction<T> {
        public T execute(MBeanServerConnection var1) throws Exception;
    }
}

