/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.JSBuiltinObject;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;

public interface JSConstructorFactory {
    public JSConstructor createConstructorAndPrototype(JSRealm var1);

    public static interface Default
    extends JSConstructorFactory {
        @Override
        default public JSConstructor createConstructorAndPrototype(JSRealm realm) {
            JSContext ctx = realm.getContext();
            DynamicObject constructor = this.createConstructorObject(realm);
            DynamicObject prototype = this.createPrototype(realm, constructor);
            JSObjectUtil.putPrototypeData(prototype);
            JSObjectUtil.putConstructorPrototypeProperty(ctx, constructor, prototype);
            this.fillConstructor(realm, constructor);
            return new JSConstructor(constructor, prototype);
        }

        public String getClassName();

        public DynamicObject createPrototype(JSRealm var1, DynamicObject var2);

        default public DynamicObject createConstructorObject(JSRealm realm) {
            return realm.lookupFunction("%Constructors%", this.getClassName());
        }

        default public void fillConstructor(JSRealm realm, DynamicObject constructor) {
        }

        public static interface WithFunctionsAndSpecies
        extends Default {
            @Override
            default public void fillConstructor(JSRealm realm, DynamicObject constructor) {
                JSObjectUtil.putFunctionsFromContainer(realm, constructor, this.getClassName());
                JSBuiltinObject.putConstructorSpeciesGetter(realm, constructor);
            }
        }

        public static interface WithFunctions
        extends Default {
            @Override
            default public void fillConstructor(JSRealm realm, DynamicObject constructor) {
                JSObjectUtil.putFunctionsFromContainer(realm, constructor, this.getClassName());
            }
        }
    }
}

