/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.binary;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.Introspection;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JSGuards;
import com.oracle.truffle.js.nodes.JSTypes;
import com.oracle.truffle.js.nodes.JSTypesGen;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.binary.JSIdenticalNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSLazyString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.locks.Lock;

@GeneratedBy(value=JSIdenticalNode.class)
public final class JSIdenticalNodeGen
extends JSIdenticalNode
implements Introspection.Provider {
    @CompilerDirectives.CompilationFinal
    private long state_;
    @CompilerDirectives.CompilationFinal
    private int exclude_;
    @CompilerDirectives.CompilationFinal
    private LazyStringData lazyString_cache;
    @CompilerDirectives.CompilationFinal
    private ConditionProfile lazyStringLeft_flatten_;
    @CompilerDirectives.CompilationFinal
    private ConditionProfile lazyStringLeft_len_;
    @CompilerDirectives.CompilationFinal
    private ConditionProfile lazyStringRight_flatten_;
    @CompilerDirectives.CompilationFinal
    private ConditionProfile lazyStringRight_len_;
    @CompilerDirectives.CompilationFinal
    private DifferentTypesCachedData differentTypesCached_cache;
    @CompilerDirectives.CompilationFinal
    private NumberCachedData numberCached_cache;

    private JSIdenticalNodeGen(JavaScriptNode left, JavaScriptNode right, int type) {
        super(left, right, type);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    public boolean executeBoolean(Object leftNodeValue, Object rightNodeValue) {
        Object rightNodeValue_;
        CharSequence leftNodeValue_;
        long state = this.state_;
        if ((state & 1L) != 0L && leftNodeValue instanceof Integer) {
            int n = (Integer)leftNodeValue;
            if (rightNodeValue instanceof Integer) {
                int rightNodeValue_2 = (Integer)rightNodeValue;
                return JSIdenticalNode.doInt(n, rightNodeValue_2);
            }
        }
        if ((state & 2L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x1E000000L) >>> 25), leftNodeValue)) {
            double d = JSTypesGen.asImplicitDouble((int)((state & 0x1E000000L) >>> 25), leftNodeValue);
            if (JSTypesGen.isImplicitDouble((int)((state & 0x1E0000000L) >>> 29), rightNodeValue)) {
                double rightNodeValue_3 = JSTypesGen.asImplicitDouble((int)((state & 0x1E0000000L) >>> 29), rightNodeValue);
                return this.doDouble(d, rightNodeValue_3);
            }
        }
        if ((state & 4L) != 0L && leftNodeValue instanceof Boolean) {
            boolean bl = (Boolean)leftNodeValue;
            if (rightNodeValue instanceof Boolean) {
                boolean rightNodeValue_4 = (Boolean)rightNodeValue;
                return JSIdenticalNode.doBoolean(bl, rightNodeValue_4);
            }
        }
        if ((state & 0x18L) != 0L && leftNodeValue instanceof BigInt) {
            BigInt bigInt = (BigInt)leftNodeValue;
            if ((state & 8L) != 0L && rightNodeValue instanceof BigInt) {
                BigInt rightNodeValue_5 = (BigInt)rightNodeValue;
                return JSIdenticalNode.doBigInt(bigInt, rightNodeValue_5);
            }
            if ((state & 0x10L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x1E0000000L) >>> 29), rightNodeValue)) {
                double rightNodeValue_6 = JSTypesGen.asImplicitDouble((int)((state & 0x1E0000000L) >>> 29), rightNodeValue);
                return JSIdenticalNode.doBigIntDouble(bigInt, rightNodeValue_6);
            }
        }
        if ((state & 0x20L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x1E000000L) >>> 25), leftNodeValue)) {
            double d = JSTypesGen.asImplicitDouble((int)((state & 0x1E000000L) >>> 25), leftNodeValue);
            if (rightNodeValue instanceof BigInt) {
                BigInt rightNodeValue_7 = (BigInt)rightNodeValue;
                return JSIdenticalNode.doDoubleBigInt(d, rightNodeValue_7);
            }
        }
        if ((state & 0x40L) != 0L && JSTypes.isDynamicObject(leftNodeValue)) {
            DynamicObject dynamicObject = (DynamicObject)leftNodeValue;
            if (JSTypes.isDynamicObject(rightNodeValue)) {
                DynamicObject rightNodeValue_8 = (DynamicObject)rightNodeValue;
                return JSIdenticalNode.doObject(dynamicObject, rightNodeValue_8);
            }
        }
        if ((state & 0x380L) != 0L && rightNodeValue instanceof JSLazyString) {
            JSLazyString jSLazyString = (JSLazyString)rightNodeValue;
            if ((state & 0x180L) != 0L && leftNodeValue instanceof JSLazyString) {
                LazyStringData s9_;
                leftNodeValue_ = (JSLazyString)leftNodeValue;
                if ((state & 0x80L) != 0L && JSGuards.isReferenceEquals(leftNodeValue_, jSLazyString)) {
                    return JSIdenticalNode.doLazyStringReference(leftNodeValue_, jSLazyString);
                }
                if ((state & 0x100L) != 0L && (s9_ = this.lazyString_cache) != null) {
                    return JSIdenticalNode.doLazyString(leftNodeValue_, jSLazyString, s9_.flattenA_, s9_.flattenB_, s9_.len_);
                }
            }
            if ((state & 0x200L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x1E00000000L) >>> 33), leftNodeValue)) {
                leftNodeValue_ = JSTypesGen.asImplicitString((int)((state & 0x1E00000000L) >>> 33), leftNodeValue);
                return JSIdenticalNode.doLazyStringLeft((String)leftNodeValue_, jSLazyString, this.lazyStringLeft_flatten_, this.lazyStringLeft_len_);
            }
        }
        if ((state & 0x1C00L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x1E000000000L) >>> 37), rightNodeValue)) {
            String string = JSTypesGen.asImplicitString((int)((state & 0x1E000000000L) >>> 37), rightNodeValue);
            if ((state & 0x400L) != 0L && leftNodeValue instanceof JSLazyString) {
                leftNodeValue_ = (JSLazyString)leftNodeValue;
                return JSIdenticalNode.doLazyStringRight(leftNodeValue_, string, this.lazyStringRight_flatten_, this.lazyStringRight_len_);
            }
            if ((state & 0x1800L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x1E00000000L) >>> 33), leftNodeValue)) {
                leftNodeValue_ = JSTypesGen.asImplicitString((int)((state & 0x1E00000000L) >>> 33), leftNodeValue);
                if ((state & 0x800L) != 0L && JSGuards.isReferenceEquals(leftNodeValue_, string)) {
                    return JSIdenticalNode.doStringIdentity((String)leftNodeValue_, string);
                }
                if ((state & 0x1000L) != 0L) {
                    return JSIdenticalNode.doString((String)leftNodeValue_, string);
                }
            }
        }
        if ((state & 0x2000L) != 0L && leftNodeValue instanceof Symbol) {
            Symbol symbol = (Symbol)leftNodeValue;
            if (rightNodeValue instanceof Symbol) {
                rightNodeValue_ = (Symbol)rightNodeValue;
                return JSIdenticalNode.doSymbol(symbol, (Symbol)rightNodeValue_);
            }
        }
        if ((state & 0x3FC000L) != 0L) {
            if ((state & 0x4000L) != 0L && JSGuards.isBoolean(leftNodeValue) != JSGuards.isBoolean(rightNodeValue)) {
                return JSIdenticalNode.doBooleanNotBoolean(leftNodeValue, rightNodeValue);
            }
            if ((state & 0x8000L) != 0L && JSGuards.isSymbol(leftNodeValue) != JSGuards.isSymbol(rightNodeValue)) {
                return JSIdenticalNode.doSymbolNotSymbol(leftNodeValue, rightNodeValue);
            }
            if ((state & 0x10000L) != 0L && JSGuards.isJSNull(leftNodeValue) != JSGuards.isJSNull(rightNodeValue)) {
                return JSIdenticalNode.doNullNotNull(leftNodeValue, rightNodeValue);
            }
            if ((state & 0x20000L) != 0L && JSGuards.isUndefined(leftNodeValue) != JSGuards.isUndefined(rightNodeValue)) {
                return JSIdenticalNode.doUndefinedNotUndefined(leftNodeValue, rightNodeValue);
            }
            if ((state & 0x40000L) != 0L) {
                void var5_14;
                DifferentTypesCachedData differentTypesCachedData = this.differentTypesCached_cache;
                while (var5_14 != null) {
                    if (leftNodeValue.getClass() == var5_14.cachedClassA_ && rightNodeValue.getClass() == var5_14.cachedClassB_) {
                        assert (JSIdenticalNode.isNonObjectType(var5_14.cachedClassA_) || JSIdenticalNode.isNonObjectType(var5_14.cachedClassB_));
                        assert (JSIdenticalNode.differentNonObjectTypes(var5_14.cachedClassA_, var5_14.cachedClassB_));
                        return JSIdenticalNode.doDifferentTypesCached(leftNodeValue, rightNodeValue, var5_14.cachedClassA_, var5_14.cachedClassB_);
                    }
                    DifferentTypesCachedData differentTypesCachedData2 = var5_14.next_;
                }
            }
            if ((state & 0x80000L) != 0L && JSRuntime.isJavaNumber(leftNodeValue) != JSRuntime.isJavaNumber(rightNodeValue)) {
                return JSIdenticalNode.doNumberNotNumber(leftNodeValue, rightNodeValue);
            }
            if ((state & 0x100000L) != 0L && JSRuntime.isString(leftNodeValue) != JSRuntime.isString(rightNodeValue)) {
                return JSIdenticalNode.doStringNotString(leftNodeValue, rightNodeValue);
            }
            if ((state & 0x200000L) != 0L) {
                void var5_17;
                NumberCachedData numberCachedData = this.numberCached_cache;
                while (var5_17 != null) {
                    assert (var5_17.cachedClassA_ != null);
                    assert (var5_17.cachedClassB_ != null);
                    if (leftNodeValue.getClass() == var5_17.cachedClassA_ && rightNodeValue.getClass() == var5_17.cachedClassB_) {
                        return this.doNumberCached(leftNodeValue, rightNodeValue, var5_17.cachedClassA_, var5_17.cachedClassB_);
                    }
                    NumberCachedData numberCachedData2 = var5_17.next_;
                }
            }
        }
        if ((state & 0x400000L) != 0L && leftNodeValue instanceof Number) {
            Number number = (Number)leftNodeValue;
            if (rightNodeValue instanceof Number) {
                rightNodeValue_ = (Number)rightNodeValue;
                if (JSRuntime.isJavaNumber(number) && JSRuntime.isJavaNumber(rightNodeValue_)) {
                    return this.doNumber(number, (Number)rightNodeValue_);
                }
            }
        }
        if ((state & 0x800000L) != 0L && leftNodeValue instanceof TruffleObject) {
            TruffleObject truffleObject = (TruffleObject)leftNodeValue;
            if (rightNodeValue instanceof TruffleObject) {
                rightNodeValue_ = (TruffleObject)rightNodeValue;
                if (JSGuards.isTruffleJavaObject(truffleObject) && JSGuards.isTruffleJavaObject((TruffleObject)rightNodeValue_)) {
                    return JSIdenticalNode.doTruffleJavaObjects(truffleObject, (TruffleObject)rightNodeValue_);
                }
            }
        }
        if ((state & 0x1000000L) != 0L && JSIdenticalNodeGen.fallbackGuard_(state, leftNodeValue, rightNodeValue)) {
            return JSIdenticalNode.doFallback(leftNodeValue, rightNodeValue);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue, rightNodeValue);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frameValue) {
        long state = this.state_;
        if ((state & 0x1FFFFFEL) == 0L && (state & 0x1FFFFFFL) != 0L) {
            return this.executeBoolean_int_int0(frameValue, state);
        }
        if ((state & 0x1FFFFFDL) == 0L && (state & 0x1FFFFFFL) != 0L) {
            return this.executeBoolean_double_double1(frameValue, state);
        }
        if ((state & 0x1FFFFFBL) == 0L && (state & 0x1FFFFFFL) != 0L) {
            return this.executeBoolean_boolean_boolean2(frameValue, state);
        }
        if ((state & 0x1FFFFEFL) == 0L && (state & 0x1FFFFFFL) != 0L) {
            return this.executeBoolean_double3(frameValue, state);
        }
        if ((state & 0x1FFFFDFL) == 0L && (state & 0x1FFFFFFL) != 0L) {
            return this.executeBoolean_double4(frameValue, state);
        }
        return this.executeBoolean_generic5(frameValue, state);
    }

    private boolean executeBoolean_int_int0(VirtualFrame frameValue, long state) {
        int rightNodeValue_;
        int leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode.executeInt(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state & 1L) != 0L);
        return JSIdenticalNode.doInt(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_double_double1(VirtualFrame frameValue, long state) {
        double rightNodeValue_;
        double leftNodeValue_;
        int leftNodeValue_int = 0;
        long leftNodeValue_long = 0L;
        try {
            if ((state & 0x1C000000L) == 0L && (state & 0x1FFFFFFL) != 0L) {
                leftNodeValue_long = this.leftNode.executeLong(frameValue);
                leftNodeValue_ = JSTypes.longToDouble(leftNodeValue_long);
            } else if ((state & 0x1A000000L) == 0L && (state & 0x1FFFFFFL) != 0L) {
                leftNodeValue_int = this.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else if ((state & 0x16000000L) == 0L && (state & 0x1FFFFFFL) != 0L) {
                leftNodeValue_ = this.leftNode.executeDouble(frameValue);
            } else {
                Object leftNodeValue__ = this.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((int)((state & 0x1E000000L) >>> 25), leftNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        int rightNodeValue_int = 0;
        long rightNodeValue_long = 0L;
        try {
            if ((state & 0x1C0000000L) == 0L && (state & 0x1FFFFFFL) != 0L) {
                rightNodeValue_long = this.rightNode.executeLong(frameValue);
                rightNodeValue_ = JSTypes.longToDouble(rightNodeValue_long);
            } else if ((state & 0x1A0000000L) == 0L && (state & 0x1FFFFFFL) != 0L) {
                rightNodeValue_int = this.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else if ((state & 0x160000000L) == 0L && (state & 0x1FFFFFFL) != 0L) {
                rightNodeValue_ = this.rightNode.executeDouble(frameValue);
            } else {
                Object rightNodeValue__ = this.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((int)((state & 0x1E0000000L) >>> 29), rightNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize((state & 0x1C000000L) == 0L && (state & 0x1FFFFFFL) != 0L ? (Number)leftNodeValue_long : (Number)((state & 0x1A000000L) == 0L && (state & 0x1FFFFFFL) != 0L ? (Number)leftNodeValue_int : (Number)leftNodeValue_), ex.getResult());
        }
        assert ((state & 2L) != 0L);
        return this.doDouble(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_boolean_boolean2(VirtualFrame frameValue, long state) {
        boolean rightNodeValue_;
        boolean leftNodeValue_;
        try {
            leftNodeValue_ = this.leftNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        try {
            rightNodeValue_ = this.rightNode.executeBoolean(frameValue);
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state & 4L) != 0L);
        return JSIdenticalNode.doBoolean(leftNodeValue_, rightNodeValue_);
    }

    private boolean executeBoolean_double3(VirtualFrame frameValue, long state) {
        double rightNodeValue_;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        int rightNodeValue_int = 0;
        long rightNodeValue_long = 0L;
        try {
            if ((state & 0x1C0000000L) == 0L && (state & 0x1FFFFFFL) != 0L) {
                rightNodeValue_long = this.rightNode.executeLong(frameValue);
                rightNodeValue_ = JSTypes.longToDouble(rightNodeValue_long);
            } else if ((state & 0x1A0000000L) == 0L && (state & 0x1FFFFFFL) != 0L) {
                rightNodeValue_int = this.rightNode.executeInt(frameValue);
                rightNodeValue_ = JSTypes.intToDouble(rightNodeValue_int);
            } else if ((state & 0x160000000L) == 0L && (state & 0x1FFFFFFL) != 0L) {
                rightNodeValue_ = this.rightNode.executeDouble(frameValue);
            } else {
                Object rightNodeValue__ = this.rightNode.execute(frameValue);
                rightNodeValue_ = JSTypesGen.expectImplicitDouble((int)((state & 0x1E0000000L) >>> 29), rightNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            return this.executeAndSpecialize(leftNodeValue_, ex.getResult());
        }
        assert ((state & 0x10L) != 0L);
        if (leftNodeValue_ instanceof BigInt) {
            BigInt leftNodeValue__ = (BigInt)leftNodeValue_;
            return JSIdenticalNode.doBigIntDouble(leftNodeValue__, rightNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, (state & 0x1C0000000L) == 0L && (state & 0x1FFFFFFL) != 0L ? (Number)rightNodeValue_long : (Number)((state & 0x1A0000000L) == 0L && (state & 0x1FFFFFFL) != 0L ? (Number)rightNodeValue_int : (Number)rightNodeValue_));
    }

    private boolean executeBoolean_double4(VirtualFrame frameValue, long state) {
        double leftNodeValue_;
        int leftNodeValue_int = 0;
        long leftNodeValue_long = 0L;
        try {
            if ((state & 0x1C000000L) == 0L && (state & 0x1FFFFFFL) != 0L) {
                leftNodeValue_long = this.leftNode.executeLong(frameValue);
                leftNodeValue_ = JSTypes.longToDouble(leftNodeValue_long);
            } else if ((state & 0x1A000000L) == 0L && (state & 0x1FFFFFFL) != 0L) {
                leftNodeValue_int = this.leftNode.executeInt(frameValue);
                leftNodeValue_ = JSTypes.intToDouble(leftNodeValue_int);
            } else if ((state & 0x16000000L) == 0L && (state & 0x1FFFFFFL) != 0L) {
                leftNodeValue_ = this.leftNode.executeDouble(frameValue);
            } else {
                Object leftNodeValue__ = this.leftNode.execute(frameValue);
                leftNodeValue_ = JSTypesGen.expectImplicitDouble((int)((state & 0x1E000000L) >>> 25), leftNodeValue__);
            }
        }
        catch (UnexpectedResultException ex) {
            Object rightNodeValue = this.rightNode.execute(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightNodeValue);
        }
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        assert ((state & 0x20L) != 0L);
        if (rightNodeValue_ instanceof BigInt) {
            BigInt rightNodeValue__ = (BigInt)rightNodeValue_;
            return JSIdenticalNode.doDoubleBigInt(leftNodeValue_, rightNodeValue__);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize((state & 0x1C000000L) == 0L && (state & 0x1FFFFFFL) != 0L ? (Number)leftNodeValue_long : (Number)((state & 0x1A000000L) == 0L && (state & 0x1FFFFFFL) != 0L ? (Number)leftNodeValue_int : (Number)leftNodeValue_), rightNodeValue_);
    }

    /*
     * WARNING - void declaration
     */
    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_EXPLODE_UNTIL_RETURN)
    private boolean executeBoolean_generic5(VirtualFrame frameValue, long state) {
        Object rightNodeValue__;
        CharSequence leftNodeValue__;
        Object leftNodeValue_ = this.leftNode.execute(frameValue);
        Object rightNodeValue_ = this.rightNode.execute(frameValue);
        if ((state & 1L) != 0L && leftNodeValue_ instanceof Integer) {
            int n = (Integer)leftNodeValue_;
            if (rightNodeValue_ instanceof Integer) {
                int rightNodeValue__2 = (Integer)rightNodeValue_;
                return JSIdenticalNode.doInt(n, rightNodeValue__2);
            }
        }
        if ((state & 2L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x1E000000L) >>> 25), leftNodeValue_)) {
            double d = JSTypesGen.asImplicitDouble((int)((state & 0x1E000000L) >>> 25), leftNodeValue_);
            if (JSTypesGen.isImplicitDouble((int)((state & 0x1E0000000L) >>> 29), rightNodeValue_)) {
                double rightNodeValue__3 = JSTypesGen.asImplicitDouble((int)((state & 0x1E0000000L) >>> 29), rightNodeValue_);
                return this.doDouble(d, rightNodeValue__3);
            }
        }
        if ((state & 4L) != 0L && leftNodeValue_ instanceof Boolean) {
            boolean bl = (Boolean)leftNodeValue_;
            if (rightNodeValue_ instanceof Boolean) {
                boolean rightNodeValue__4 = (Boolean)rightNodeValue_;
                return JSIdenticalNode.doBoolean(bl, rightNodeValue__4);
            }
        }
        if ((state & 0x18L) != 0L && leftNodeValue_ instanceof BigInt) {
            BigInt bigInt = (BigInt)leftNodeValue_;
            if ((state & 8L) != 0L && rightNodeValue_ instanceof BigInt) {
                BigInt rightNodeValue__5 = (BigInt)rightNodeValue_;
                return JSIdenticalNode.doBigInt(bigInt, rightNodeValue__5);
            }
            if ((state & 0x10L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x1E0000000L) >>> 29), rightNodeValue_)) {
                double rightNodeValue__6 = JSTypesGen.asImplicitDouble((int)((state & 0x1E0000000L) >>> 29), rightNodeValue_);
                return JSIdenticalNode.doBigIntDouble(bigInt, rightNodeValue__6);
            }
        }
        if ((state & 0x20L) != 0L && JSTypesGen.isImplicitDouble((int)((state & 0x1E000000L) >>> 25), leftNodeValue_)) {
            double d = JSTypesGen.asImplicitDouble((int)((state & 0x1E000000L) >>> 25), leftNodeValue_);
            if (rightNodeValue_ instanceof BigInt) {
                BigInt rightNodeValue__7 = (BigInt)rightNodeValue_;
                return JSIdenticalNode.doDoubleBigInt(d, rightNodeValue__7);
            }
        }
        if ((state & 0x40L) != 0L && JSTypes.isDynamicObject(leftNodeValue_)) {
            DynamicObject dynamicObject = (DynamicObject)leftNodeValue_;
            if (JSTypes.isDynamicObject(rightNodeValue_)) {
                DynamicObject rightNodeValue__8 = (DynamicObject)rightNodeValue_;
                return JSIdenticalNode.doObject(dynamicObject, rightNodeValue__8);
            }
        }
        if ((state & 0x380L) != 0L && rightNodeValue_ instanceof JSLazyString) {
            JSLazyString jSLazyString = (JSLazyString)rightNodeValue_;
            if ((state & 0x180L) != 0L && leftNodeValue_ instanceof JSLazyString) {
                LazyStringData s9_;
                leftNodeValue__ = (JSLazyString)leftNodeValue_;
                if ((state & 0x80L) != 0L && JSGuards.isReferenceEquals(leftNodeValue__, jSLazyString)) {
                    return JSIdenticalNode.doLazyStringReference(leftNodeValue__, jSLazyString);
                }
                if ((state & 0x100L) != 0L && (s9_ = this.lazyString_cache) != null) {
                    return JSIdenticalNode.doLazyString(leftNodeValue__, jSLazyString, s9_.flattenA_, s9_.flattenB_, s9_.len_);
                }
            }
            if ((state & 0x200L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x1E00000000L) >>> 33), leftNodeValue_)) {
                leftNodeValue__ = JSTypesGen.asImplicitString((int)((state & 0x1E00000000L) >>> 33), leftNodeValue_);
                return JSIdenticalNode.doLazyStringLeft((String)leftNodeValue__, jSLazyString, this.lazyStringLeft_flatten_, this.lazyStringLeft_len_);
            }
        }
        if ((state & 0x1C00L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x1E000000000L) >>> 37), rightNodeValue_)) {
            String string = JSTypesGen.asImplicitString((int)((state & 0x1E000000000L) >>> 37), rightNodeValue_);
            if ((state & 0x400L) != 0L && leftNodeValue_ instanceof JSLazyString) {
                leftNodeValue__ = (JSLazyString)leftNodeValue_;
                return JSIdenticalNode.doLazyStringRight(leftNodeValue__, string, this.lazyStringRight_flatten_, this.lazyStringRight_len_);
            }
            if ((state & 0x1800L) != 0L && JSTypesGen.isImplicitString((int)((state & 0x1E00000000L) >>> 33), leftNodeValue_)) {
                leftNodeValue__ = JSTypesGen.asImplicitString((int)((state & 0x1E00000000L) >>> 33), leftNodeValue_);
                if ((state & 0x800L) != 0L && JSGuards.isReferenceEquals(leftNodeValue__, string)) {
                    return JSIdenticalNode.doStringIdentity((String)leftNodeValue__, string);
                }
                if ((state & 0x1000L) != 0L) {
                    return JSIdenticalNode.doString((String)leftNodeValue__, string);
                }
            }
        }
        if ((state & 0x2000L) != 0L && leftNodeValue_ instanceof Symbol) {
            Symbol symbol = (Symbol)leftNodeValue_;
            if (rightNodeValue_ instanceof Symbol) {
                rightNodeValue__ = (Symbol)rightNodeValue_;
                return JSIdenticalNode.doSymbol(symbol, (Symbol)rightNodeValue__);
            }
        }
        if ((state & 0x3FC000L) != 0L) {
            if ((state & 0x4000L) != 0L && JSGuards.isBoolean(leftNodeValue_) != JSGuards.isBoolean(rightNodeValue_)) {
                return JSIdenticalNode.doBooleanNotBoolean(leftNodeValue_, rightNodeValue_);
            }
            if ((state & 0x8000L) != 0L && JSGuards.isSymbol(leftNodeValue_) != JSGuards.isSymbol(rightNodeValue_)) {
                return JSIdenticalNode.doSymbolNotSymbol(leftNodeValue_, rightNodeValue_);
            }
            if ((state & 0x10000L) != 0L && JSGuards.isJSNull(leftNodeValue_) != JSGuards.isJSNull(rightNodeValue_)) {
                return JSIdenticalNode.doNullNotNull(leftNodeValue_, rightNodeValue_);
            }
            if ((state & 0x20000L) != 0L && JSGuards.isUndefined(leftNodeValue_) != JSGuards.isUndefined(rightNodeValue_)) {
                return JSIdenticalNode.doUndefinedNotUndefined(leftNodeValue_, rightNodeValue_);
            }
            if ((state & 0x40000L) != 0L) {
                void var6_15;
                DifferentTypesCachedData differentTypesCachedData = this.differentTypesCached_cache;
                while (var6_15 != null) {
                    if (leftNodeValue_.getClass() == var6_15.cachedClassA_ && rightNodeValue_.getClass() == var6_15.cachedClassB_) {
                        assert (JSIdenticalNode.isNonObjectType(var6_15.cachedClassA_) || JSIdenticalNode.isNonObjectType(var6_15.cachedClassB_));
                        assert (JSIdenticalNode.differentNonObjectTypes(var6_15.cachedClassA_, var6_15.cachedClassB_));
                        return JSIdenticalNode.doDifferentTypesCached(leftNodeValue_, rightNodeValue_, var6_15.cachedClassA_, var6_15.cachedClassB_);
                    }
                    DifferentTypesCachedData differentTypesCachedData2 = var6_15.next_;
                }
            }
            if ((state & 0x80000L) != 0L && JSRuntime.isJavaNumber(leftNodeValue_) != JSRuntime.isJavaNumber(rightNodeValue_)) {
                return JSIdenticalNode.doNumberNotNumber(leftNodeValue_, rightNodeValue_);
            }
            if ((state & 0x100000L) != 0L && JSRuntime.isString(leftNodeValue_) != JSRuntime.isString(rightNodeValue_)) {
                return JSIdenticalNode.doStringNotString(leftNodeValue_, rightNodeValue_);
            }
            if ((state & 0x200000L) != 0L) {
                void var6_18;
                NumberCachedData numberCachedData = this.numberCached_cache;
                while (var6_18 != null) {
                    assert (var6_18.cachedClassA_ != null);
                    assert (var6_18.cachedClassB_ != null);
                    if (leftNodeValue_.getClass() == var6_18.cachedClassA_ && rightNodeValue_.getClass() == var6_18.cachedClassB_) {
                        return this.doNumberCached(leftNodeValue_, rightNodeValue_, var6_18.cachedClassA_, var6_18.cachedClassB_);
                    }
                    NumberCachedData numberCachedData2 = var6_18.next_;
                }
            }
        }
        if ((state & 0x400000L) != 0L && leftNodeValue_ instanceof Number) {
            Number number = (Number)leftNodeValue_;
            if (rightNodeValue_ instanceof Number) {
                rightNodeValue__ = (Number)rightNodeValue_;
                if (JSRuntime.isJavaNumber(number) && JSRuntime.isJavaNumber(rightNodeValue__)) {
                    return this.doNumber(number, (Number)rightNodeValue__);
                }
            }
        }
        if ((state & 0x800000L) != 0L && leftNodeValue_ instanceof TruffleObject) {
            TruffleObject truffleObject = (TruffleObject)leftNodeValue_;
            if (rightNodeValue_ instanceof TruffleObject) {
                rightNodeValue__ = (TruffleObject)rightNodeValue_;
                if (JSGuards.isTruffleJavaObject(truffleObject) && JSGuards.isTruffleJavaObject((TruffleObject)rightNodeValue__)) {
                    return JSIdenticalNode.doTruffleJavaObjects(truffleObject, (TruffleObject)rightNodeValue__);
                }
            }
        }
        if ((state & 0x1000000L) != 0L && JSIdenticalNodeGen.fallbackGuard_(state, leftNodeValue_, rightNodeValue_)) {
            return JSIdenticalNode.doFallback(leftNodeValue_, rightNodeValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftNodeValue_, rightNodeValue_);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.executeBoolean(frameValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private boolean executeAndSpecialize(Object leftNodeValue, Object rightNodeValue) {
        Lock lock = this.getLock();
        boolean hasLock = true;
        lock.lock();
        long state = this.state_;
        int exclude = this.exclude_;
        long oldState = state & 0x1FFFFFFL;
        int oldExclude = exclude;
        int oldCacheCount = state == 0L ? 0 : this.countCaches();
        try {
            int stringCast0;
            int n;
            boolean rightNodeValue_72;
            int n2;
            int n3;
            if (leftNodeValue instanceof Integer) {
                int n4 = (Integer)leftNodeValue;
                if (rightNodeValue instanceof Integer) {
                    int rightNodeValue_2 = (Integer)rightNodeValue;
                    this.state_ = state |= 1L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSIdenticalNode.doInt(n4, rightNodeValue_2);
                    return bl;
                }
            }
            if ((n3 = JSTypesGen.specializeImplicitDouble(leftNodeValue)) != 0) {
                double leftNodeValue_2 = JSTypesGen.asImplicitDouble(n3, leftNodeValue);
                int doubleCast1 = JSTypesGen.specializeImplicitDouble(rightNodeValue);
                if (doubleCast1 != 0) {
                    double rightNodeValue_3 = JSTypesGen.asImplicitDouble(doubleCast1, rightNodeValue);
                    state |= (long)n3 << 25;
                    state |= (long)doubleCast1 << 29;
                    this.state_ = state |= 2L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = this.doDouble(leftNodeValue_2, rightNodeValue_3);
                    return bl;
                }
            }
            if (leftNodeValue instanceof Boolean) {
                boolean bl = (Boolean)leftNodeValue;
                if (rightNodeValue instanceof Boolean) {
                    boolean rightNodeValue_4 = (Boolean)rightNodeValue;
                    this.state_ = state |= 4L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl2 = JSIdenticalNode.doBoolean(bl, rightNodeValue_4);
                    return bl2;
                }
            }
            if (leftNodeValue instanceof BigInt) {
                BigInt bigInt = (BigInt)leftNodeValue;
                if (rightNodeValue instanceof BigInt) {
                    BigInt rightNodeValue_5 = (BigInt)rightNodeValue;
                    this.state_ = state |= 8L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSIdenticalNode.doBigInt(bigInt, rightNodeValue_5);
                    return bl;
                }
                int doubleCast1 = JSTypesGen.specializeImplicitDouble(rightNodeValue);
                if (doubleCast1 != 0) {
                    double rightNodeValue_6 = JSTypesGen.asImplicitDouble(doubleCast1, rightNodeValue);
                    state |= (long)doubleCast1 << 29;
                    this.state_ = state |= 0x10L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSIdenticalNode.doBigIntDouble(bigInt, rightNodeValue_6);
                    return bl;
                }
            }
            if ((n2 = JSTypesGen.specializeImplicitDouble(leftNodeValue)) != 0) {
                double leftNodeValue_4 = JSTypesGen.asImplicitDouble(n2, leftNodeValue);
                if (rightNodeValue instanceof BigInt) {
                    BigInt rightNodeValue_72 = (BigInt)rightNodeValue;
                    state |= (long)n2 << 25;
                    this.state_ = state |= 0x20L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSIdenticalNode.doDoubleBigInt(leftNodeValue_4, rightNodeValue_72);
                    return bl;
                }
            }
            if (JSTypes.isDynamicObject(leftNodeValue)) {
                DynamicObject dynamicObject = (DynamicObject)leftNodeValue;
                if (JSTypes.isDynamicObject(rightNodeValue)) {
                    DynamicObject rightNodeValue_8 = (DynamicObject)rightNodeValue;
                    this.state_ = state |= 0x40L;
                    lock.unlock();
                    hasLock = false;
                    boolean rightNodeValue_6 = JSIdenticalNode.doObject(dynamicObject, rightNodeValue_8);
                    return rightNodeValue_6;
                }
            }
            if (rightNodeValue instanceof JSLazyString) {
                JSLazyString jSLazyString = (JSLazyString)rightNodeValue;
                if (leftNodeValue instanceof JSLazyString) {
                    JSLazyString leftNodeValue_6 = (JSLazyString)leftNodeValue;
                    if ((exclude & 1) == 0 && JSGuards.isReferenceEquals(leftNodeValue_6, jSLazyString)) {
                        this.state_ = state |= 0x80L;
                        lock.unlock();
                        hasLock = false;
                        boolean rightNodeValue_6 = JSIdenticalNode.doLazyStringReference(leftNodeValue_6, jSLazyString);
                        return rightNodeValue_6;
                    }
                    LazyStringData s9_ = new LazyStringData();
                    s9_.flattenA_ = ConditionProfile.createBinaryProfile();
                    s9_.flattenB_ = ConditionProfile.createBinaryProfile();
                    s9_.len_ = ConditionProfile.createBinaryProfile();
                    this.lazyString_cache = s9_;
                    this.exclude_ = exclude |= 1;
                    state &= 0xFFFFFFFFFFFFFF7FL;
                    this.state_ = state |= 0x100L;
                    lock.unlock();
                    hasLock = false;
                    rightNodeValue_72 = JSIdenticalNode.doLazyString(leftNodeValue_6, jSLazyString, s9_.flattenA_, s9_.flattenB_, s9_.len_);
                    return rightNodeValue_72;
                }
                int stringCast02 = JSTypesGen.specializeImplicitString(leftNodeValue);
                if (stringCast02 != 0) {
                    String leftNodeValue_7 = JSTypesGen.asImplicitString(stringCast02, leftNodeValue);
                    this.lazyStringLeft_flatten_ = ConditionProfile.createBinaryProfile();
                    this.lazyStringLeft_len_ = ConditionProfile.createBinaryProfile();
                    state |= (long)stringCast02 << 33;
                    this.state_ = state |= 0x200L;
                    lock.unlock();
                    hasLock = false;
                    rightNodeValue_72 = JSIdenticalNode.doLazyStringLeft(leftNodeValue_7, jSLazyString, this.lazyStringLeft_flatten_, this.lazyStringLeft_len_);
                    return rightNodeValue_72;
                }
            }
            if ((n = JSTypesGen.specializeImplicitString(rightNodeValue)) != 0) {
                String rightNodeValue_10 = JSTypesGen.asImplicitString(n, rightNodeValue);
                if (leftNodeValue instanceof JSLazyString) {
                    JSLazyString leftNodeValue_8 = (JSLazyString)leftNodeValue;
                    this.lazyStringRight_flatten_ = ConditionProfile.createBinaryProfile();
                    this.lazyStringRight_len_ = ConditionProfile.createBinaryProfile();
                    state |= (long)n << 37;
                    this.state_ = state |= 0x400L;
                    lock.unlock();
                    hasLock = false;
                    rightNodeValue_72 = JSIdenticalNode.doLazyStringRight(leftNodeValue_8, rightNodeValue_10, this.lazyStringRight_flatten_, this.lazyStringRight_len_);
                    return rightNodeValue_72;
                }
                stringCast0 = JSTypesGen.specializeImplicitString(leftNodeValue);
                if (stringCast0) {
                    String leftNodeValue_9 = JSTypesGen.asImplicitString(stringCast0, leftNodeValue);
                    if ((exclude & 2) == 0 && JSGuards.isReferenceEquals(leftNodeValue_9, rightNodeValue_10)) {
                        state |= (long)stringCast0 << 33;
                        state |= (long)n << 37;
                        this.state_ = state |= 0x800L;
                        lock.unlock();
                        hasLock = false;
                        boolean bl = JSIdenticalNode.doStringIdentity(leftNodeValue_9, rightNodeValue_10);
                        return bl;
                    }
                    this.exclude_ = exclude |= 2;
                    state &= 0xFFFFFFFFFFFFF7FFL;
                    state |= (long)stringCast0 << 33;
                    state |= (long)n << 37;
                    this.state_ = state |= 0x1000L;
                    lock.unlock();
                    hasLock = false;
                    boolean bl = JSIdenticalNode.doString(leftNodeValue_9, rightNodeValue_10);
                    return bl;
                }
            }
            if (leftNodeValue instanceof Symbol) {
                Symbol symbol = (Symbol)leftNodeValue;
                if (rightNodeValue instanceof Symbol) {
                    Symbol rightNodeValue_11 = (Symbol)rightNodeValue;
                    this.state_ = state |= 0x2000L;
                    lock.unlock();
                    hasLock = false;
                    stringCast0 = JSIdenticalNode.doSymbol(symbol, rightNodeValue_11) ? 1 : 0;
                    return stringCast0 != 0;
                }
            }
            if (JSGuards.isBoolean(leftNodeValue) != JSGuards.isBoolean(rightNodeValue)) {
                this.state_ = state |= 0x4000L;
                lock.unlock();
                hasLock = false;
                boolean bl = JSIdenticalNode.doBooleanNotBoolean(leftNodeValue, rightNodeValue);
                return bl;
            }
            if (JSGuards.isSymbol(leftNodeValue) != JSGuards.isSymbol(rightNodeValue)) {
                this.state_ = state |= 0x8000L;
                lock.unlock();
                hasLock = false;
                boolean bl = JSIdenticalNode.doSymbolNotSymbol(leftNodeValue, rightNodeValue);
                return bl;
            }
            if (JSGuards.isJSNull(leftNodeValue) != JSGuards.isJSNull(rightNodeValue)) {
                this.state_ = state |= 0x10000L;
                lock.unlock();
                hasLock = false;
                boolean bl = JSIdenticalNode.doNullNotNull(leftNodeValue, rightNodeValue);
                return bl;
            }
            if (JSGuards.isUndefined(leftNodeValue) != JSGuards.isUndefined(rightNodeValue)) {
                this.state_ = state |= 0x20000L;
                lock.unlock();
                hasLock = false;
                boolean bl = JSIdenticalNode.doUndefinedNotUndefined(leftNodeValue, rightNodeValue);
                return bl;
            }
            if ((exclude & 4) == 0) {
                void var12_24;
                boolean bl = false;
                DifferentTypesCachedData s19_ = this.differentTypesCached_cache;
                if ((state & 0x40000L) != 0L) {
                    while (s19_ != null) {
                        if (leftNodeValue.getClass() == s19_.cachedClassA_ && rightNodeValue.getClass() == s19_.cachedClassB_) {
                            assert (JSIdenticalNode.isNonObjectType(s19_.cachedClassA_) || JSIdenticalNode.isNonObjectType(s19_.cachedClassB_));
                            assert (JSIdenticalNode.differentNonObjectTypes(s19_.cachedClassA_, s19_.cachedClassB_));
                            break;
                        }
                        s19_ = s19_.next_;
                        ++var12_24;
                    }
                }
                if (s19_ == null) {
                    Class<?> cachedClassA__ = leftNodeValue.getClass();
                    if (leftNodeValue.getClass() == cachedClassA__) {
                        Class<?> cachedClassB__ = rightNodeValue.getClass();
                        if (rightNodeValue.getClass() == cachedClassB__ && (JSIdenticalNode.isNonObjectType(cachedClassA__) || JSIdenticalNode.isNonObjectType(cachedClassB__)) && JSIdenticalNode.differentNonObjectTypes(cachedClassA__, cachedClassB__) && var12_24 < 3) {
                            s19_ = new DifferentTypesCachedData(this.differentTypesCached_cache);
                            s19_.cachedClassA_ = cachedClassA__;
                            s19_.cachedClassB_ = cachedClassB__;
                            this.differentTypesCached_cache = s19_;
                            this.state_ = state |= 0x40000L;
                        }
                    }
                }
                if (s19_ != null) {
                    lock.unlock();
                    hasLock = false;
                    boolean cachedClassA__ = JSIdenticalNode.doDifferentTypesCached(leftNodeValue, rightNodeValue, s19_.cachedClassA_, s19_.cachedClassB_);
                    return cachedClassA__;
                }
            }
            if (JSRuntime.isJavaNumber(leftNodeValue) != JSRuntime.isJavaNumber(rightNodeValue)) {
                this.exclude_ = exclude |= 4;
                this.differentTypesCached_cache = null;
                state &= 0xFFFFFFFFFFFBFFFFL;
                this.state_ = state |= 0x80000L;
                lock.unlock();
                hasLock = false;
                boolean bl = JSIdenticalNode.doNumberNotNumber(leftNodeValue, rightNodeValue);
                return bl;
            }
            if (JSRuntime.isString(leftNodeValue) != JSRuntime.isString(rightNodeValue)) {
                this.exclude_ = exclude |= 4;
                this.differentTypesCached_cache = null;
                state &= 0xFFFFFFFFFFFBFFFFL;
                this.state_ = state |= 0x100000L;
                lock.unlock();
                hasLock = false;
                boolean bl = JSIdenticalNode.doStringNotString(leftNodeValue, rightNodeValue);
                return bl;
            }
            if ((exclude & 8) == 0) {
                Class<? extends Number> cachedClassB__;
                Class<? extends Number> cachedClassA__;
                void var12_28;
                boolean bl = false;
                NumberCachedData s22_ = this.numberCached_cache;
                if ((state & 0x200000L) != 0L) {
                    while (s22_ != null) {
                        assert (s22_.cachedClassA_ != null);
                        assert (s22_.cachedClassB_ != null);
                        if (leftNodeValue.getClass() == s22_.cachedClassA_ && rightNodeValue.getClass() == s22_.cachedClassB_) break;
                        s22_ = s22_.next_;
                        ++var12_28;
                    }
                }
                if (s22_ == null && (cachedClassA__ = JSGuards.getJavaNumberClass(leftNodeValue)) != null && (cachedClassB__ = JSGuards.getJavaNumberClass(rightNodeValue)) != null && leftNodeValue.getClass() == cachedClassA__ && rightNodeValue.getClass() == cachedClassB__ && var12_28 < 3) {
                    s22_ = new NumberCachedData(this.numberCached_cache);
                    s22_.cachedClassA_ = cachedClassA__;
                    s22_.cachedClassB_ = cachedClassB__;
                    this.numberCached_cache = s22_;
                    this.state_ = state |= 0x200000L;
                }
                if (s22_ != null) {
                    lock.unlock();
                    hasLock = false;
                    boolean bl3 = this.doNumberCached(leftNodeValue, rightNodeValue, s22_.cachedClassA_, s22_.cachedClassB_);
                    return bl3;
                }
            }
            if (leftNodeValue instanceof Number) {
                Number number = (Number)leftNodeValue;
                if (rightNodeValue instanceof Number) {
                    Number rightNodeValue_12 = (Number)rightNodeValue;
                    if (JSRuntime.isJavaNumber(number) && JSRuntime.isJavaNumber(rightNodeValue_12)) {
                        this.exclude_ = exclude |= 8;
                        this.numberCached_cache = null;
                        state &= 0xFFFFFFFFFFDFFFFFL;
                        this.state_ = state |= 0x400000L;
                        lock.unlock();
                        hasLock = false;
                        boolean bl = this.doNumber(number, rightNodeValue_12);
                        return bl;
                    }
                }
            }
            if (leftNodeValue instanceof TruffleObject) {
                TruffleObject truffleObject = (TruffleObject)leftNodeValue;
                if (rightNodeValue instanceof TruffleObject) {
                    TruffleObject rightNodeValue_13 = (TruffleObject)rightNodeValue;
                    if (JSGuards.isTruffleJavaObject(truffleObject) && JSGuards.isTruffleJavaObject(rightNodeValue_13)) {
                        this.state_ = state |= 0x800000L;
                        lock.unlock();
                        hasLock = false;
                        boolean bl = JSIdenticalNode.doTruffleJavaObjects(truffleObject, rightNodeValue_13);
                        return bl;
                    }
                }
            }
            this.state_ = state |= 0x1000000L;
            lock.unlock();
            hasLock = false;
            boolean bl = JSIdenticalNode.doFallback(leftNodeValue, rightNodeValue);
            return bl;
        }
        finally {
            if (oldState != 0L || oldExclude != 0) {
                this.checkForPolymorphicSpecialize(oldState, oldExclude, oldCacheCount);
            }
            if (hasLock) {
                lock.unlock();
            }
        }
    }

    private void checkForPolymorphicSpecialize(long oldState, int oldExclude, int oldCacheCount) {
        long newState = this.state_ & 0x1FFFFFFL;
        int newExclude = this.exclude_;
        if ((oldState ^ newState) != 0L || (oldExclude ^ newExclude) != 0 || oldCacheCount < this.countCaches()) {
            this.reportPolymorphicSpecialize();
        }
    }

    private int countCaches() {
        int cacheCount = 0;
        DifferentTypesCachedData s19_ = this.differentTypesCached_cache;
        while (s19_ != null) {
            ++cacheCount;
            s19_ = s19_.next_;
        }
        NumberCachedData s22_ = this.numberCached_cache;
        while (s22_ != null) {
            ++cacheCount;
            s22_ = s22_.next_;
        }
        return cacheCount;
    }

    public NodeCost getCost() {
        long state = this.state_;
        if ((state & 0x1FFFFFFL) == 0L) {
            return NodeCost.UNINITIALIZED;
        }
        if ((state & 0x1FFFFFFL & (state & 0x1FFFFFFL) - 1L) == 0L) {
            DifferentTypesCachedData s19_ = this.differentTypesCached_cache;
            NumberCachedData s22_ = this.numberCached_cache;
            if (!(s19_ != null && s19_.next_ != null || s22_ != null && s22_.next_ != null)) {
                return NodeCost.MONOMORPHIC;
            }
        }
        return NodeCost.POLYMORPHIC;
    }

    public Introspection getIntrospectionData() {
        ArrayList<List<Object>> cached;
        Object[] data = new Object[26];
        data[0] = 0;
        long state = this.state_;
        int exclude = this.exclude_;
        Object[] s = new Object[3];
        s[0] = "doInt";
        s[1] = (state & 1L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[1] = s;
        s = new Object[3];
        s[0] = "doDouble";
        s[1] = (state & 2L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[2] = s;
        s = new Object[3];
        s[0] = "doBoolean";
        s[1] = (state & 4L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[3] = s;
        s = new Object[3];
        s[0] = "doBigInt";
        s[1] = (state & 8L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[4] = s;
        s = new Object[3];
        s[0] = "doBigIntDouble";
        s[1] = (state & 0x10L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[5] = s;
        s = new Object[3];
        s[0] = "doDoubleBigInt";
        s[1] = (state & 0x20L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[6] = s;
        s = new Object[3];
        s[0] = "doObject";
        s[1] = (state & 0x40L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[7] = s;
        s = new Object[3];
        s[0] = "doLazyStringReference";
        s[1] = (state & 0x80L) != 0L ? Byte.valueOf((byte)1) : ((exclude & 1) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[8] = s;
        s = new Object[3];
        s[0] = "doLazyString";
        if ((state & 0x100L) != 0L) {
            s[1] = (byte)1;
            cached = new ArrayList<List<Object>>();
            LazyStringData s9_ = this.lazyString_cache;
            if (s9_ != null) {
                cached.add(Arrays.asList(s9_.flattenA_, s9_.flattenB_, s9_.len_));
            }
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[9] = s;
        s = new Object[3];
        s[0] = "doLazyStringLeft";
        if ((state & 0x200L) != 0L) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.lazyStringLeft_flatten_, this.lazyStringLeft_len_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[10] = s;
        s = new Object[3];
        s[0] = "doLazyStringRight";
        if ((state & 0x400L) != 0L) {
            s[1] = (byte)1;
            cached = new ArrayList();
            cached.add(Arrays.asList(this.lazyStringRight_flatten_, this.lazyStringRight_len_));
            s[2] = cached;
        } else {
            s[1] = (byte)0;
        }
        data[11] = s;
        s = new Object[3];
        s[0] = "doStringIdentity";
        s[1] = (state & 0x800L) != 0L ? Byte.valueOf((byte)1) : ((exclude & 2) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0));
        data[12] = s;
        s = new Object[3];
        s[0] = "doString";
        s[1] = (state & 0x1000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[13] = s;
        s = new Object[3];
        s[0] = "doSymbol";
        s[1] = (state & 0x2000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[14] = s;
        s = new Object[3];
        s[0] = "doBooleanNotBoolean";
        s[1] = (state & 0x4000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[15] = s;
        s = new Object[3];
        s[0] = "doSymbolNotSymbol";
        s[1] = (state & 0x8000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[16] = s;
        s = new Object[3];
        s[0] = "doNullNotNull";
        s[1] = (state & 0x10000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[17] = s;
        s = new Object[3];
        s[0] = "doUndefinedNotUndefined";
        s[1] = (state & 0x20000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[18] = s;
        s = new Object[3];
        s[0] = "doDifferentTypesCached";
        if ((state & 0x40000L) != 0L) {
            s[1] = (byte)1;
            cached = new ArrayList();
            DifferentTypesCachedData s19_ = this.differentTypesCached_cache;
            while (s19_ != null) {
                cached.add(Arrays.asList(s19_.cachedClassA_, s19_.cachedClassB_));
                s19_ = s19_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 4) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[19] = s;
        s = new Object[3];
        s[0] = "doNumberNotNumber";
        s[1] = (state & 0x80000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[20] = s;
        s = new Object[3];
        s[0] = "doStringNotString";
        s[1] = (state & 0x100000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[21] = s;
        s = new Object[3];
        s[0] = "doNumberCached";
        if ((state & 0x200000L) != 0L) {
            s[1] = (byte)1;
            cached = new ArrayList();
            NumberCachedData s22_ = this.numberCached_cache;
            while (s22_ != null) {
                cached.add(Arrays.asList(s22_.cachedClassA_, s22_.cachedClassB_));
                s22_ = s22_.next_;
            }
            s[2] = cached;
        } else {
            s[1] = (exclude & 8) != 0 ? Byte.valueOf((byte)2) : Byte.valueOf((byte)0);
        }
        data[22] = s;
        s = new Object[3];
        s[0] = "doNumber";
        s[1] = (state & 0x400000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[23] = s;
        s = new Object[3];
        s[0] = "doTruffleJavaObjects";
        s[1] = (state & 0x800000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[24] = s;
        s = new Object[3];
        s[0] = "doFallback";
        s[1] = (state & 0x1000000L) != 0L ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        data[25] = s;
        return Introspection.Provider.create((Object[])data);
    }

    private static boolean fallbackGuard_(long state, Object leftNodeValue, Object rightNodeValue) {
        Number rightNodeValue_;
        Number leftNodeValue_;
        if (JSTypesGen.isImplicitDouble(leftNodeValue) && JSTypesGen.isImplicitDouble(rightNodeValue)) {
            return false;
        }
        if ((state & 4L) == 0L && leftNodeValue instanceof Boolean && rightNodeValue instanceof Boolean) {
            return false;
        }
        if (leftNodeValue instanceof BigInt) {
            if ((state & 8L) == 0L && rightNodeValue instanceof BigInt) {
                return false;
            }
            if (JSTypesGen.isImplicitDouble(rightNodeValue)) {
                return false;
            }
        }
        if (JSTypesGen.isImplicitDouble(leftNodeValue) && rightNodeValue instanceof BigInt) {
            return false;
        }
        if ((state & 0x40L) == 0L && JSTypes.isDynamicObject(leftNodeValue) && JSTypes.isDynamicObject(rightNodeValue)) {
            return false;
        }
        if (JSTypesGen.isImplicitString(leftNodeValue) && JSTypesGen.isImplicitString(rightNodeValue)) {
            return false;
        }
        if ((state & 0x2000L) == 0L && leftNodeValue instanceof Symbol && rightNodeValue instanceof Symbol) {
            return false;
        }
        if ((state & 0x4000L) == 0L && JSGuards.isBoolean(leftNodeValue) != JSGuards.isBoolean(rightNodeValue)) {
            return false;
        }
        if ((state & 0x8000L) == 0L && JSGuards.isSymbol(leftNodeValue) != JSGuards.isSymbol(rightNodeValue)) {
            return false;
        }
        if ((state & 0x10000L) == 0L && JSGuards.isJSNull(leftNodeValue) != JSGuards.isJSNull(rightNodeValue)) {
            return false;
        }
        if ((state & 0x20000L) == 0L && JSGuards.isUndefined(leftNodeValue) != JSGuards.isUndefined(rightNodeValue)) {
            return false;
        }
        if ((state & 0x80000L) == 0L && JSRuntime.isJavaNumber(leftNodeValue) != JSRuntime.isJavaNumber(rightNodeValue)) {
            return false;
        }
        if ((state & 0x100000L) == 0L && JSRuntime.isString(leftNodeValue) != JSRuntime.isString(rightNodeValue)) {
            return false;
        }
        if (leftNodeValue instanceof Number && rightNodeValue instanceof Number && JSRuntime.isJavaNumber(leftNodeValue_ = (Number)leftNodeValue) && JSRuntime.isJavaNumber(rightNodeValue_ = (Number)rightNodeValue)) {
            return false;
        }
        return !(leftNodeValue instanceof TruffleObject) || !(rightNodeValue instanceof TruffleObject) || !JSGuards.isTruffleJavaObject((TruffleObject)(leftNodeValue_ = (TruffleObject)leftNodeValue)) || !JSGuards.isTruffleJavaObject((TruffleObject)(rightNodeValue_ = (TruffleObject)rightNodeValue));
    }

    public static JSIdenticalNode create(JavaScriptNode left, JavaScriptNode right, int type) {
        return new JSIdenticalNodeGen(left, right, type);
    }

    @GeneratedBy(value=JSIdenticalNode.class)
    private static final class NumberCachedData {
        @CompilerDirectives.CompilationFinal
        NumberCachedData next_;
        @CompilerDirectives.CompilationFinal
        Class<?> cachedClassA_;
        @CompilerDirectives.CompilationFinal
        Class<?> cachedClassB_;

        NumberCachedData(NumberCachedData next_) {
            this.next_ = next_;
        }
    }

    @GeneratedBy(value=JSIdenticalNode.class)
    private static final class DifferentTypesCachedData {
        @CompilerDirectives.CompilationFinal
        DifferentTypesCachedData next_;
        @CompilerDirectives.CompilationFinal
        Class<?> cachedClassA_;
        @CompilerDirectives.CompilationFinal
        Class<?> cachedClassB_;

        DifferentTypesCachedData(DifferentTypesCachedData next_) {
            this.next_ = next_;
        }
    }

    @GeneratedBy(value=JSIdenticalNode.class)
    private static final class LazyStringData {
        @CompilerDirectives.CompilationFinal
        ConditionProfile flattenA_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile flattenB_;
        @CompilerDirectives.CompilationFinal
        ConditionProfile len_;

        LazyStringData() {
        }
    }
}

