/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.FrameSlotNode;
import com.oracle.truffle.js.nodes.access.ScopeFrameNode;
import com.oracle.truffle.js.runtime.JSFrameUtil;

public final class TemporalDeadZoneCheckNode
extends FrameSlotNode {
    @Node.Child
    private JavaScriptNode child;
    @Node.Child
    private ScopeFrameNode levelFrameNode;
    private final BranchProfile deadBranch = BranchProfile.create();

    private TemporalDeadZoneCheckNode(FrameSlot frameSlot, ScopeFrameNode levelFrameNode, JavaScriptNode child) {
        super(frameSlot);
        this.levelFrameNode = levelFrameNode;
        this.child = child;
        assert (JSFrameUtil.hasTemporalDeadZone(frameSlot));
    }

    private void checkNotDead(VirtualFrame frame) {
        Frame levelFrame = this.levelFrameNode.executeFrame((Frame)frame);
        if (levelFrame.isObject(this.frameSlot)) {
            this.checkNotDead(super.getObject(levelFrame), this.deadBranch);
        }
    }

    @Override
    public Object execute(VirtualFrame frame) {
        this.checkNotDead(frame);
        return this.child.execute(frame);
    }

    @Override
    public int executeInt(VirtualFrame frame) throws UnexpectedResultException {
        this.checkNotDead(frame);
        return this.child.executeInt(frame);
    }

    @Override
    public double executeDouble(VirtualFrame frame) throws UnexpectedResultException {
        this.checkNotDead(frame);
        return this.child.executeDouble(frame);
    }

    @Override
    public boolean executeBoolean(VirtualFrame frame) throws UnexpectedResultException {
        this.checkNotDead(frame);
        return this.child.executeBoolean(frame);
    }

    @Override
    public ScopeFrameNode getLevelFrameNode() {
        return this.levelFrameNode;
    }

    @Override
    public boolean hasTemporalDeadZone() {
        return true;
    }

    public static TemporalDeadZoneCheckNode create(FrameSlot frameSlot, ScopeFrameNode levelFrameNode, JavaScriptNode rhs) {
        return new TemporalDeadZoneCheckNode(frameSlot, levelFrameNode, rhs);
    }

    @Override
    protected JavaScriptNode copyUninitialized() {
        return new TemporalDeadZoneCheckNode(this.frameSlot, (ScopeFrameNode)NodeUtil.cloneNode((Node)this.levelFrameNode), TemporalDeadZoneCheckNode.cloneUninitialized(this.child));
    }
}

