/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.TransferHandler;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.html.editor.APIAccessor;
import org.netbeans.modules.html.editor.api.HtmlKit;

public class HtmlTransferHandler
extends TransferHandler
implements UIResource {
    private final TransferHandler delegate;

    public static void install(JTextComponent c) {
        TransferHandler origHandler = c.getTransferHandler();
        if (!(origHandler instanceof HtmlTransferHandler)) {
            c.setTransferHandler(new HtmlTransferHandler(c.getTransferHandler()));
        }
    }

    public HtmlTransferHandler(TransferHandler delegate) {
        this.delegate = delegate;
    }

    TransferHandler getDelegate() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (support.getComponent() instanceof JEditorPane && ((JEditorPane)support.getComponent()).getEditorKit() instanceof HtmlKit) {
            HtmlKit kit = (HtmlKit)((Object)((JEditorPane)support.getComponent()).getEditorKit());
            APIAccessor.DEFAULT.setContentType(kit, "text/plain");
            try {
                boolean bl = this.delegate.canImport(support);
                return bl;
            }
            finally {
                APIAccessor.DEFAULT.setContentType(kit, "text/html");
            }
        }
        return this.delegate.canImport(support);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (support.getComponent() instanceof JEditorPane && ((JEditorPane)support.getComponent()).getEditorKit() instanceof HtmlKit) {
            HtmlKit kit = (HtmlKit)((Object)((JEditorPane)support.getComponent()).getEditorKit());
            APIAccessor.DEFAULT.setContentType(kit, "text/plain");
            try {
                boolean bl = this.delegate.importData(support);
                return bl;
            }
            finally {
                APIAccessor.DEFAULT.setContentType(kit, "text/html");
            }
        }
        return this.delegate.importData(support);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canImport(JComponent comp, DataFlavor[] t) {
        if (comp instanceof JEditorPane && ((JEditorPane)comp).getEditorKit() instanceof HtmlKit) {
            HtmlKit kit = (HtmlKit)((Object)((JEditorPane)comp).getEditorKit());
            APIAccessor.DEFAULT.setContentType(kit, "text/plain");
            try {
                boolean bl = this.delegate.canImport(comp, t);
                return bl;
            }
            finally {
                APIAccessor.DEFAULT.setContentType(kit, "text/html");
            }
        }
        return this.delegate.canImport(comp, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean importData(JComponent comp, Transferable t) {
        if (comp instanceof JEditorPane && ((JEditorPane)comp).getEditorKit() instanceof HtmlKit) {
            HtmlKit kit = (HtmlKit)((Object)((JEditorPane)comp).getEditorKit());
            APIAccessor.DEFAULT.setContentType(kit, "text/plain");
            try {
                boolean bl = this.delegate.importData(comp, t);
                return bl;
            }
            finally {
                APIAccessor.DEFAULT.setContentType(kit, "text/html");
            }
        }
        return this.delegate.importData(comp, t);
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        try {
            Method method = this.delegate.getClass().getDeclaredMethod("createTransferable", JComponent.class);
            method.setAccessible(true);
            return (Transferable)method.invoke((Object)this.delegate, c);
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    @Override
    public void exportAsDrag(JComponent comp, InputEvent e, int action) {
        this.delegate.exportAsDrag(comp, e, action);
    }

    @Override
    protected void exportDone(JComponent source, Transferable data, int action) {
        try {
            Method method = this.delegate.getClass().getDeclaredMethod("exportDone", JComponent.class, Transferable.class, Integer.TYPE);
            method.setAccessible(true);
            method.invoke((Object)this.delegate, source, data, new Integer(action));
        }
        catch (NoSuchMethodException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        catch (InvocationTargetException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void exportToClipboard(JComponent c, Clipboard clip, int action) throws IllegalStateException {
        this.delegate.exportToClipboard(c, clip, action);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return this.delegate.getSourceActions(c);
    }

    @Override
    public Icon getVisualRepresentation(Transferable t) {
        return this.delegate.getVisualRepresentation(t);
    }
}

