/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.js;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.Properties;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.Exceptions;

public class StepThroughFiltersCheck
extends LazyActionsManagerListener
implements PropertyChangeListener {
    private static final String STEP_THROUGH_FILTERS_PROP = "StepThroughFilters";
    private final JPDADebugger debugger;
    private final Properties p;
    private boolean stepThroughFiltersWasNotSet;
    private boolean stepThroughFiltersTurnedOn;

    public StepThroughFiltersCheck(ContextProvider lookupProvider) {
        this.debugger = (JPDADebugger)lookupProvider.lookupFirst(null, JPDADebugger.class);
        this.debugger.addPropertyChangeListener("state", (PropertyChangeListener)this);
        this.p = Properties.getDefault().getProperties("debugger.options.JPDA");
    }

    public String[] getProperties() {
        return new String[]{"actionToBeRun"};
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object nv;
        if ("actionToBeRun".equals(evt.getPropertyName())) {
            Object action = evt.getNewValue();
            if (ActionsManager.ACTION_STEP_INTO.equals(action)) {
                boolean stepThroughFilters = this.p.getBoolean(STEP_THROUGH_FILTERS_PROP, false);
                boolean bl = this.stepThroughFiltersWasNotSet = !stepThroughFilters && this.p.getBoolean(STEP_THROUGH_FILTERS_PROP, true);
                if (!stepThroughFilters) {
                    this.p.setBoolean(STEP_THROUGH_FILTERS_PROP, true);
                    this.stepThroughFiltersTurnedOn = true;
                }
            }
        } else if ("state".equals(evt.getPropertyName()) && (nv = evt.getNewValue()) instanceof Integer && 3 == (Integer)nv) {
            this.unsetStepThrough();
        }
    }

    protected void destroy() {
        this.debugger.removePropertyChangeListener("suspend", (PropertyChangeListener)this);
        this.unsetStepThrough();
    }

    private void unsetStepThrough() {
        if (this.stepThroughFiltersTurnedOn) {
            if (this.stepThroughFiltersWasNotSet) {
                try {
                    Method unsetMethod = this.p.getClass().getDeclaredMethod("unset", String.class);
                    unsetMethod.setAccessible(true);
                    unsetMethod.invoke((Object)this.p, STEP_THROUGH_FILTERS_PROP);
                }
                catch (Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } else {
                this.p.setBoolean(STEP_THROUGH_FILTERS_PROP, false);
            }
            this.stepThroughFiltersTurnedOn = false;
        }
    }
}

