/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsps.parserapi;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.JspException;
import org.netbeans.modules.web.jsps.parserapi.Node;
import org.xml.sax.Attributes;

class DumpVisitor
extends Node.Visitor {
    private static final Logger LOGGER = Logger.getLogger(DumpVisitor.class.getName());
    private int indent = 0;
    private StringBuilder buf = new StringBuilder();

    private DumpVisitor() {
    }

    protected void visitCommon(Node n) throws JspException {
        this.printString("\nNode [" + n.getStart() + ", " + this.getDisplayClassName(n.getClass().getName()) + "] ");
    }

    private String getDisplayClassName(String cn) {
        int amp = cn.indexOf(36);
        return cn.substring(amp + 1);
    }

    private String getAttributes(Attributes attrs) {
        if (attrs == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < attrs.getLength(); ++i) {
            buffer.append(" ");
            buffer.append(attrs.getQName(i));
            buffer.append("=\"");
            buffer.append(attrs.getValue(i));
            buffer.append("\"");
        }
        return buffer.toString();
    }

    private void printString(String str) {
        this.printIndent();
        this.buf.append(str);
    }

    private void printString(String prefix, String str, String suffix) {
        this.printIndent();
        if (str != null) {
            this.buf.append(prefix);
            this.buf.append(str);
            this.buf.append(suffix);
        } else {
            this.buf.append(prefix);
            this.buf.append(suffix);
        }
    }

    private void printAttributes(String prefix, Attributes attrs, String suffix) {
        this.printString(prefix, this.getAttributes(attrs), suffix);
    }

    private void dumpBody(Node n) throws JspException {
        Node.Nodes page = n.getBody();
        if (page != null) {
            ++this.indent;
            page.visit(this);
            --this.indent;
        }
    }

    @Override
    public void visit(Node.TagDirective n) throws JspException {
        this.visitCommon(n);
        this.printAttributes("<%@ tag", n.getAttributes(), "%>");
    }

    @Override
    public void visit(Node.PageDirective n) throws JspException {
        this.visitCommon(n);
        this.printAttributes("<%@ page", n.getAttributes(), "%>");
    }

    @Override
    public void visit(Node.TaglibDirective n) throws JspException {
        this.visitCommon(n);
        this.printAttributes("<%@ taglib", n.getAttributes(), "%>");
    }

    @Override
    public void visit(Node.IncludeDirective n) throws JspException {
        this.visitCommon(n);
        this.printAttributes("<%@ include", n.getAttributes(), "%>");
        this.dumpBody(n);
    }

    @Override
    public void visit(Node.Comment n) throws JspException {
        this.visitCommon(n);
        this.printString("<%--", n.getText(), "--%>");
    }

    @Override
    public void visit(Node.Declaration n) throws JspException {
        this.visitCommon(n);
        this.printString("<%!", n.getText(), "%>");
    }

    @Override
    public void visit(Node.Expression n) throws JspException {
        this.visitCommon(n);
        this.printString("<%=", n.getText(), "%>");
    }

    @Override
    public void visit(Node.Scriptlet n) throws JspException {
        this.visitCommon(n);
        this.printString("<%", n.getText(), "%>");
    }

    @Override
    public void visit(Node.IncludeAction n) throws JspException {
        this.visitCommon(n);
        this.printAttributes("<jsp:include", n.getAttributes(), ">");
        this.dumpBody(n);
        this.printString("</jsp:include>");
    }

    @Override
    public void visit(Node.ForwardAction n) throws JspException {
        this.visitCommon(n);
        this.printAttributes("<jsp:forward", n.getAttributes(), ">");
        this.dumpBody(n);
        this.printString("</jsp:forward>");
    }

    @Override
    public void visit(Node.GetProperty n) throws JspException {
        this.visitCommon(n);
        this.printAttributes("<jsp:getProperty", n.getAttributes(), "/>");
    }

    @Override
    public void visit(Node.SetProperty n) throws JspException {
        this.visitCommon(n);
        this.printAttributes("<jsp:setProperty", n.getAttributes(), ">");
        this.dumpBody(n);
        this.printString("</jsp:setProperty>");
    }

    @Override
    public void visit(Node.UseBean n) throws JspException {
        this.visitCommon(n);
        this.printAttributes("<jsp:useBean", n.getAttributes(), ">");
        this.dumpBody(n);
        this.printString("</jsp:useBean>");
    }

    @Override
    public void visit(Node.PlugIn n) throws JspException {
        this.visitCommon(n);
        this.printAttributes("<jsp:plugin", n.getAttributes(), ">");
        this.dumpBody(n);
        this.printString("</jsp:plugin>");
    }

    @Override
    public void visit(Node.ParamsAction n) throws JspException {
        this.visitCommon(n);
        this.printAttributes("<jsp:params", n.getAttributes(), ">");
        this.dumpBody(n);
        this.printString("</jsp:params>");
    }

    @Override
    public void visit(Node.ParamAction n) throws JspException {
        this.visitCommon(n);
        this.printAttributes("<jsp:param", n.getAttributes(), ">");
        this.dumpBody(n);
        this.printString("</jsp:param>");
    }

    @Override
    public void visit(Node.NamedAttribute n) throws JspException {
        this.visitCommon(n);
        this.printAttributes("<jsp:attribute", n.getAttributes(), ">");
        this.dumpBody(n);
        this.printString("</jsp:attribute>");
    }

    @Override
    public void visit(Node.JspBody n) throws JspException {
        this.visitCommon(n);
        this.printAttributes("<jsp:body", n.getAttributes(), ">");
        this.dumpBody(n);
        this.printString("</jsp:body>");
    }

    @Override
    public void visit(Node.ELExpression n) throws JspException {
        this.visitCommon(n);
        this.printString(n.getText());
    }

    @Override
    public void visit(Node.CustomTag n) throws JspException {
        this.visitCommon(n);
        this.printAttributes("<" + n.getQName(), n.getAttributes(), ">");
        this.dumpBody(n);
        this.printString("</" + n.getQName() + ">");
    }

    @Override
    public void visit(Node.UninterpretedTag n) throws JspException {
        this.visitCommon(n);
        String tag = n.getQName();
        this.printAttributes("<" + tag, n.getAttributes(), ">");
        this.dumpBody(n);
        this.printString("</" + tag + ">");
    }

    @Override
    public void visit(Node.InvokeAction n) throws JspException {
        this.visitCommon(n);
        this.printAttributes("<jsp:invoke", n.getAttributes(), ">");
        this.dumpBody(n);
        this.printString("</jsp:invoke>");
    }

    @Override
    public void visit(Node.DoBodyAction n) throws JspException {
        this.visitCommon(n);
        this.printAttributes("<jsp:doBody", n.getAttributes(), ">");
        this.dumpBody(n);
        this.printString("</jsp:doBody>");
    }

    @Override
    public void visit(Node.TemplateText n) throws JspException {
        this.visitCommon(n);
        this.printString(new String(n.getText()));
    }

    private void printIndent() {
        for (int i = 0; i < this.indent; ++i) {
            this.buf.append("  ");
        }
    }

    private String getString() {
        return this.buf.toString();
    }

    public static String dump(Node n) {
        try {
            DumpVisitor dv = new DumpVisitor();
            n.accept(dv);
            return dv.getString();
        }
        catch (JspException e) {
            LOGGER.log(Level.INFO, null, e);
            return e.getMessage();
        }
    }

    public static String dump(Node.Nodes page) {
        try {
            DumpVisitor dv = new DumpVisitor();
            page.visit(dv);
            return dv.getString();
        }
        catch (JspException e) {
            LOGGER.log(Level.INFO, null, e);
            return e.getMessage();
        }
    }
}

