/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.php.api.phpmodule.PhpModule;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.PhpProjectValidator;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.actions.tests.SelectFilePanel;
import org.netbeans.modules.php.project.util.PhpProjectUtils;
import org.netbeans.modules.php.spi.testing.PhpTestingProvider;
import org.netbeans.modules.php.spi.testing.locate.Locations;
import org.netbeans.spi.gototest.TestLocator;
import org.openide.filesystems.FileObject;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class GoToTest
implements TestLocator {
    private static final Logger LOGGER = Logger.getLogger(GoToTest.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(GoToTest.class.getName(), 2);
    static final Comparator<FileObject> FILE_OBJECT_COMAPARTOR = new FileObjectComparator();

    public boolean appliesTo(FileObject fo) {
        return FileUtils.isPhpFile((FileObject)fo);
    }

    public boolean asynchronous() {
        return true;
    }

    public void findOpposite(final FileObject fo, int caretOffset, final TestLocator.LocationListener callback) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                callback.foundLocation(fo, GoToTest.this.findOpposite0(fo));
            }
        });
    }

    public TestLocator.LocationResult findOpposite(FileObject fo, int caretOffset) {
        throw new UnsupportedOperationException("Go To Test is asynchronous");
    }

    private TestLocator.LocationResult findOpposite0(FileObject fo) {
        PhpProject project = PhpProjectUtils.getPhpProject(fo);
        if (project == null) {
            LOGGER.log(Level.INFO, "PHP project was not found for file {0}", fo);
            return null;
        }
        if (PhpProjectValidator.isFatallyBroken(project)) {
            UiUtils.warnBrokenProject((PhpModule)project.getPhpModule());
            return null;
        }
        if (CommandUtils.isUnderTests(project, fo, false)) {
            return this.findSource(project, fo);
        }
        if (CommandUtils.isUnderSources(project, fo)) {
            return GoToTest.findTest(project, fo);
        }
        return null;
    }

    public TestLocator.FileType getFileType(FileObject fo) {
        PhpProject project = PhpProjectUtils.getPhpProject(fo);
        if (project == null || PhpProjectValidator.isFatallyBroken(project)) {
            LOGGER.log(Level.INFO, "PHP project was not found for file {0}", fo);
            return TestLocator.FileType.NEITHER;
        }
        if (CommandUtils.isUnderTests(project, fo, false)) {
            List<PhpTestingProvider> testingProviders = project.getTestingProviders();
            if (testingProviders.isEmpty()) {
                return TestLocator.FileType.TEST;
            }
            PhpModule phpModule = project.getPhpModule();
            for (PhpTestingProvider testingProvider : testingProviders) {
                if (!testingProvider.isTestFile(phpModule, fo)) continue;
                return TestLocator.FileType.TEST;
            }
        } else if (CommandUtils.isUnderSources(project, fo)) {
            return TestLocator.FileType.TESTED;
        }
        return TestLocator.FileType.NEITHER;
    }

    private TestLocator.LocationResult findSource(PhpProject project, FileObject testFo) {
        return GoToTest.findFile(project, testFo, false);
    }

    public static TestLocator.LocationResult findTest(PhpProject project, FileObject srcFo) {
        return GoToTest.findFile(project, srcFo, true);
    }

    private static TestLocator.LocationResult findFile(PhpProject project, FileObject file, boolean searchTest) {
        List<FileObject> sourceRoots;
        List<FileObject> list = sourceRoots = searchTest ? GoToTest.getTests(project) : GoToTest.getSources(project);
        if (sourceRoots.isEmpty()) {
            return null;
        }
        List<PhpTestingProvider> testingProviders = project.getTestingProviders();
        if (testingProviders.isEmpty()) {
            PhpProjectUtils.openCustomizer(project, "Testing");
            return null;
        }
        HashMap<FileObject, Locations.Offset> phpFiles = new HashMap<FileObject, Locations.Offset>();
        PhpModule phpModule = project.getPhpModule();
        for (PhpTestingProvider phpTestingProvider : testingProviders) {
            org.netbeans.modules.php.spi.testing.locate.TestLocator testLocator = phpTestingProvider.getTestLocator(phpModule);
            Set result = searchTest ? testLocator.findTests(file) : testLocator.findSources(file);
            for (Locations.Offset offset : result) {
                FileObject fo = offset.getFile();
                if (phpFiles.get(fo) != null) continue;
                phpFiles.put(fo, offset);
            }
        }
        if (phpFiles.isEmpty()) {
            return new TestLocator.LocationResult(NbBundle.getMessage(GoToTest.class, (String)(searchTest ? "MSG_TestNotFound" : "MSG_SrcNotFound"), (Object)file.getNameExt()));
        }
        if (phpFiles.size() == 1) {
            Locations.Offset source = (Locations.Offset)phpFiles.values().iterator().next();
            return new TestLocator.LocationResult(source.getFile(), source.getOffset());
        }
        ArrayList<FileObject> files = new ArrayList<FileObject>(phpFiles.size());
        for (Locations.Offset location : phpFiles.values()) {
            files.add(location.getFile());
        }
        files.sort(FILE_OBJECT_COMAPARTOR);
        final CopyOnWriteArrayList<FileObject> copyOnWriteArrayList = new CopyOnWriteArrayList<FileObject>(sourceRoots);
        final CopyOnWriteArrayList filesCopy = new CopyOnWriteArrayList(files);
        FileObject selected = (FileObject)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<FileObject>(){

            public FileObject run() {
                return SelectFilePanel.open(copyOnWriteArrayList, filesCopy);
            }
        });
        if (selected != null) {
            int offset = -1;
            for (Locations.Offset location : phpFiles.values()) {
                if (!selected.equals(location.getFile())) continue;
                offset = location.getOffset();
                break;
            }
            return new TestLocator.LocationResult(selected, offset);
        }
        return null;
    }

    private static List<FileObject> getSources(PhpProject project) {
        FileObject sources = ProjectPropertiesSupport.getSourcesDirectory(project);
        assert (sources != null) : "Project sources must be found for " + project;
        return Collections.singletonList(sources);
    }

    private static List<FileObject> getTests(PhpProject project) {
        return ProjectPropertiesSupport.getTestDirectories(project, false);
    }

    private static class FileObjectComparator
    implements Comparator<FileObject> {
        private FileObjectComparator() {
        }

        @Override
        public int compare(FileObject fo1, FileObject fo2) {
            return fo1.getPath().compareTo(fo2.getPath());
        }
    }
}

