/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.lib;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.netbeans.modules.html.editor.lib.api.ProblemDescription;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementFilter;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.FeaturedNode;
import org.netbeans.modules.html.editor.lib.api.elements.Node;

public class RootNode
implements FeaturedNode {
    private CharSequence source;
    private Collection<Element> children;

    public RootNode(CharSequence source) {
        this(source, new LinkedList<Element>());
    }

    public RootNode(CharSequence source, Collection<Element> children) {
        this.source = source;
        this.children = children;
    }

    @Override
    public Collection<Element> children() {
        return this.children;
    }

    @Override
    public Collection<Element> children(ElementType type) {
        ArrayList<Element> filtered = new ArrayList<Element>();
        for (Element child : this.children()) {
            if (child.type() != type) continue;
            filtered.add(child);
        }
        return filtered;
    }

    @Override
    public Node parent() {
        return null;
    }

    @Override
    public int from() {
        return 0;
    }

    @Override
    public int to() {
        return this.source.length();
    }

    @Override
    public ElementType type() {
        return ElementType.ROOT;
    }

    @Override
    public CharSequence image() {
        return this.source;
    }

    @Override
    public Collection<ProblemDescription> problems() {
        return Collections.emptyList();
    }

    @Override
    public Object getProperty(String propertyName) {
        return null;
    }

    @Override
    public CharSequence id() {
        return this.type().name();
    }

    @Override
    public Collection<Element> children(ElementFilter filter) {
        ArrayList<Element> filtered = new ArrayList<Element>();
        for (Element e : this.children()) {
            if (!filter.accepts(e)) continue;
            filtered.add(e);
        }
        return filtered;
    }

    @Override
    public <T extends Element> Collection<T> children(Class<T> type) {
        ArrayList<T> filtered = new ArrayList<T>();
        for (Element child : this.children()) {
            if (!type.isAssignableFrom(child.getClass())) continue;
            filtered.add(type.cast(child));
        }
        return filtered;
    }
}

