/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cordova.updatetask;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import javax.lang.model.SourceVersion;
import org.netbeans.modules.cordova.updatetask.XMLFile;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SourceConfig
extends XMLFile {
    public static final String ANDROID_PLATFORM = "android";
    public static final String IOS_PLATFORM = "ios";

    public SourceConfig(InputStream resource) throws IOException {
        super(resource);
    }

    public SourceConfig(File f) throws IOException {
        super(f);
    }

    public String getName() {
        return this.getTextContent("/widget/name");
    }

    public void setName(String name) {
        this.setTextContent("/widget/name", name);
    }

    public String getDescription() {
        return this.getTextContent("/widget/description");
    }

    public void setDescription(String description) {
        this.setTextContent("/widget/description", description);
    }

    public String getAuthor() {
        return this.getTextContent("/widget/author");
    }

    public void setAuthor(String author) {
        this.setTextContent("/widget/author", author);
    }

    public String getAuthorHref() {
        return this.getAttributeText("/widget/author", "href");
    }

    public void setAuthorHref(String href) {
        this.setAttributeText("/widget/author", "href", href);
    }

    public String getAuthorEmail() {
        return this.getAttributeText("/widget/author", "email");
    }

    public void setAuthorEmail(String email) {
        this.setAttributeText("/widget/author", "email", email);
    }

    public String getId() {
        return this.getAttributeText("/widget", "id");
    }

    public String getVersion() {
        return this.getAttributeText("/widget", "version");
    }

    public String getAccess() {
        return this.getAttributeText("/widget/access", "origin");
    }

    public void setAccess(String access) {
        this.setAttributeText("/widget/access", "origin", access);
    }

    public void setId(String id) {
        if (!SourceConfig.isValidId(id)) {
            throw new IllegalArgumentException("\"" + id + "\" is not a valid Application ID");
        }
        this.setAttributeText("/widget", "id", id);
    }

    public void setVersion(String version) {
        this.setAttributeText("/widget", "version", version);
    }

    public String getIcon(String platform, int width, int height) {
        return this.getSplashOrIcon("icon", platform, width, height);
    }

    public void setIcon(String platform, int width, int height, String value) {
        this.setSplashOrIcon("icon", platform, width, height, value);
    }

    private String getSplashOrIcon(String name, String platform, int width, int height) {
        Node node = this.getSplashOrIconNode(name, platform, width, height);
        if (node == null) {
            return null;
        }
        return this.getAttributeText(node, "src");
    }

    private Node getSplashOrIconNode(String name, String platform, int width, int height) {
        NodeList icons = this.doc.getElementsByTagName(name);
        for (int i = 0; i < icons.getLength(); ++i) {
            Node n = icons.item(i);
            if (!platform.equals(this.getAttributeText(n, "gap:platform")) || !Integer.toString(width).equals(this.getAttributeText(n, "width")) || !Integer.toString(height).equals(this.getAttributeText(n, "height"))) continue;
            return n;
        }
        return null;
    }

    private void setSplashOrIcon(String name, String platform, int width, int height, String value) {
        Node n = this.getSplashOrIconNode(name, platform, width, height);
        if (n != null) {
            Attr src = this.doc.createAttribute("src");
            src.setValue(value);
            n.getAttributes().setNamedItem(src);
        } else {
            Element element = this.doc.createElement(name);
            element.setAttribute("src", value);
            element.setAttribute("width", Integer.toString(width));
            element.setAttribute("height", Integer.toString(height));
            element.setAttribute("gap:platform", platform);
            NodeList elementsByTagName = this.doc.getElementsByTagName(name);
            Node widget = this.getNode("/widget");
            if (elementsByTagName != null && elementsByTagName.getLength() > 0) {
                widget.insertBefore(element, elementsByTagName.item(0));
            } else {
                widget.appendChild(element);
            }
        }
    }

    public String getSplash(String platform, int width, int height) {
        return this.getSplashOrIcon("gap:splash", platform, width, height);
    }

    public void setSplash(String platform, int width, int height, String value) {
        this.setSplashOrIcon("gap:splash", platform, width, height, value);
    }

    public String getPreference(String name) {
        NodeList pref = this.doc.getElementsByTagName("preference");
        for (int i = 0; i < pref.getLength(); ++i) {
            Node n = pref.item(i);
            if (!name.equals(this.getAttributeText(n, "name"))) continue;
            return this.getAttributeText(n, "value");
        }
        return null;
    }

    public String getIcon(String platform) {
        if (platform.equals(IOS_PLATFORM)) {
            return this.getIcon(platform, 144, 144);
        }
        return this.getIcon(platform, 96, 96);
    }

    public void setIcon(String platform, String value) {
        if (platform.equals(IOS_PLATFORM)) {
            this.setIcon(platform, 144, 144, value);
        } else {
            this.setIcon(platform, 96, 96, value);
        }
    }

    public static boolean isValidId(String id) {
        if (id.endsWith(".")) {
            return false;
        }
        if (id.startsWith(".")) {
            return false;
        }
        if (id.contains("..")) {
            return false;
        }
        StringTokenizer tokenizer = new StringTokenizer(id, ".");
        while (tokenizer.hasMoreTokens()) {
            String part = tokenizer.nextElement().toString();
            if (!(part = part.replaceAll("-", "_")).isEmpty() && SourceVersion.isIdentifier(part) && !SourceVersion.isKeyword(part)) continue;
            return false;
        }
        return true;
    }
}

