/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.lib.api.properties;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.css.lib.api.properties.GrammarElement;
import org.netbeans.modules.css.lib.api.properties.GrammarElementVisitor;

public class GroupGrammarElement
extends GrammarElement {
    int index;
    private List<GrammarElement> elements = new ArrayList<GrammarElement>(5);
    private Type type;

    public GroupGrammarElement(GroupGrammarElement parent, int index, String referenceName) {
        super(parent, referenceName);
        this.index = index;
        this.type = Type.LIST;
    }

    public GroupGrammarElement(GroupGrammarElement parent, int index) {
        this(parent, index, null);
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public void accept(GrammarElementVisitor visitor) {
        visitor.visit(this);
        for (GrammarElement child : this.elements()) {
            child.accept(visitor);
        }
    }

    public List<GrammarElement> elements() {
        return this.elements;
    }

    public void addElement(GrammarElement element) {
        this.elements.add(element);
    }

    public List<GrammarElement> getAllPossibleValues() {
        ArrayList<GrammarElement> all = new ArrayList<GrammarElement>(10);
        if (this.getType() == Type.LIST) {
            GrammarElement e = this.elements.get(0);
            if (e instanceof GroupGrammarElement) {
                all.addAll(((GroupGrammarElement)e).getAllPossibleValues());
            } else {
                all.add(e);
            }
        } else {
            for (GrammarElement e : this.elements()) {
                if (e instanceof GroupGrammarElement) {
                    all.addAll(((GroupGrammarElement)e).getAllPossibleValues());
                    continue;
                }
                all.add(e);
            }
        }
        return all;
    }

    public boolean isVisible() {
        return this.getName() != null && this.getName().charAt(0) != '@';
    }

    @Override
    public String toString2(int level) {
        StringBuilder sb = new StringBuilder();
        String heading = this.toString();
        heading = heading.substring(0, heading.length() - 1);
        sb.append(this.indentString(level)).append(heading);
        if (this.getName() != null) {
            sb.append("(").append(this.getName()).append(") ");
        }
        sb.append('\n');
        for (GrammarElement e : this.elements()) {
            sb.append(e.toString2(level + 1));
            sb.append('\n');
        }
        sb.append(this.indentString(level));
        sb.append(']');
        sb.append(super.toString());
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(this.getType().name().charAt(0));
        sb.append(this.index);
        if (this.getName() != null) {
            sb.append("|").append(this.getName());
        }
        sb.append(']');
        return sb.toString();
    }

    public static enum Type {
        SET,
        COLLECTION,
        LIST,
        ALL;

    }
}

