/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.hints.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementKindVisitor6;
import org.netbeans.modules.websvc.editor.hints.common.ProblemContext;
import org.netbeans.modules.websvc.editor.hints.common.Rule;
import org.netbeans.spi.editor.hints.ErrorDescription;

public abstract class RulesEngine
extends ElementKindVisitor6<Void, ProblemContext> {
    private List<ErrorDescription> problemsFound = new ArrayList<ErrorDescription>();

    @Override
    public Void visitTypeAsClass(TypeElement javaClass, ProblemContext ctx) {
        for (Rule<TypeElement> rule : this.getClassRules()) {
            if (ctx.isCancelled()) break;
            ErrorDescription[] problems = rule.execute(javaClass, ctx);
            if (problems == null) continue;
            for (ErrorDescription problem : problems) {
                if (problem == null) continue;
                this.problemsFound.add(problem);
            }
        }
        for (Element element : javaClass.getEnclosedElements()) {
            element.accept(this, ctx);
        }
        return null;
    }

    @Override
    public Void visitTypeAsInterface(TypeElement javaClass, ProblemContext ctx) {
        return this.visitTypeAsClass(javaClass, ctx);
    }

    @Override
    public Void visitExecutableAsMethod(ExecutableElement operation, ProblemContext ctx) {
        for (Rule<ExecutableElement> rule : this.getOperationRules()) {
            if (ctx.isCancelled()) break;
            ErrorDescription[] problems = rule.execute(operation, ctx);
            if (problems == null) continue;
            for (ErrorDescription problem : problems) {
                if (problem == null) continue;
                this.problemsFound.add(problem);
            }
        }
        for (VariableElement variableElement : operation.getParameters()) {
            variableElement.accept(this, ctx);
        }
        return null;
    }

    @Override
    public Void visitVariableAsParameter(VariableElement parameter, ProblemContext ctx) {
        for (Rule<VariableElement> rule : this.getParameterRules()) {
            if (ctx.isCancelled()) break;
            ErrorDescription[] problems = rule.execute(parameter, ctx);
            if (problems == null) continue;
            for (ErrorDescription problem : problems) {
                if (problem == null) continue;
                this.problemsFound.add(problem);
            }
        }
        return null;
    }

    public List<ErrorDescription> getProblemsFound() {
        return this.problemsFound;
    }

    protected abstract Collection<Rule<TypeElement>> getClassRules();

    protected abstract Collection<Rule<ExecutableElement>> getOperationRules();

    protected abstract Collection<Rule<VariableElement>> getParameterRules();
}

