/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.UIResource;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.java.source.BuildArtifactMapper;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.customizer.ModelHandle2;
import org.netbeans.modules.maven.api.customizer.support.CheckBoxUpdater;
import org.netbeans.modules.maven.api.customizer.support.ComboBoxUpdater;
import org.netbeans.modules.maven.classpath.BootClassPathImpl;
import org.netbeans.modules.maven.customizer.Bundle;
import org.netbeans.modules.maven.customizer.CustomizerProviderImpl;
import org.netbeans.modules.maven.customizer.MavenProjectPropertiesUiSupport;
import org.netbeans.modules.maven.customizer.WarnPanel;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.Configuration;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.options.DontShowAgainSettings;
import org.netbeans.modules.maven.options.MavenVersionSettings;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Pair;
import org.openide.util.Union2;
import org.openide.util.WeakListeners;

public class CompilePanel
extends JPanel
implements HelpCtx.Provider {
    private static final Logger LOG = Logger.getLogger(CompilePanel.class.getName());
    private static final String PARAM_DEBUG = "debug";
    private static final String PARAM_DEPRECATION = "showDeprecation";
    private final ModelHandle2 handle;
    private final Project project;
    private static boolean warningShown = false;
    private Color origComPlatformFore;
    private JButton btnLearnMore;
    private JButton btnMngPlatform;
    private JCheckBox cbCompileOnSave;
    private JCheckBox cbDebug;
    private JCheckBox cbDeprecate;
    private JComboBox comJavaPlatform;
    private JLabel lblHint1;
    private JLabel lblHint2;
    private JLabel lblJavaPlatform;
    private static final String CONFIGURATION_EL = "configuration";
    private final Map<String, CompilerParamOperation> operations = new HashMap<String, CompilerParamOperation>();

    public CompilePanel(ModelHandle2 handle, Project prj, MavenProjectPropertiesUiSupport uiSupport) {
        this.initComponents();
        this.handle = handle;
        this.project = prj;
        this.comJavaPlatform.setModel(uiSupport.getPlatformComboBoxModel());
        this.comJavaPlatform.setRenderer(new PlatformsRenderer());
        this.origComPlatformFore = this.comJavaPlatform.getForeground();
        this.btnLearnMore.setCursor(Cursor.getPredefinedCursor(12));
        this.btnLearnMore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("http://wiki.netbeans.org/FaqCompileOnSave#Using_Compile_on_Save_in_Maven_Projects"));
                }
                catch (MalformedURLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        this.initValues();
    }

    private void initValues() {
        final boolean cosSupported = BuildArtifactMapper.isCompileOnSaveSupported();
        if (!cosSupported) {
            this.cbCompileOnSave.setEnabled(false);
        }
        new CheckBoxUpdater(this.cbCompileOnSave){
            private String modifiedValue;
            private ModelOperation<POMModel> operation;
            {
                super(comp);
                this.operation = new ModelOperation<POMModel>(){

                    public void performOperation(POMModel model) {
                        org.netbeans.modules.maven.model.pom.Properties modprops = model.getProject().getProperties();
                        if (modprops == null) {
                            modprops = model.getFactory().createProperties();
                            model.getProject().setProperties(modprops);
                        }
                        modprops.setProperty("netbeans.compile.on.save", modifiedValue);
                    }
                };
            }

            @Override
            public boolean getDefaultValue() {
                return cosSupported;
            }

            @Override
            public Boolean getValue() {
                Properties props;
                if (!cosSupported) {
                    return false;
                }
                String val = this.modifiedValue;
                if (val == null) {
                    val = CompilePanel.this.handle.getRawAuxiliaryProperty("netbeans.compile.on.save", true);
                }
                if (val == null && (props = CompilePanel.this.handle.getProject().getProperties()) != null) {
                    val = props.getProperty("netbeans.compile.on.save");
                }
                return val != null ? Boolean.valueOf(!"none".equals(val)) : null;
            }

            @Override
            public void setValue(Boolean v) {
                String value;
                CompilePanel.this.handle.removePOMModification(this.operation);
                this.modifiedValue = null;
                String string = v != null ? (v.booleanValue() ? "all" : "none") : (value = "all");
                if ("all".equals(value) && !warningShown && DontShowAgainSettings.getDefault().showWarningAboutApplicationCoS()) {
                    WarnPanel panel = new WarnPanel(NbBundle.getMessage(CompilePanel.class, (String)"HINT_ApplicationCoS"));
                    NotifyDescriptor.Message dd = new NotifyDescriptor.Message((Object)panel, -1);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                    if (panel.disabledWarning()) {
                        DontShowAgainSettings.getDefault().dontshowWarningAboutApplicationCoSAnymore();
                    }
                    warningShown = true;
                }
                boolean hasConfig = CompilePanel.this.handle.getRawAuxiliaryProperty("netbeans.compile.on.save", true) != null;
                org.netbeans.modules.maven.model.pom.Project p = CompilePanel.this.handle.getPOMModel().getProject();
                if (p.getProperties() != null && p.getProperties().getProperty("netbeans.compile.on.save") != null) {
                    this.modifiedValue = value;
                    CompilePanel.this.handle.addPOMModification(this.operation);
                    if (hasConfig) {
                        CompilePanel.this.handle.setRawAuxiliaryProperty("netbeans.compile.on.save", null, true);
                    }
                } else {
                    CompilePanel.this.handle.setRawAuxiliaryProperty("netbeans.compile.on.save", value, true);
                }
            }
        };
        new CheckBoxUpdater(this.cbDebug){

            @Override
            public Boolean getValue() {
                String val = CompilePanel.this.getCompilerParam(CompilePanel.this.handle, CompilePanel.PARAM_DEBUG);
                if (val != null) {
                    return Boolean.valueOf(val);
                }
                return null;
            }

            @Override
            public void setValue(Boolean value) {
                String text = value == null ? "" + this.getDefaultValue() : value.toString();
                CompilePanel.this.modifyCompilerParamOperation(CompilePanel.this.handle, CompilePanel.PARAM_DEBUG, text);
            }

            @Override
            public boolean getDefaultValue() {
                return true;
            }
        };
        new CheckBoxUpdater(this.cbDeprecate){

            @Override
            public Boolean getValue() {
                String val = CompilePanel.this.getCompilerParam(CompilePanel.this.handle, CompilePanel.PARAM_DEPRECATION);
                if (val != null) {
                    return Boolean.valueOf(val);
                }
                return null;
            }

            @Override
            public void setValue(Boolean value) {
                String text = value == null ? "" + this.getDefaultValue() : value.toString();
                CompilePanel.this.modifyCompilerParamOperation(CompilePanel.this.handle, CompilePanel.PARAM_DEPRECATION, text);
            }

            @Override
            public boolean getDefaultValue() {
                return false;
            }
        };
        ComboBoxUpdater<Union2<JavaPlatform, String>> compleComboBoxUpdater = new ComboBoxUpdater<Union2<JavaPlatform, String>>(this.comJavaPlatform, this.lblJavaPlatform){
            private String modifiedValue;
            private String DEFAULT_PLATFORM_VALUE;
            private ModelOperation<POMModel> operation;
            {
                this.DEFAULT_PLATFORM_VALUE = "@@DEFAU:T@@";
                this.operation = new ModelOperation<POMModel>(){

                    public void performOperation(POMModel model) {
                        org.netbeans.modules.maven.model.pom.Properties modprops = model.getProject().getProperties();
                        if (modprops == null) {
                            modprops = model.getFactory().createProperties();
                            model.getProject().setProperties(modprops);
                        }
                        modprops.setProperty("netbeans.hint.jdkPlatform", modifiedValue);
                    }
                };
            }

            @Override
            public Union2<JavaPlatform, String> getValue() {
                org.netbeans.modules.maven.model.pom.Properties props;
                String val = this.modifiedValue;
                if (val == null && (props = CompilePanel.this.handle.getPOMModel().getProject().getProperties()) != null) {
                    val = props.getProperty("netbeans.hint.jdkPlatform");
                }
                if (val == null) {
                    val = CompilePanel.this.handle.getRawAuxiliaryProperty("netbeans.hint.jdkPlatform", true);
                }
                if (val != null) {
                    if (val.equals(this.DEFAULT_PLATFORM_VALUE)) {
                        return Union2.createFirst((Object)JavaPlatformManager.getDefault().getDefaultPlatform());
                    }
                    return Optional.ofNullable(BootClassPathImpl.getActivePlatform(val)).filter(JavaPlatform::isValid).map(jp -> Union2.createFirst((Object)jp)).orElse(Union2.createSecond((Object)val));
                }
                Pair nameJpP = CompilePanel.this.getSelPlatform();
                return Optional.ofNullable(nameJpP.second()).filter(JavaPlatform::isValid).map(jp -> Union2.createFirst((Object)jp)).orElseGet(() -> Union2.createSecond((Object)nameJpP.first()));
            }

            @Override
            public Union2<JavaPlatform, String> getDefaultValue() {
                return Union2.createFirst((Object)JavaPlatformManager.getDefault().getDefaultPlatform());
            }

            @Override
            public void setValue(Union2<JavaPlatform, String> value) {
                String platformId;
                Union2 platf;
                CompilePanel.this.handle.removePOMModification(this.operation);
                this.modifiedValue = null;
                Union2 union2 = platf = value == null ? Union2.createFirst((Object)JavaPlatformManager.getDefault().getDefaultPlatform()) : value;
                if (platf.hasFirst()) {
                    JavaPlatform jp = (JavaPlatform)platf.first();
                    platformId = JavaPlatformManager.getDefault().getDefaultPlatform().equals(jp) ? null : (String)jp.getProperties().get("platform.ant.name");
                } else {
                    platformId = (String)platf.second();
                }
                boolean hasConfig = CompilePanel.this.handle.getRawAuxiliaryProperty("netbeans.hint.jdkPlatform", true) != null;
                String string = this.modifiedValue = platformId == null ? this.DEFAULT_PLATFORM_VALUE : platformId;
                if (CompilePanel.this.handle.getProject().getProperties().containsKey("netbeans.hint.jdkPlatform")) {
                    CompilePanel.this.handle.addPOMModification(this.operation);
                    if (hasConfig) {
                        CompilePanel.this.handle.setRawAuxiliaryProperty("netbeans.hint.jdkPlatform", null, true);
                    }
                } else {
                    CompilePanel.this.handle.setRawAuxiliaryProperty("netbeans.hint.jdkPlatform", platformId, true);
                }
            }
        };
        compleComboBoxUpdater.ancestorAdded(null);
        compleComboBoxUpdater.ancestorRemoved(null);
    }

    private Pair<String, JavaPlatform> getSelPlatform() {
        String platformId = ((AuxiliaryProperties)this.project.getLookup().lookup(AuxiliaryProperties.class)).get("netbeans.hint.jdkPlatform", true);
        return Pair.of((Object)platformId, (Object)BootClassPathImpl.getActivePlatform(platformId));
    }

    private void initComponents() {
        this.lblJavaPlatform = new JLabel();
        this.comJavaPlatform = new JComboBox();
        this.btnMngPlatform = new JButton();
        this.lblHint1 = new JLabel();
        this.lblHint2 = new JLabel();
        this.cbDebug = new JCheckBox();
        this.cbDeprecate = new JCheckBox();
        this.cbCompileOnSave = new JCheckBox();
        this.btnLearnMore = new JButton();
        this.setPreferredSize(new Dimension(576, 303));
        this.lblJavaPlatform.setLabelFor(this.comJavaPlatform);
        Mnemonics.setLocalizedText((JLabel)this.lblJavaPlatform, (String)NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.lblJavaPlatform.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnMngPlatform, (String)NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.btnMngPlatform.text"));
        this.btnMngPlatform.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompilePanel.this.btnMngPlatformActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.lblHint1, (String)NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.lblHint1.text"));
        Mnemonics.setLocalizedText((JLabel)this.lblHint2, (String)NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.lblHint2.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbDebug, (String)NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.cbDebug.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbDeprecate, (String)NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.cbDeprecate.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbCompileOnSave, (String)NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.cbCompileOnSave.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.btnLearnMore, (String)NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.btnLearnMore.text"));
        this.btnLearnMore.setBorderPainted(false);
        this.btnLearnMore.setContentAreaFilled(false);
        this.btnLearnMore.setHorizontalTextPosition(2);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbDebug).addComponent(this.cbDeprecate).addComponent(this.lblHint1).addComponent(this.lblHint2)).addGap(0, 24, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.cbCompileOnSave, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.lblJavaPlatform).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comJavaPlatform, 0, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnMngPlatform))).addContainerGap()).addGroup(layout.createSequentialGroup().addGap(30, 30, 30).addComponent(this.btnLearnMore, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblJavaPlatform).addComponent(this.comJavaPlatform, -2, -1, -2).addComponent(this.btnMngPlatform)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbCompileOnSave).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblHint1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblHint2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnLearnMore, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbDebug).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbDeprecate).addContainerGap(108, Short.MAX_VALUE)));
        this.btnMngPlatform.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CompilePanel.class, (String)"CompilePanel.btnMngPlatform.AccessibleContext.accessibleDescription"));
    }

    private void btnMngPlatformActionPerformed(ActionEvent evt) {
        PlatformsCustomizer.showCustomizer((JavaPlatform)((JavaPlatform)this.getSelPlatform().second()));
    }

    private void modifyCompilerParamOperation(ModelHandle2 handle, String param, String value) {
        String debug = PluginPropertyUtils.getPluginProperty(handle.getProject(), "org.apache.maven.plugins", "maven-compiler-plugin", param, "compile");
        if (debug != null && debug.contains(value)) {
            ModelOperation removed = this.operations.remove(param);
            if (removed != null) {
                handle.removePOMModification((ModelOperation<POMModel>)removed);
            }
            return;
        }
        ModelOperation removed = this.operations.remove(param);
        if (removed != null) {
            handle.removePOMModification((ModelOperation<POMModel>)removed);
        }
        CompilerParamOperation added = new CompilerParamOperation(param, value);
        this.operations.put(param, added);
        handle.addPOMModification(added);
    }

    String getCompilerParam(ModelHandle2 handle, String param) {
        CompilerParamOperation oper = this.operations.get(param);
        if (oper != null) {
            return oper.getValue();
        }
        String value = PluginPropertyUtils.getPluginProperty(handle.getProject(), "org.apache.maven.plugins", "maven-compiler-plugin", param, "compile");
        if (value != null) {
            return value;
        }
        return null;
    }

    public HelpCtx getHelpCtx() {
        return CustomizerProviderImpl.HELP_CTX;
    }

    private class PlatformsRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public PlatformsRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Union2 u2;
            this.setName("ComboBox.listRenderer");
            String strValue = value instanceof Union2 ? ((u2 = (Union2)value).hasFirst() ? ((JavaPlatform)u2.first()).getDisplayName() : "<html><font color=\"#A40000\">" + Bundle.TXT_BrokenPlatformFmt(u2.second())) : Optional.ofNullable(value).map(Object::toString).orElse("");
            this.setText(strValue);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }

    static class PlatformsModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        private static final long serialVersionUID = 1L;
        private List<Union2<JavaPlatform, String>> data;
        private Union2<JavaPlatform, String> sel;
        private final Project project;
        private final ModelHandle2 handle;

        public PlatformsModel(Project project, ModelHandle2 handle) {
            this.project = project;
            this.handle = handle;
            JavaPlatformManager jpm = JavaPlatformManager.getDefault();
            this.getPlatforms(jpm);
            jpm.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)jpm));
            this.sel = Union2.createFirst((Object)jpm.getDefaultPlatform());
        }

        @Override
        public int getSize() {
            return this.data.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.data.get(index);
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.sel = (Union2)anItem;
            this.fireContentsChanged(this, 0, this.data.size());
        }

        public Union2<JavaPlatform, String> getSelectedItem() {
            return this.sel;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JavaPlatformManager jpm = JavaPlatformManager.getDefault();
            this.getPlatforms(jpm);
            this.fireContentsChanged(this, 0, this.data.size());
        }

        private void getPlatforms(JavaPlatformManager jpm) {
            ArrayList<Union2<JavaPlatform, String>> tmp = new ArrayList<Union2<JavaPlatform, String>>();
            Arrays.stream(jpm.getPlatforms(null, new Specification("j2se", null))).filter(JavaPlatform::isValid).peek(jp -> LOG.log(Level.FINE, "Adding JavaPlaform: {0}", jp.getDisplayName())).map(jp -> Union2.createFirst((Object)jp)).forEach(tmp::add);
            String val = null;
            org.netbeans.modules.maven.model.pom.Properties props = this.handle.getPOMModel().getProject().getProperties();
            if (props != null) {
                val = props.getProperty("netbeans.hint.jdkPlatform");
            }
            if (val == null) {
                val = this.handle.getRawAuxiliaryProperty("netbeans.hint.jdkPlatform", true);
            }
            String broken = null;
            if (val != null) {
                JavaPlatform jp2 = BootClassPathImpl.getActivePlatform(val);
                if (jp2 == null || !jp2.isValid()) {
                    broken = val;
                }
            } else {
                Pair<String, JavaPlatform> nameJpP = this.getSelPlatform();
                if (nameJpP.second() == null || !((JavaPlatform)nameJpP.second()).isValid()) {
                    broken = (String)nameJpP.first();
                }
            }
            if (broken != null) {
                tmp.add((Union2<JavaPlatform, String>)Union2.createSecond((Object)broken));
            }
            this.data = tmp;
        }

        private Pair<String, JavaPlatform> getSelPlatform() {
            String platformId = ((AuxiliaryProperties)this.project.getLookup().lookup(AuxiliaryProperties.class)).get("netbeans.hint.jdkPlatform", true);
            return Pair.of((Object)platformId, (Object)BootClassPathImpl.getActivePlatform(platformId));
        }
    }

    private class CompilerParamOperation
    implements ModelOperation<POMModel> {
        private final String value;
        private final String param;

        public CompilerParamOperation(String param, String value) {
            this.param = param;
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void performOperation(POMModel model) {
            Plugin plugin;
            Plugin old = null;
            Build bld = model.getProject().getBuild();
            if (bld != null) {
                old = bld.findPluginById("org.apache.maven.plugins", "maven-compiler-plugin");
            } else {
                bld = model.getFactory().createBuild();
                model.getProject().setBuild(bld);
            }
            if (old != null) {
                plugin = old;
            } else {
                plugin = model.getFactory().createPlugin();
                plugin.setGroupId("org.apache.maven.plugins");
                plugin.setArtifactId("maven-compiler-plugin");
                plugin.setVersion(MavenVersionSettings.getDefault().getVersion("maven-compiler-plugin"));
                bld.addPlugin(plugin);
            }
            Configuration config = plugin.getConfiguration();
            if (config == null) {
                config = model.getFactory().createConfiguration();
                plugin.setConfiguration(config);
            }
            config.setSimpleParameter(this.param, this.value);
        }
    }
}

