/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.editor.navigation;

import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.javascript2.model.api.JsElement;
import org.netbeans.modules.javascript2.model.api.JsFunction;
import org.netbeans.modules.javascript2.model.api.JsObject;
import org.netbeans.modules.javascript2.model.api.JsReference;
import org.netbeans.modules.javascript2.model.api.Model;
import org.netbeans.modules.javascript2.model.api.ModelUtils;
import org.netbeans.modules.javascript2.model.api.Occurrence;

public class OccurrencesSupport {
    private static final Logger LOGGER = Logger.getLogger(OccurrencesSupport.class.getName());
    private final Model model;

    public OccurrencesSupport(Model model) {
        this.model = model;
    }

    public Occurrence getOccurrence(int offset) {
        long start = System.currentTimeMillis();
        JsObject object = this.model.getGlobalObject();
        Occurrence result = this.findOccurrence(object, offset);
        if (result == null) {
            result = this.findDeclaration(object, offset);
        }
        long end = System.currentTimeMillis();
        LOGGER.log(Level.FINE, "Computing getOccurences({0}) took {1}ms. Returns {2}", new Object[]{offset, end - start, result});
        return result;
    }

    private Occurrence findOccurrence(JsObject object, int offset) {
        Occurrence result = null;
        JsElement.Kind kind = object.getJSKind();
        for (Occurrence occurrence : object.getOccurrences()) {
            if (!occurrence.getOffsetRange().containsInclusive(offset)) continue;
            return occurrence;
        }
        if (kind.isFunction() || kind == JsElement.Kind.CATCH_BLOCK) {
            JsObject param;
            Iterator<Object> iterator = ((JsFunction)object).getParameters().iterator();
            while (iterator.hasNext() && (result = this.findOccurrence(param = (JsObject)iterator.next(), offset)) == null) {
            }
            if (result != null) {
                return result;
            }
        }
        if (!(object instanceof JsReference) || !ModelUtils.isDescendant((JsObject)object, (JsObject)((JsReference)object).getOriginal())) {
            for (JsObject property : object.getProperties().values()) {
                if (!(property instanceof JsReference) || ((JsReference)property).getOriginal().isAnonymous()) {
                    result = this.findOccurrence(property, offset);
                    if (result == null) continue;
                    break;
                }
                for (Occurrence occurrence : property.getOccurrences()) {
                    if (!occurrence.getOffsetRange().containsInclusive(offset)) continue;
                    return occurrence;
                }
            }
        }
        return result;
    }

    private Occurrence findDeclaration(JsObject object, int offset) {
        Occurrence result;
        block6: {
            JsObject property;
            result = null;
            JsElement.Kind kind = object.getJSKind();
            if (kind != JsElement.Kind.ANONYMOUS_OBJECT && kind != JsElement.Kind.WITH_OBJECT && object.getDeclarationName() != null && object.getDeclarationName().getOffsetRange().containsInclusive(offset) && !ModelUtils.isGlobal((JsObject)object)) {
                if (kind.isPropertyGetterSetter()) {
                    String propertyName = object.getName();
                    propertyName = propertyName.substring(propertyName.lastIndexOf(32) + 1);
                    property = object.getParent().getProperty(propertyName);
                    if (property != null) {
                        return new Occurrence(property.getDeclarationName().getOffsetRange(), new JsObject[]{property});
                    }
                }
                result = new Occurrence(object.getDeclarationName().getOffsetRange(), new JsObject[]{object});
            }
            if (result == null && (kind.isFunction() || kind == JsElement.Kind.CATCH_BLOCK)) {
                for (JsObject param : ((JsFunction)object).getParameters()) {
                    if (!param.getDeclarationName().getOffsetRange().containsInclusive(offset)) continue;
                    result = new Occurrence(param.getDeclarationName().getOffsetRange(), new JsObject[]{object});
                    return result;
                }
            }
            if (result != null) break block6;
            Iterator<Object> iterator = object.getProperties().values().iterator();
            while (iterator.hasNext() && ((property = (JsObject)iterator.next()) instanceof JsReference || (result = this.findDeclaration(property, offset)) == null)) {
            }
        }
        return result;
    }
}

