/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.NSArray;
import com.dd.plist.NSData;
import com.dd.plist.NSDate;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLPropertyListParser {
    private static DocumentBuilderFactory docBuilderFactory = null;

    protected XMLPropertyListParser() {
    }

    private static synchronized void initDocBuilderFactory() throws ParserConfigurationException {
        docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setIgnoringComments(true);
        docBuilderFactory.setCoalescing(true);
    }

    private static synchronized DocumentBuilder getDocBuilder() throws ParserConfigurationException {
        if (docBuilderFactory == null) {
            XMLPropertyListParser.initDocBuilderFactory();
        }
        DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
        docBuilder.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) {
                if ("-//Apple Computer//DTD PLIST 1.0//EN".equals(publicId) || "-//Apple//DTD PLIST 1.0//EN".equals(publicId)) {
                    return new InputSource(new ByteArrayInputStream(new byte[0]));
                }
                return null;
            }
        });
        return docBuilder;
    }

    public static NSObject parse(File f) throws Exception {
        DocumentBuilder docBuilder = XMLPropertyListParser.getDocBuilder();
        Document doc = docBuilder.parse(f);
        return XMLPropertyListParser.parseDocument(doc);
    }

    public static NSObject parse(byte[] bytes) throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        return XMLPropertyListParser.parse(bis);
    }

    public static NSObject parse(InputStream is) throws Exception {
        DocumentBuilder docBuilder = XMLPropertyListParser.getDocBuilder();
        Document doc = docBuilder.parse(is);
        return XMLPropertyListParser.parseDocument(doc);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static NSObject parseDocument(Document doc) throws Exception {
        void var2_5;
        DocumentType docType = doc.getDoctype();
        if (docType == null ? !doc.getDocumentElement().getNodeName().equals("plist") : !docType.getName().equals("plist")) {
            throw new UnsupportedOperationException("The given XML document is not a property list.");
        }
        Object var2_2 = null;
        if (doc.getDocumentElement().getNodeName().equals("plist")) {
            List<Node> rootNodes = XMLPropertyListParser.filterElementNodes(doc.getDocumentElement().getChildNodes());
            if (rootNodes.isEmpty()) {
                throw new Exception("The given property list has no root element!");
            }
            if (rootNodes.size() != 1) throw new Exception("The given property list has more than one root element!");
            Node node = rootNodes.get(0);
            return XMLPropertyListParser.parseObject((Node)var2_5);
        } else {
            Element element = doc.getDocumentElement();
        }
        return XMLPropertyListParser.parseObject((Node)var2_5);
    }

    private static NSObject parseObject(Node n) throws Exception {
        String type = n.getNodeName();
        if (type.equals("dict")) {
            NSDictionary dict = new NSDictionary();
            List<Node> children = XMLPropertyListParser.filterElementNodes(n.getChildNodes());
            for (int i = 0; i < children.size(); i += 2) {
                Node key = children.get(i);
                Node val = children.get(i + 1);
                String keyString = XMLPropertyListParser.getNodeTextContents(key);
                dict.put(keyString, XMLPropertyListParser.parseObject(val));
            }
            return dict;
        }
        if (type.equals("array")) {
            List<Node> children = XMLPropertyListParser.filterElementNodes(n.getChildNodes());
            NSArray array = new NSArray(children.size());
            for (int i = 0; i < children.size(); ++i) {
                array.setValue(i, XMLPropertyListParser.parseObject(children.get(i)));
            }
            return array;
        }
        if (type.equals("true")) {
            return new NSNumber(true);
        }
        if (type.equals("false")) {
            return new NSNumber(false);
        }
        if (type.equals("integer")) {
            return new NSNumber(XMLPropertyListParser.getNodeTextContents(n));
        }
        if (type.equals("real")) {
            return new NSNumber(XMLPropertyListParser.getNodeTextContents(n));
        }
        if (type.equals("string")) {
            return new NSString(XMLPropertyListParser.getNodeTextContents(n));
        }
        if (type.equals("data")) {
            return new NSData(XMLPropertyListParser.getNodeTextContents(n));
        }
        if (type.equals("date")) {
            return new NSDate(XMLPropertyListParser.getNodeTextContents(n));
        }
        return null;
    }

    private static List<Node> filterElementNodes(NodeList list) {
        ArrayList<Node> result = new ArrayList<Node>(list.getLength());
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeType() != 1) continue;
            result.add(list.item(i));
        }
        return result;
    }

    private static String getNodeTextContents(Node n) {
        if (n.getNodeType() == 3 || n.getNodeType() == 4) {
            Text txtNode = (Text)n;
            String content = txtNode.getWholeText();
            if (content == null) {
                return "";
            }
            return content;
        }
        if (n.hasChildNodes()) {
            NodeList children = n.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 3 && child.getNodeType() != 4) continue;
                Text txtNode = (Text)child;
                String content = txtNode.getWholeText();
                if (content == null) {
                    return "";
                }
                return content;
            }
            return "";
        }
        return "";
    }
}

