/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.details.api;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.details.api.Bundle;
import org.netbeans.modules.profiler.ui.NBSwingWorker;
import org.openide.windows.WindowManager;

public final class ExportAction
extends AbstractAction {
    private static final Logger LOGGER = Logger.getLogger(ExportAction.class.getName());
    private static final Icon ICON = Icons.getIcon((String)"GeneralIcons.Export");
    private static final String FILE_EXTENSION_CSV = "csv";
    private static final String FILE_EXTENSION_TXT = "txt";
    private static final String FILE_EXTENSION_BIN = "bin";
    public static final int MODE_CSV = 1;
    public static final int MODE_TXT = 2;
    public static final int MODE_BIN = 3;
    private static File exportDir;
    private JFileChooser fileChooser;
    private final ExportProvider exportProvider;
    private int exportedFileType;

    public ExportAction(ExportProvider exportProvider) {
        this.putValue("Name", Bundle.ExportAction_BasicExportActionName());
        this.putValue("ShortDescription", Bundle.ExportAction_BasicExportActionDescr());
        this.putValue("SmallIcon", ICON);
        this.putValue("iconBase", Icons.getResource((String)"GeneralIcons.Export"));
        this.exportProvider = exportProvider;
    }

    private void setFilters() {
        this.fileChooser.removeChoosableFileFilter(this.fileChooser.getAcceptAllFileFilter());
        if (this.exportProvider.hasRawData()) {
            this.fileChooser.addChoosableFileFilter(new FileFilterImpl(FILE_EXTENSION_CSV));
        }
        if (this.exportProvider.hasText()) {
            this.fileChooser.addChoosableFileFilter(new FileFilterImpl(FILE_EXTENSION_TXT));
        }
        if (this.exportProvider.hasBinaryData()) {
            this.fileChooser.addChoosableFileFilter(new FileFilterImpl(FILE_EXTENSION_BIN));
        }
    }

    private JFileChooser getFileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setDialogType(1);
            this.fileChooser.setFileSelectionMode(2);
            this.fileChooser.setMultiSelectionEnabled(false);
            this.fileChooser.setDialogTitle(Bundle.ExportAction_ExportDialogTitle());
            this.fileChooser.setApproveButtonText(Bundle.ExportAction_ExportDialogButton());
        }
        this.fileChooser.resetChoosableFileFilters();
        this.setFilters();
        return this.fileChooser;
    }

    private boolean checkFileExists(File target) {
        return !target.exists() || ProfilerDialogs.displayConfirmation((String)Bundle.ExportAction_OverwriteFileMsg(target.getName()), (String)Bundle.ExportAction_OverwriteFileCaption());
    }

    private SelectedFile selectExportTargetFile(ExportProvider exportProvider) {
        String targetName;
        File targetDir;
        int result;
        String defaultName = exportProvider.getViewName();
        JFileChooser chooser = this.getFileChooser();
        if (exportDir != null) {
            chooser.setCurrentDirectory(exportDir);
        }
        if ((result = chooser.showSaveDialog((Component)WindowManager.getDefault().getRegistry().getActivated())) != 0) {
            return null;
        }
        File file = chooser.getSelectedFile();
        String targetExt = null;
        FileFilter selectedFileFilter = chooser.getFileFilter();
        if (selectedFileFilter == null || selectedFileFilter.getDescription().equals(Bundle.ExportAction_ExportDialogCSVFilter())) {
            targetExt = FILE_EXTENSION_CSV;
            this.exportedFileType = 1;
        } else if (selectedFileFilter.getDescription().equals(Bundle.ExportAction_ExportDialogTXTFilter())) {
            targetExt = FILE_EXTENSION_TXT;
            this.exportedFileType = 2;
        } else if (selectedFileFilter.getDescription().equals(Bundle.ExportAction_ExportDialogBINFilter())) {
            targetExt = FILE_EXTENSION_BIN;
            this.exportedFileType = 3;
        }
        if (file.isDirectory()) {
            exportDir = file;
            targetDir = file;
            targetName = defaultName;
        } else {
            targetDir = this.fileChooser.getCurrentDirectory();
            String fName = file.getName();
            if (fName.endsWith("." + targetExt)) {
                int idx = fName.lastIndexOf(46);
                targetName = fName.substring(0, idx);
            } else {
                targetName = fName;
            }
        }
        return new SelectedFile(targetDir, targetName, targetExt);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (!this.exportProvider.hasRawData() && !this.exportProvider.hasText()) {
            ProfilerDialogs.displayError((String)Bundle.ExportAction_NoViewMsg());
            return;
        }
        SelectedFile saveFile = this.selectExportTargetFile(this.exportProvider);
        if (saveFile == null) {
            return;
        }
        final File file = saveFile.getSelectedFile();
        if (!this.checkFileExists(file)) {
            return;
        }
        new NBSwingWorker(true){
            private final ProgressHandle ph;
            {
                super(x0);
                this.ph = ProgressHandle.createHandle((String)Bundle.ExportAction_ExportingViewMsg());
            }

            protected void doInBackground() {
                this.ph.setInitialDelay(500);
                this.ph.start();
                try {
                    FileOutputStream fo = new FileOutputStream(file);
                    ExportDataDumper eDD = new ExportDataDumper(fo);
                    ExportAction.this.exportProvider.exportData(ExportAction.this.exportedFileType, eDD);
                    if (eDD.getCaughtException() != null) {
                        ProfilerDialogs.displayError((String)(eDD.getNumExceptions() + Bundle.ExportAction_IOException_Exporting_Msg()));
                    }
                }
                catch (OutOfMemoryError e) {
                    ProfilerDialogs.displayError((String)(Bundle.ExportAction_OomeExportingMsg() + e.getMessage()));
                }
                catch (IOException e1) {
                    ProfilerDialogs.displayError((String)Bundle.ExportAction_CannotWriteFileMsg(e1.getLocalizedMessage()));
                    LOGGER.log(Level.WARNING, e1.toString());
                }
            }

            protected void done() {
                this.ph.finish();
            }
        }.execute();
    }

    private static class FileFilterImpl
    extends FileFilter {
        private final String extension;

        public FileFilterImpl(String ext) {
            this.extension = ext;
        }

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getName().toLowerCase(Locale.US).endsWith("." + this.extension);
        }

        @Override
        public String getDescription() {
            if (ExportAction.FILE_EXTENSION_CSV.equals(this.extension)) {
                return Bundle.ExportAction_ExportDialogCSVFilter();
            }
            if (ExportAction.FILE_EXTENSION_TXT.equals(this.extension)) {
                return Bundle.ExportAction_ExportDialogTXTFilter();
            }
            if (ExportAction.FILE_EXTENSION_BIN.equals(this.extension)) {
                return Bundle.ExportAction_ExportDialogBINFilter();
            }
            return null;
        }
    }

    private static class SelectedFile {
        File folder;
        String fileExt;
        String fileName;

        SelectedFile(File folder, String fileName, String fileExt) {
            this.folder = folder;
            this.fileName = fileName;
            this.fileExt = fileExt;
        }

        File getSelectedFile() {
            String folderPath = this.folder.getAbsolutePath();
            if (folderPath.endsWith(File.separator)) {
                folderPath = folderPath.substring(0, folderPath.length() - 1);
            }
            return new File(folderPath + File.separator + this.fileName + "." + this.fileExt);
        }
    }

    public static interface ExportProvider {
        public void exportData(int var1, ExportDataDumper var2);

        public String getViewName();

        public boolean isExportable();

        public boolean hasRawData();

        public boolean hasBinaryData();

        public boolean hasText();
    }
}

