/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.hierarchicalsupport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.graph.layout.UniversalGraph;

public class MixedGraph<N, E> {
    private Collection<N> nodes;
    private Map<N, Vertex> vertexMap;
    private GraphScene scene;
    private UniversalGraph<N, E> uGraph;
    private Collection<E> edges;

    private MixedGraph(UniversalGraph<N, E> uGraph, GraphScene scene) {
        this.uGraph = uGraph;
        this.scene = scene;
        this.nodes = uGraph.getNodes();
        this.edges = uGraph.getEdges();
        this.vertexMap = new HashMap<N, Vertex>();
    }

    public static <N, E> MixedGraph createGraph(UniversalGraph<N, E> uGraph, GraphScene scene) {
        MixedGraph<N, E> graph = new MixedGraph<N, E>(uGraph, scene);
        graph.createGraph();
        return graph;
    }

    protected void createGraph() {
        for (E e : this.edges) {
            N source = this.uGraph.getEdgeSource(e);
            N target = this.uGraph.getEdgeTarget(e);
            Vertex sourceVertex = this.getVertex(source);
            Vertex targetVertex = this.getVertex(target);
            sourceVertex.addUpperNeighbor(targetVertex);
            targetVertex.addLowerNeighbor(sourceVertex);
            targetVertex.addNeighbor(sourceVertex);
        }
        for (Object node : this.nodes) {
            Vertex vertex = this.getVertex(node);
        }
    }

    public Collection<Vertex> getVertices() {
        return this.vertexMap.values();
    }

    private Vertex getVertex(N node) {
        Vertex<N> vertex = this.vertexMap.get(node);
        if (vertex == null) {
            vertex = new Vertex<N>(node);
            this.vertexMap.put(node, vertex);
        }
        return vertex;
    }

    private void printGraph() {
        for (Vertex v : this.getVertices()) {
            System.out.println("vertex = " + v);
            Collection<Vertex> vertices = v.getNeighbors();
            for (Vertex nv : vertices) {
                System.out.println("\tneighbor = " + nv);
            }
        }
    }

    public static class Vertex<N> {
        private N node;
        private ArrayList<Vertex> upperNeighbors;
        private ArrayList<Vertex> lowerNeighbors;
        private ArrayList<Vertex> neighbors;
        private Object vertexData;

        public Vertex(N node) {
            this.node = node;
            this.neighbors = new ArrayList();
        }

        public void addNeighbor(Vertex vertex) {
            this.neighbors.add(vertex);
        }

        public void removeNeighbor(Vertex vertex) {
            this.neighbors.remove(vertex);
        }

        public void addLowerNeighbor(Vertex vertex) {
            if (!this.lowerNeighbors.contains(vertex)) {
                this.lowerNeighbors.add(vertex);
            }
        }

        public void removeLowerNeighbor(Vertex vertex) {
            this.lowerNeighbors.remove(vertex);
        }

        public Collection<Vertex> getLowerNeighbors() {
            return Collections.unmodifiableCollection(this.lowerNeighbors);
        }

        public void addUpperNeighbor(Vertex vertex) {
            if (!this.upperNeighbors.contains(vertex)) {
                this.upperNeighbors.add(vertex);
            }
        }

        public void removeUpperNeighbor(Vertex vertex) {
            this.upperNeighbors.remove(vertex);
        }

        public Collection<Vertex> getUpperNeighbors() {
            return Collections.unmodifiableCollection(this.upperNeighbors);
        }

        public Collection<Vertex> getNeighbors() {
            return this.neighbors;
        }

        public N getNodeDesignElement() {
            return this.node;
        }

        public int getDegree() {
            return this.neighbors.size();
        }

        public void setVertexData(Object data) {
            this.vertexData = data;
        }

        public Object getVertexData() {
            return this.vertexData;
        }

        public String toString() {
            return super.toString() + " : " + this.node;
        }
    }
}

