/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild.extlibs;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public final class ConfigureProxy
extends Task {
    private URL connectTo;
    private String hostProperty = "http.proxyHost";
    private String portProperty = "http.proxyPort";

    public void setConnectTo(String uri) throws MalformedURLException {
        this.connectTo = new URL(uri);
    }

    public void setHostProperty(String host) {
        this.hostProperty = host;
    }

    public void setPortProperty(String port) {
        this.portProperty = port;
    }

    public void execute() throws BuildException {
        try {
            URI[] connectedVia = new URI[]{null};
            URLConnection connect = ConfigureProxy.openConnection(this, this.connectTo, connectedVia);
            if (connect == null) {
                throw new BuildException("Cannot connect to " + this.connectTo);
            }
            if (connectedVia[0] != null) {
                String host = connectedVia[0].getHost();
                this.log(String.format("Setting %s to %s", this.hostProperty, host), 2);
                this.getProject().setUserProperty(this.hostProperty, host);
                int port = connectedVia[0].getPort();
                this.log(String.format("Setting %s to %d", this.portProperty, port), 2);
                this.getProject().setUserProperty(this.portProperty, "" + port);
            } else {
                this.log(String.format("Resetting %s to empty string", this.hostProperty), 2);
                this.getProject().setUserProperty(this.hostProperty, "");
                this.getProject().setUserProperty(this.portProperty, "80");
            }
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    static URLConnection openConnection(Task task, URL url, URI[] connectedVia) throws IOException {
        URLConnection[] conn = new URLConnection[]{null};
        CopyOnWriteArrayList errs = new CopyOnWriteArrayList();
        CountDownLatch connected = new CountDownLatch(1);
        ExecutorService connectors = Executors.newFixedThreadPool(3);
        connectors.submit(() -> {
            String httpProxy = System.getenv("http_proxy");
            if (httpProxy != null) {
                try {
                    URI uri = new URI(httpProxy);
                    InetSocketAddress address = InetSocketAddress.createUnresolved(uri.getHost(), uri.getPort());
                    Proxy proxy = new Proxy(Proxy.Type.HTTP, address);
                    URLConnection test = url.openConnection(proxy);
                    test.connect();
                    conn[0] = test;
                    connected.countDown();
                    if (connectedVia != null) {
                        connectedVia[0] = uri;
                    }
                }
                catch (IOException | URISyntaxException ex) {
                    errs.add(ex);
                }
            }
        });
        connectors.submit(() -> {
            String httpProxy = System.getenv("https_proxy");
            if (httpProxy != null) {
                try {
                    URI uri = new URI(httpProxy);
                    InetSocketAddress address = InetSocketAddress.createUnresolved(uri.getHost(), uri.getPort());
                    Proxy proxy = new Proxy(Proxy.Type.HTTP, address);
                    URLConnection test = url.openConnection(proxy);
                    test.connect();
                    conn[0] = test;
                    connected.countDown();
                    if (connectedVia != null) {
                        connectedVia[0] = uri;
                    }
                }
                catch (IOException | URISyntaxException ex) {
                    errs.add(ex);
                }
            }
        });
        connectors.submit(() -> {
            try {
                URLConnection test = url.openConnection();
                test.connect();
                conn[0] = test;
                connected.countDown();
            }
            catch (IOException ex) {
                errs.add(ex);
            }
        });
        try {
            connected.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (conn[0] == null) {
            for (Exception ex : errs) {
                task.log((Throwable)ex, 0);
            }
            throw new IOException("Cannot connect to " + url);
        }
        return conn[0];
    }
}

