/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.action;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Logger;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.GeneratorUtilities;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.api.ejbjar.EnterpriseReferenceContainer;
import org.netbeans.modules.j2ee.api.ejbjar.MessageDestinationReference;
import org.netbeans.modules.j2ee.api.ejbjar.ResourceReference;
import org.netbeans.modules.j2ee.common.J2eeProjectCapabilities;
import org.netbeans.modules.j2ee.core.api.support.classpath.ContainerClassPathModifier;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.core.api.support.java.method.MethodModel;
import org.netbeans.modules.j2ee.core.api.support.java.method.MethodModelSupport;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJarMetadata;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.MessageDriven;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.MessageDestination;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.Utils;
import org.netbeans.modules.j2ee.ejbcore.ui.logicalview.entries.ServiceLocatorStrategy;
import org.netbeans.modules.j2ee.ejbcore.util._RetoucheUtil;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.javaee.injection.api.InjectionTargetQuery;
import org.netbeans.modules.web.beans.CdiUtil;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class SendJMSGenerator {
    private static final Logger LOG = Logger.getLogger(SendJMSGenerator.class.getName());
    private static final String PRODUCES = "Produces";
    private final MessageDestination messageDestination;
    private final Project mdbHolderProject;

    public SendJMSGenerator(MessageDestination messageDestination, Project mdbHolderProject) {
        this.messageDestination = messageDestination;
        this.mdbHolderProject = mdbHolderProject;
    }

    public void genMethods(EnterpriseReferenceContainer container, final String className, String connectionFactoryName, FileObject fileObject, ServiceLocatorStrategy slStrategy, J2eeModuleProvider j2eeModuleProvider) throws IOException {
        FileObject beansFile;
        CdiUtil util;
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        ContainerClassPathModifier ccpm = (ContainerClassPathModifier)project.getLookup().lookup(ContainerClassPathModifier.class);
        if (ccpm != null) {
            ccpm.extendClasspath(fileObject, new String[]{"j2ee-api"});
        }
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        final boolean[] isInjectionTarget = new boolean[1];
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){

            public void run(CompilationController controller) throws IOException {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = controller.getElements().getTypeElement(className);
                isInjectionTarget[0] = InjectionTargetQuery.isInjectionTarget((CompilationController)controller, (TypeElement)typeElement);
            }
        }, true);
        InjectionStrategy injectionStrategy = SendJMSGenerator.getInjectionStrategy(project, isInjectionTarget[0]);
        String destinationFieldName = null;
        String connectionFactoryFieldName = null;
        String factoryName = connectionFactoryName;
        String destinationName = null;
        if (injectionStrategy == InjectionStrategy.INJ_EE7_SOURCES && (util = (CdiUtil)project.getLookup().lookup(CdiUtil.class)) != null && (beansFile = util.enableCdi()) != null) {
            injectionStrategy = InjectionStrategy.INJ_EE7_CDI;
        }
        switch (injectionStrategy) {
            case NO_INJECT: {
                factoryName = this.generateConnectionFactoryReference(container, factoryName, fileObject, className);
                destinationName = this.generateDestinationReference(container, fileObject, className);
                break;
            }
            case INJ_EE7_SOURCES: 
            case INJ_COMMON: {
                destinationName = this.messageDestination.getName();
                connectionFactoryFieldName = this.createInjectedResource(fileObject, className, factoryName, "javax.jms.ConnectionFactory");
                destinationFieldName = this.createInjectedResource(fileObject, className, destinationName, this.messageDestination.getType() == MessageDestination.Type.QUEUE ? "javax.jms.Queue" : "javax.jms.Topic");
                break;
            }
            case INJ_EE7_CDI: {
                destinationName = this.messageDestination.getName();
                connectionFactoryFieldName = this.createInjectedFactory(fileObject, className, factoryName, "javax.jms.JMSContext");
                destinationFieldName = this.createInjectedResource(fileObject, className, destinationName, this.messageDestination.getType() == MessageDestination.Type.QUEUE ? "javax.jms.Queue" : "javax.jms.Topic");
            }
        }
        String sendMethodName = "";
        if (injectionStrategy != InjectionStrategy.INJ_EE7_CDI && injectionStrategy != InjectionStrategy.INJ_EE7_SOURCES) {
            sendMethodName = this.createSendMethod(fileObject, className, this.messageDestination.getName());
        }
        this.createJMSProducer(fileObject, className, factoryName, connectionFactoryFieldName, destinationName, destinationFieldName, sendMethodName, slStrategy, injectionStrategy);
        if (this.messageDestination != null && injectionStrategy != InjectionStrategy.INJ_EE7_CDI && injectionStrategy != InjectionStrategy.INJ_EE7_SOURCES) {
            try {
                if (j2eeModuleProvider.getJ2eeModule().getType().equals(J2eeModule.Type.WAR)) {
                    j2eeModuleProvider.getConfigSupport().bindMessageDestinationReference(this.messageDestination.getName(), factoryName, this.messageDestination.getName(), this.messageDestination.getType());
                } else if (j2eeModuleProvider.getJ2eeModule().getType().equals(J2eeModule.Type.EJB)) {
                    this.bindMessageDestinationReferenceForEjb(j2eeModuleProvider, fileObject, className, this.messageDestination.getName(), factoryName, this.messageDestination.getName(), this.messageDestination.getType());
                }
            }
            catch (ConfigurationException ce) {
                Exceptions.printStackTrace((Throwable)ce);
            }
        }
    }

    private void bindMessageDestinationReferenceForEjb(J2eeModuleProvider j2eeModuleProvider, FileObject fileObject, final String className, String referenceName, String connectionFactoryName, String destName, MessageDestination.Type destType) throws ConfigurationException, IOException {
        EjbJar ejbModule = EjbJar.getEjbJar((FileObject)fileObject);
        MetadataModel metadataModel = ejbModule.getMetadataModel();
        final String[] ejbName = new String[1];
        final String[] ejbType = new String[1];
        metadataModel.runReadAction((MetadataModelAction)new MetadataModelAction<EjbJarMetadata, Void>(){

            public Void run(EjbJarMetadata metadata) throws Exception {
                Ejb ejb = metadata.findByEjbClass(className);
                if (ejb != null) {
                    ejbName[0] = ejb.getEjbName();
                    if (ejb instanceof Session) {
                        ejbType[0] = "Session";
                    } else if (ejb instanceof MessageDriven) {
                        ejbType[0] = "MessageDriven";
                    } else if (ejb instanceof Entity) {
                        ejbType[0] = "Entity";
                    }
                }
                return null;
            }
        });
        if (ejbName[0] != null && ejbType[0] != null) {
            j2eeModuleProvider.getConfigSupport().bindMessageDestinationReferenceForEjb(ejbName[0], ejbType[0], referenceName, connectionFactoryName, destName, destType);
        }
    }

    private String generateConnectionFactoryReference(EnterpriseReferenceContainer container, String referenceName, FileObject referencingFile, String referencingClass) throws IOException {
        ResourceReference ref = ResourceReference.create((String)referenceName, (String)"javax.jms.ConnectionFactory", (String)"Container", (String)"Shareable", null);
        return container.addResourceRef(ref, referencingFile, referencingClass);
    }

    private String generateDestinationReference(EnterpriseReferenceContainer container, FileObject referencingFile, String referencingClass) throws IOException {
        ProjectInformation projectInformation = ProjectUtils.getInformation((Project)this.mdbHolderProject);
        String link = projectInformation.getName() + ".jar#" + this.messageDestination.getName();
        Project referenceingProject = FileOwnerQuery.getOwner((FileObject)referencingFile);
        if (this.mdbHolderProject.equals(referenceingProject)) {
            link = link.substring(link.indexOf(35) + 1);
        }
        MessageDestinationReference ref = MessageDestinationReference.create((String)this.messageDestination.getName(), (String)(this.messageDestination.getType() == MessageDestination.Type.QUEUE ? "javax.jms.Queue" : "javax.jms.Topic"), (String)PRODUCES, (String)link);
        return container.addDestinationRef(ref, referencingFile, referencingClass);
    }

    private String createInjectedResource(FileObject fileObject, String className, String destinationName, String fieldType) throws IOException {
        String fieldName = Utils.makeJavaIdentifierPart(Utils.jndiNameToCamelCase(destinationName, true, "jms"));
        _RetoucheUtil.generateAnnotatedField(fileObject, className, "javax.annotation.Resource", fieldName, fieldType, Collections.singletonMap("mappedName", destinationName), InjectionTargetQuery.isStaticReferenceRequired((FileObject)fileObject, (String)className));
        return fieldName;
    }

    private String createInjectedFactory(FileObject fileObject, String className, String destinationName, String fieldType) throws IOException {
        String fieldName = "context";
        final ElementHandle<VariableElement> field = _RetoucheUtil.generateAnnotatedField(fileObject, className, "javax.jms.JMSConnectionFactory", fieldName, fieldType, Collections.singletonMap("", destinationName), InjectionTargetQuery.isStaticReferenceRequired((FileObject)fileObject, (String)className));
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy parameter) throws Exception {
                parameter.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                GenerationUtils genUtils = GenerationUtils.newInstance((WorkingCopy)parameter);
                TreePath fieldTree = parameter.getTrees().getPath(field.resolve((CompilationInfo)parameter));
                VariableTree originalTree = (VariableTree)fieldTree.getLeaf();
                ModifiersTree modifiers = originalTree.getModifiers();
                ArrayList<? extends AnnotationTree> annotations = new ArrayList<AnnotationTree>(modifiers.getAnnotations());
                annotations.add(0, genUtils.createAnnotation("javax.inject.Inject"));
                ModifiersTree nueMods = parameter.getTreeMaker().Modifiers(modifiers, annotations);
                parameter.rewrite((Tree)modifiers, (Tree)nueMods);
            }
        }).commit();
        return fieldName;
    }

    private String createSendMethod(FileObject fileObject, final String className, String destination) throws IOException {
        MethodModel.Variable[] parameters = new MethodModel.Variable[]{MethodModel.Variable.create((String)"javax.jms.Session", (String)"session"), MethodModel.Variable.create((String)Object.class.getName(), (String)"messageData")};
        String methodName = "createJMSMessageFor" + Utils.makeJavaIdentifierPart(Utils.jndiNameToCamelCase(destination, true, null));
        final MethodModel methodModel = MethodModel.create((String)methodName, (String)"javax.jms.Message", (String)"// TODO create and populate message to send\njavax.jms.TextMessage tm = session.createTextMessage();\ntm.setText(messageData.toString());\nreturn tm;\n", Arrays.asList(parameters), Collections.singletonList("javax.jms.JMSException"), Collections.singleton(Modifier.PRIVATE));
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = workingCopy.getElements().getTypeElement(className);
                MethodTree methodTree = MethodModelSupport.createMethodTree((WorkingCopy)workingCopy, (MethodModel)methodModel);
                methodTree = (MethodTree)GeneratorUtilities.get((WorkingCopy)workingCopy).importFQNs((Tree)methodTree);
                ClassTree classTree = workingCopy.getTrees().getTree(typeElement);
                ClassTree newClassTree = workingCopy.getTreeMaker().addClassMember(classTree, (Tree)methodTree);
                workingCopy.rewrite((Tree)classTree, (Tree)newClassTree);
            }
        }).commit();
        return methodName;
    }

    private void createJMSProducer(FileObject fileObject, final String className, String connectionFactoryName, String connectionFactoryFieldName, String destinationName, String destinationFieldName, String sendMethodName, ServiceLocatorStrategy slStrategy, InjectionStrategy injectionStrategy) throws IOException {
        String body;
        String destName = Utils.makeJavaIdentifierPart(destinationName.substring(destinationName.lastIndexOf(47) + 1));
        StringBuffer destBuff = new StringBuffer(destName);
        destBuff.setCharAt(0, Character.toUpperCase(destBuff.charAt(0)));
        ArrayList<String> throwsClause = new ArrayList<String>();
        String parameterType = Object.class.getName();
        switch (injectionStrategy) {
            case INJ_EE7_CDI: {
                body = this.getSendJMSCodeForJMSContext(connectionFactoryFieldName, destinationFieldName);
                parameterType = String.class.getName();
                break;
            }
            case INJ_EE7_SOURCES: {
                body = this.getSendJMSCodeForCreatedJMSContext(connectionFactoryFieldName, destinationFieldName);
                parameterType = String.class.getName();
                break;
            }
            case INJ_COMMON: {
                throwsClause.add("javax.jms.JMSException");
                body = this.getSendJMSCodeWithInjectedFields(connectionFactoryFieldName, destinationFieldName, sendMethodName);
                break;
            }
            default: {
                throwsClause.add("javax.jms.JMSException");
                if (slStrategy == null) {
                    body = this.getSendJMSCode(connectionFactoryName, destinationName, sendMethodName);
                    throwsClause.add("javax.naming.NamingException");
                    break;
                }
                body = this.getSendJMSCode(connectionFactoryName, destinationName, sendMethodName, slStrategy, fileObject, className);
            }
        }
        final MethodModel methodModel = MethodModel.create((String)("sendJMSMessageTo" + destBuff), (String)"void", (String)body, Collections.singletonList(MethodModel.Variable.create((String)parameterType, (String)"messageData")), throwsClause, Collections.singleton(Modifier.PRIVATE));
        JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
        javaSource.runModificationTask((Task)new Task<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement typeElement = workingCopy.getElements().getTypeElement(className);
                MethodTree methodTree = MethodModelSupport.createMethodTree((WorkingCopy)workingCopy, (MethodModel)methodModel);
                methodTree = (MethodTree)GeneratorUtilities.get((WorkingCopy)workingCopy).importFQNs((Tree)methodTree);
                ClassTree classTree = workingCopy.getTrees().getTree(typeElement);
                ClassTree newClassTree = workingCopy.getTreeMaker().addClassMember(classTree, (Tree)methodTree);
                workingCopy.rewrite((Tree)classTree, (Tree)newClassTree);
            }
        }).commit();
    }

    private String getSendJMSCodeWithInjectedFields(String connectionFactoryFieldName, String destinationFieldName, String messageMethodName) {
        return MessageFormat.format("javax.jms.Connection connection = null;\njavax.jms.Session session = null;\ntry '{' \nconnection = {0}.createConnection();\nsession = connection.createSession(false,javax.jms.Session.AUTO_ACKNOWLEDGE);\njavax.jms.MessageProducer messageProducer = session.createProducer({1});\nmessageProducer.send({2}(session, messageData));\n '}' finally '{'\nif (session != null) '{'\ntry '{'\n session.close();\n'}' catch (JMSException e) '{'\njava.util.logging.Logger.getLogger(this.getClass().getName()).log(java.util.logging.Level.WARNING, \"Cannot close session\", e);\n'}'\n'}'\nif (connection != null) '{'\nconnection.close();\n'}'\n'}'\n", connectionFactoryFieldName, destinationFieldName, messageMethodName);
    }

    private String getSendJMSCodeForJMSContext(String contextFieldName, String destinationFieldName) {
        return MessageFormat.format("{0}.createProducer().send({1}, messageData);", contextFieldName, destinationFieldName);
    }

    private String getSendJMSCodeForCreatedJMSContext(String connectionFactoryFieldName, String destinationFieldName) {
        return MessageFormat.format("try (javax.jms.JMSContext context = {0}.createContext()) '{'\ncontext.createProducer().send({1}, messageData);\n'}'\n", connectionFactoryFieldName, destinationFieldName);
    }

    private String getSendJMSCode(String connectionName, String destinationName, String messageMethodName, ServiceLocatorStrategy sls, FileObject fileObject, String className) {
        String connectionFactory = sls.genJMSFactory(connectionName, fileObject, className);
        String destination = sls.genDestinationLookup(destinationName, fileObject, className);
        return MessageFormat.format("javax.jms.ConnectionFactory cf = (javax.jms.ConnectionFactory) " + connectionFactory + ";\njavax.jms.Connection conn = null;\njavax.jms.Session s = null;\ntry '{' \nconn = cf.createConnection();\ns = conn.createSession(false,s.AUTO_ACKNOWLEDGE);\njavax.jms.Destination destination = (javax.jms.Destination) " + destination + ";\njavax.jms.MessageProducer mp = s.createProducer(destination);\nmp.send({2}(s,messageData));\n '}' finally '{'\nif (s != null) '{'\ntry '{'\n s.close();\n'}' catch (JMSException e) '{'\njava.util.logging.Logger.getLogger(this.getClass().getName()).log(java.util.logging.Level.WARNING, \"Cannot close session\", e);\n'}'\n'}'\nif (conn != null) '{'\nconn.close();\n'}'\n'}'\n", connectionName, destinationName, messageMethodName);
    }

    private String getSendJMSCode(String connectionName, String destinationName, String messageMethodName) {
        return MessageFormat.format("javax.naming.Context c = new javax.naming.InitialContext();\njavax.jms.ConnectionFactory cf = (javax.jms.ConnectionFactory) c.lookup(\"java:comp/env/{0}\");\njavax.jms.Connection conn = null;\njavax.jms.Session s = null;\ntry '{' \nconn = cf.createConnection();\ns = conn.createSession(false,s.AUTO_ACKNOWLEDGE);\njavax.jms.Destination destination = (javax.jms.Destination) c.lookup(\"java:comp/env/{1}\");\njavax.jms.MessageProducer mp = s.createProducer(destination);\nmp.send({2}(s,messageData));\n '}' finally '{'\nif (s != null) '{'\ntry '{'\n s.close();\n'}' catch (JMSException e) '{'\njava.util.logging.Logger.getLogger(this.getClass().getName()).log(java.util.logging.Level.WARNING, \"Cannot close session\", e);\n'}'\n'}'\nif (conn != null) '{'\nconn.close();\n'}'\n'}'\n", connectionName, destinationName, messageMethodName);
    }

    public static InjectionStrategy getInjectionStrategy(Project project, boolean injectable) {
        if (!injectable) {
            return InjectionStrategy.NO_INJECT;
        }
        J2eeProjectCapabilities capabilities = J2eeProjectCapabilities.forProject((Project)project);
        if (!capabilities.isEjb32LiteSupported()) {
            return InjectionStrategy.INJ_COMMON;
        }
        CdiUtil cdiUtil = (CdiUtil)project.getLookup().lookup(CdiUtil.class);
        if (cdiUtil.isCdiEnabled()) {
            return InjectionStrategy.INJ_EE7_CDI;
        }
        return InjectionStrategy.INJ_EE7_SOURCES;
    }

    public static enum InjectionStrategy {
        INJ_EE7_CDI,
        INJ_EE7_SOURCES,
        INJ_COMMON,
        NO_INJECT;

    }
}

