/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seembedded.project;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.modules.java.j2seembedded.project.Utilities;
import org.netbeans.spi.project.ant.GeneratedFilesInterceptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Parameters;

public class RemoteGeneratedFilesInterceptor
implements GeneratedFilesInterceptor {
    private static final Logger LOG = Logger.getLogger(RemoteGeneratedFilesInterceptor.class.getName());
    private final Project prj;

    public RemoteGeneratedFilesInterceptor(@NonNull Project prj) {
        Parameters.notNull((CharSequence)"prj", (Object)prj);
        this.prj = prj;
    }

    public void fileGenerated(@NonNull Project project, @NonNull String path) {
        if ("nbproject/build-impl.xml".equals(path)) {
            AntBuildExtender extender = (AntBuildExtender)this.prj.getLookup().lookup(AntBuildExtender.class);
            if (extender == null) {
                LOG.log(Level.WARNING, "The project: {0} ({1}) has no AntBuildExtender.", new Object[]{ProjectUtils.getInformation((Project)this.prj).getDisplayName(), FileUtil.getFileDisplayName((FileObject)this.prj.getProjectDirectory())});
                return;
            }
            RemoteGeneratedFilesInterceptor.runDeferred(new Runnable(){

                @Override
                public void run() {
                    try {
                        RemoteGeneratedFilesInterceptor.this.updateBuildScript();
                    }
                    catch (IOException ioe) {
                        Exceptions.printStackTrace((Throwable)ioe);
                    }
                }
            });
        }
    }

    private static void runDeferred(final @NonNull Runnable r) {
        Parameters.notNull((CharSequence)"r", (Object)r);
        ProjectManager.mutex().postReadRequest(new Runnable(){

            @Override
            public void run() {
                ProjectManager.mutex().postWriteRequest(r);
            }
        });
    }

    private void updateBuildScript() throws IOException {
        if (Utilities.hasRemoteExtension(this.prj)) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "The project {0} ({1}) already has a current version of remote platform extension.", new Object[]{ProjectUtils.getInformation((Project)this.prj).getDisplayName(), FileUtil.getFileDisplayName((FileObject)this.prj.getProjectDirectory())});
            }
            return;
        }
        if (Utilities.removeOldRemoteExtensions(this.prj)) {
            Utilities.addRemoteExtension(this.prj);
        }
    }
}

